/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.event.AbstractGTComponent;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.SelectedChannelType;

public class ChannelSelectionImpl
extends AbstractGTComponent
implements ChannelSelection {
    private SelectedChannelType gray;
    private SelectedChannelType red;
    private SelectedChannelType blue;
    private SelectedChannelType green;

    public SelectedChannelType getGrayChannel() {
        return this.gray;
    }

    public SelectedChannelType[] getRGBChannels() {
        return new SelectedChannelType[]{this.red, this.green, this.blue};
    }

    public SelectedChannelType[] getSelectedChannels() {
        SelectedChannelType[] ret = this.gray == null ? new SelectedChannelType[]{this.red, this.green, this.blue} : new SelectedChannelType[]{this.gray};
        return ret;
    }

    public void setGrayChannel(SelectedChannelType gray) {
        this.gray = gray;
        this.fireChanged();
    }

    public void setRGBChannels(SelectedChannelType[] channels) {
        if (channels.length != 3) {
            throw new IllegalArgumentException("Three channels are required in setRGBChannels, got " + channels.length);
        }
        this.red = channels[0];
        this.green = channels[1];
        this.blue = channels[2];
        this.fireChanged();
    }

    public void setRGBChannels(SelectedChannelType red, SelectedChannelType green, SelectedChannelType blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.fireChanged();
    }

    public void setSelectedChannels(SelectedChannelType[] channels) {
        if (channels.length == 1) {
            this.gray = channels[0];
        } else if (channels.length == 3) {
            this.red = channels[0];
            this.green = channels[1];
            this.blue = channels[2];
        } else {
            throw new IllegalArgumentException("Wrong number of elements in setSelectedChannels, expected 1 or 3, got " + channels.length);
        }
        this.fireChanged();
    }
}

