/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml;

import com.vividsolutions.jts.geom.Geometry;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import java.util.logging.Logger;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.gml.GMLHandlerFeature;
import org.geotools.gml.GMLHandlerJTS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class GMLFilterFeature
extends XMLFilterImpl
implements GMLHandlerJTS {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.gml");
    private GMLHandlerFeature parent;
    private Vector attributes = new Vector();
    private Vector attributeNames = new Vector();
    private String fid = null;
    private boolean insideAttribute = false;
    private boolean insideFeature = false;
    private Object tempValue = null;
    private String attName = "";
    private String NAMESPACE;
    private String typeName = "GenericFeature";
    private StringBuffer characters = new StringBuffer();

    public GMLFilterFeature(GMLHandlerFeature parent) {
        this.parent = parent;
    }

    public void setSchema(String uri) {
    }

    public void geometry(Geometry geometry) {
        if (this.insideFeature) {
            if (this.attName.equals("")) {
                this.attributeNames.addElement("geometry");
            } else {
                this.attributeNames.addElement(this.attName);
            }
            this.attributes.addElement(geometry);
            this.endAttribute();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.characters.setLength(0);
        if (localName.endsWith("Collection")) {
            this.NAMESPACE = namespaceURI;
            return;
        }
        if (this.isFeatureMember(localName)) {
            this.attributes = new Vector();
            this.attributeNames = new Vector();
            this.insideFeature = true;
            this.tempValue = null;
        } else {
            if (this.insideFeature) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String name = atts.getLocalName(i);
                    if (name.equalsIgnoreCase("fid")) {
                        this.typeName = new String(localName);
                        this.fid = atts.getValue(i);
                        continue;
                    }
                    this.attributes.add(atts.getValue(i));
                    this.attributeNames.add(name);
                }
                if (!this.typeName.equalsIgnoreCase(localName)) {
                    this.attName = this.attName.equals("") ? localName : this.attName + "/" + localName;
                }
                this.insideAttribute = true;
                return;
            }
            if (!this.insideAttribute) {
                this.parent.startElement(namespaceURI, localName, qName, atts);
            }
        }
    }

    private boolean isFeatureMember(String localName) {
        return localName.endsWith("Member") && !localName.endsWith("StringMember") && !localName.endsWith("polygonMember") && !localName.endsWith("pointMember");
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    private void handleCharacters() throws SAXException {
        block8: {
            if (this.characters.length() == 0) {
                return;
            }
            String rawAttribute = this.characters.toString().trim();
            this.characters.setLength(0);
            if (this.insideAttribute && !rawAttribute.equals("")) {
                LOGGER.info("raw att = " + rawAttribute);
                try {
                    this.tempValue = new Integer(rawAttribute);
                }
                catch (NumberFormatException e1) {
                    try {
                        this.tempValue = new Double(rawAttribute);
                    }
                    catch (NumberFormatException e2) {
                        if (this.tempValue instanceof StringBuffer) {
                            ((StringBuffer)this.tempValue).append(" " + rawAttribute);
                            break block8;
                        }
                        this.tempValue = new StringBuffer(rawAttribute);
                    }
                }
            } else {
                this.parent.characters(rawAttribute.toCharArray(), 0, rawAttribute.length());
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.handleCharacters();
        if (this.isFeatureMember(localName)) {
            FeatureTypeFactory factory = FeatureTypeFactory.newInstance(this.typeName);
            int ii = this.attributes.size();
            for (int i = 0; i < ii; ++i) {
                String name = (String)this.attributeNames.get(i);
                Class<?> clazz = this.attributes.get(i).getClass();
                factory.addType(AttributeTypeFactory.newAttributeType(name, clazz));
            }
            try {
                factory.setNamespace(new URI(namespaceURI));
            }
            catch (URISyntaxException e) {
                LOGGER.warning(e.toString());
                throw new SAXException(e);
            }
            try {
                Feature feature = factory.getFeatureType().create(this.attributes.toArray(), this.fid);
                this.parent.feature(feature);
            }
            catch (SchemaException sve) {
            }
            catch (IllegalAttributeException ife) {
                // empty catch block
            }
            this.attName = "";
            this.insideFeature = false;
        } else if (this.insideAttribute) {
            if (this.tempValue != null && !this.tempValue.toString().trim().equals("")) {
                if (this.tempValue instanceof StringBuffer) {
                    this.tempValue = this.tempValue.toString();
                }
                this.attributes.add(this.tempValue);
                this.attributeNames.add(this.attName);
                this.tempValue = null;
            }
            this.endAttribute();
        } else {
            this.parent.endElement(namespaceURI, localName, qName);
        }
    }

    private void endAttribute() {
        int index = this.attName.lastIndexOf(47);
        this.attName = index > -1 ? this.attName.substring(0, index) : "";
        this.insideAttribute = false;
    }
}

