/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import org.geotools.gml.GMLHandlerGeometry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class GMLFilterDocument
extends XMLFilterImpl {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.gml");
    private static final String GML_NAMESPACE = "http://www.opengis.net/gml";
    private static final String COORD_NAME = "coord";
    private static final String COORDINATES_NAME = "coordinates";
    private static final String X_NAME = "X";
    private static final String Y_NAME = "Y";
    private static final String Z_NAME = "Z";
    private static final Collection SUB_GEOMETRY_TYPES = new Vector<String>(Arrays.asList("outerBoundaryIs", "innerBoundaryIs"));
    private static final Collection BASE_GEOMETRY_TYPES = new Vector<String>(Arrays.asList("Point", "LineString", "Polygon", "LinearRing", "Box", "MultiPoint", "MultiLineString", "MultiPolygon", "GeometryCollection"));
    private StringBuffer buffer = new StringBuffer();
    private GMLHandlerGeometry parent;
    private CoordinateReader coordinateReader = new CoordinateReader();
    private boolean namespaceAware = true;

    public GMLFilterDocument(GMLHandlerGeometry parent) {
        LOGGER.entering("GMLFilterDocument", "new", parent);
        this.parent = parent;
        LOGGER.exiting("GMLFilterDocument", "new");
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        LOGGER.entering("GMLFilterDocument", "startElement", new Object[]{namespaceURI, localName, qName, atts});
        if (namespaceURI != null && namespaceURI.equals(GML_NAMESPACE)) {
            if (BASE_GEOMETRY_TYPES.contains(localName)) {
                this.parent.geometryStart(localName, atts);
            } else if (SUB_GEOMETRY_TYPES.contains(localName)) {
                this.parent.geometrySub(localName);
            } else if (COORDINATES_NAME.equals(localName)) {
                this.coordinateReader.insideCoordinates(true, atts);
                this.buffer = new StringBuffer();
            } else if (COORD_NAME.equals(localName)) {
                this.coordinateReader.insideCoord(true);
                this.buffer = new StringBuffer();
            } else if (X_NAME.equals(localName)) {
                this.buffer = new StringBuffer();
                this.coordinateReader.insideX(true);
            } else if (Y_NAME.equals(localName)) {
                this.buffer = new StringBuffer();
                this.coordinateReader.insideY(true);
            } else if (Z_NAME.equals(localName)) {
                this.buffer = new StringBuffer();
                this.coordinateReader.insideZ(true);
            } else {
                this.parent.startElement(namespaceURI, localName, qName, atts);
            }
        } else {
            this.parent.startElement(namespaceURI, localName, qName, atts);
        }
        LOGGER.exiting("GMLFilterDocument", "startElement");
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        LOGGER.entering("GMLFilterDocument", "characters", new Object[]{ch, new Integer(start), new Integer(length)});
        String rawCoordinates = new String(ch, start, length);
        if (this.coordinateReader.insideCoordinates()) {
            this.buffer.append(rawCoordinates);
        } else if (this.coordinateReader.insideCoord()) {
            this.buffer.append(rawCoordinates);
        } else {
            this.parent.characters(ch, start, length);
        }
        LOGGER.exiting("GMLFilterDocument", "characters");
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        LOGGER.entering("GMLFilterDocument", "endElement", new Object[]{namespaceURI, localName, qName});
        if (namespaceURI.equals(GML_NAMESPACE) || !this.namespaceAware) {
            if (BASE_GEOMETRY_TYPES.contains(localName)) {
                this.parent.geometryEnd(localName);
            } else if (SUB_GEOMETRY_TYPES.contains(localName)) {
                this.parent.geometrySub(localName);
            } else if (COORDINATES_NAME.equals(localName)) {
                this.coordinateReader.readCoordinates(this.buffer.toString());
                this.coordinateReader.insideCoordinates(false);
            } else if (COORD_NAME.equals(localName)) {
                this.coordinateReader.readCoord(this.buffer.toString());
                this.coordinateReader.insideCoord(false);
            } else if (X_NAME.equals(localName)) {
                this.coordinateReader.readCoord(this.buffer.toString());
                this.coordinateReader.insideX(false);
            } else if (Y_NAME.equals(localName)) {
                this.coordinateReader.readCoord(this.buffer.toString());
                this.coordinateReader.insideY(false);
            } else if (Z_NAME.equals(localName)) {
                this.coordinateReader.readCoord(this.buffer.toString());
                this.coordinateReader.insideZ(false);
            } else if (!this.namespaceAware) {
                this.parent.endElement(namespaceURI, localName, qName);
            } else {
                this.parent.endElement(namespaceURI, localName, qName);
            }
        } else {
            this.parent.endElement(namespaceURI, localName, qName);
        }
        LOGGER.exiting("GMLFilterDocument", "endElement");
    }

    private class CoordinateReader {
        private static final int NOT_INSIDE = 0;
        private static final int INSIDE_COORD = 1;
        private static final int INSIDE_COORDINATES = 2;
        private static final int INSIDE_X = 1;
        private static final int INSIDE_Y = 2;
        private static final int INSIDE_Z = 3;
        private int insideOuterFlag = 0;
        private int insideInnerFlag = 0;
        private Double x = new Double(Double.NaN);
        private Double y = new Double(Double.NaN);
        private Double z = new Double(Double.NaN);
        private String coordinateDelimeter = ",";
        private String tupleDelimeter = " ";
        private StringBuffer decimalDelimeter = new StringBuffer(".");
        private boolean standardDecimalFlag = true;

        public void readCoordinates(String coordinateString) throws SAXException {
            if (!this.standardDecimalFlag) {
                coordinateString = coordinateString.replace(this.decimalDelimeter.charAt(0), '.');
            }
            StringTokenizer coordinateSets = new StringTokenizer(coordinateString.trim(), this.tupleDelimeter);
            while (coordinateSets.hasMoreElements()) {
                StringTokenizer coordinates = new StringTokenizer(coordinateSets.nextToken(), this.coordinateDelimeter);
                this.x = new Double(coordinates.nextToken().trim());
                this.y = new Double(coordinates.nextToken().trim());
                if (coordinates.hasMoreElements()) {
                    this.z = new Double(coordinates.nextToken().trim());
                    GMLFilterDocument.this.parent.gmlCoordinates(this.x, this.y, this.z);
                    continue;
                }
                GMLFilterDocument.this.parent.gmlCoordinates(this.x, this.y);
            }
        }

        public void readCoord(String coordString) {
            if (!this.standardDecimalFlag) {
                coordString = coordString.replace(this.decimalDelimeter.charAt(0), '.');
            }
            switch (this.insideInnerFlag) {
                case 1: {
                    this.x = new Double(coordString.trim());
                    break;
                }
                case 2: {
                    this.y = new Double(coordString.trim());
                    break;
                }
                case 3: {
                    this.z = new Double(coordString.trim());
                    break;
                }
            }
        }

        public void insideCoordinates(boolean isInside, Attributes atts) {
            this.insideCoordinates(isInside);
        }

        public void insideCoordinates(boolean isInside) {
            this.insideOuterFlag = isInside ? 2 : 0;
        }

        public void insideCoord(boolean isInside) throws SAXException {
            if (isInside) {
                this.insideOuterFlag = 1;
            } else {
                if (!this.x.isNaN() && !this.y.isNaN() && this.z.isNaN()) {
                    GMLFilterDocument.this.parent.gmlCoordinates(this.x, this.y);
                } else if (!(this.x.isNaN() || this.y.isNaN() || this.z.isNaN())) {
                    GMLFilterDocument.this.parent.gmlCoordinates(this.x, this.y, this.z);
                }
                this.x = new Double(Double.NaN);
                this.y = new Double(Double.NaN);
                this.z = new Double(Double.NaN);
                this.insideOuterFlag = 0;
            }
        }

        public void insideX(boolean isInside) {
            this.insideInnerFlag = isInside ? 1 : 0;
        }

        public void insideY(boolean isInside) {
            this.insideInnerFlag = isInside ? 2 : 0;
        }

        public void insideZ(boolean isInside) {
            this.insideInnerFlag = isInside ? 3 : 0;
        }

        public boolean insideCoordinates() {
            return this.insideOuterFlag == 2;
        }

        public boolean insideCoord() {
            return this.insideOuterFlag == 1;
        }
    }
}

