/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.coordinatesequence;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequence;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.geotools.geometry.coordinatesequence.CSBuilder;

public abstract class PackedCSBuilder
implements CSBuilder {
    int size = -1;
    int dimensions = -1;

    public int getSize() {
        return this.size;
    }

    public int getDimension() {
        return this.dimensions;
    }

    public static class Float
    extends PackedCSBuilder {
        float[] ordinates;
        PackedCoordinateSequenceFactory factory = new PackedCoordinateSequenceFactory(1);

        public void start(int size, int dimensions) {
            this.ordinates = new float[size * dimensions];
            this.size = size;
            this.dimensions = dimensions;
        }

        public CoordinateSequence end() {
            CoordinateSequence cs = this.factory.create(this.ordinates, this.dimensions);
            this.ordinates = null;
            this.size = -1;
            this.dimensions = -1;
            return cs;
        }

        public void setOrdinate(double value, int ordinateIndex, int coordinateIndex) {
            this.ordinates[coordinateIndex * this.dimensions + ordinateIndex] = (float)value;
        }

        public void setOrdinate(CoordinateSequence sequence, double value, int ordinateIndex, int coordinateIndex) {
            PackedCoordinateSequence pcs = (PackedCoordinateSequence)sequence;
            pcs.setOrdinate(coordinateIndex, ordinateIndex, value);
        }

        public double getOrdinate(int ordinateIndex, int coordinateIndex) {
            return this.ordinates[coordinateIndex * this.dimensions + ordinateIndex];
        }
    }

    public static class Double
    extends PackedCSBuilder {
        double[] ordinates;
        PackedCoordinateSequenceFactory factory = new PackedCoordinateSequenceFactory(0);

        public void start(int size, int dimensions) {
            this.ordinates = new double[size * dimensions];
            this.size = size;
            this.dimensions = dimensions;
        }

        public CoordinateSequence end() {
            CoordinateSequence cs = this.factory.create(this.ordinates, this.dimensions);
            this.ordinates = null;
            this.size = -1;
            this.dimensions = -1;
            return cs;
        }

        public void setOrdinate(double value, int ordinateIndex, int coordinateIndex) {
            this.ordinates[coordinateIndex * this.dimensions + ordinateIndex] = value;
        }

        public double getOrdinate(int ordinateIndex, int coordinateIndex) {
            return this.ordinates[coordinateIndex * this.dimensions + ordinateIndex];
        }

        public void setOrdinate(CoordinateSequence sequence, double value, int ordinateIndex, int coordinateIndex) {
            PackedCoordinateSequence pcs = (PackedCoordinateSequence)sequence;
            pcs.setOrdinate(coordinateIndex, ordinateIndex, value);
        }
    }
}

