/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.Iterator;
import java.util.logging.Logger;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;

public class AbstractFilterVisitor
implements FilterVisitor {
    private static Logger LOGGER = Logger.getLogger("org.geotools.filter.visitor");

    public void visit(Filter filter) {
    }

    public void visit(BetweenFilter filter) {
        if (filter.getLeftValue() != null) {
            filter.getLeftValue().accept((FilterVisitor)this);
        }
        if (filter.getMiddleValue() != null) {
            filter.getMiddleValue().accept((FilterVisitor)this);
        }
        if (filter.getRightValue() != null) {
            filter.getRightValue().accept((FilterVisitor)this);
        }
    }

    public void visit(CompareFilter filter) {
        if (filter.getLeftValue() != null) {
            filter.getLeftValue().accept((FilterVisitor)this);
        }
        if (filter.getRightValue() != null) {
            filter.getRightValue().accept((FilterVisitor)this);
        }
    }

    public void visit(GeometryFilter filter) {
        if (filter.getLeftGeometry() != null) {
            filter.getLeftGeometry().accept((FilterVisitor)this);
        }
        if (filter.getRightGeometry() != null) {
            filter.getRightGeometry().accept((FilterVisitor)this);
        }
    }

    public void visit(LikeFilter filter) {
        if (filter.getValue() != null) {
            filter.getValue().accept((FilterVisitor)this);
        }
    }

    public void visit(LogicFilter filter) {
        Iterator it = filter.getFilterIterator();
        while (it.hasNext()) {
            Filter f = (Filter)it.next();
            f.accept((FilterVisitor)this);
        }
    }

    public void visit(NullFilter filter) {
        if (filter.getNullCheckValue() != null) {
            filter.getNullCheckValue().accept((FilterVisitor)this);
        }
    }

    public void visit(FidFilter filter) {
    }

    public void visit(AttributeExpression expression) {
    }

    public void visit(Expression expression) {
    }

    public void visit(LiteralExpression expression) {
    }

    public void visit(MathExpression expression) {
        if (expression.getLeftValue() != null) {
            expression.getLeftValue().accept((FilterVisitor)this);
        }
        if (expression.getRightValue() != null) {
            expression.getRightValue().accept((FilterVisitor)this);
        }
    }

    public void visit(FunctionExpression expression) {
        Expression[] args = expression.getArgs();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            args[i].accept((FilterVisitor)this);
        }
    }
}

