/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.feature.Feature;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.GeometryFilterImpl;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;

public class BBOXImpl
extends GeometryFilterImpl
implements BBOX {
    double minx;
    double miny;
    double maxx;
    double maxy;
    String propertyName;
    String srs;

    public BBOXImpl(FilterFactory factory, Expression e1, Expression e2) {
        super(factory, e1, e2);
        this.filterType = (short)4;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getSRS() {
        return this.srs;
    }

    public void setSRS(String srs) {
        this.srs = srs;
    }

    public double getMinX() {
        return this.minx;
    }

    public void setMinX(double minx) {
        this.minx = minx;
    }

    public double getMinY() {
        return this.miny;
    }

    public void setMinY(double miny) {
        this.miny = miny;
    }

    public double getMaxX() {
        return this.maxx;
    }

    public void setMaxX(double maxx) {
        this.maxx = maxx;
    }

    public double getMaxY() {
        return this.maxy;
    }

    public void setMaxY(double miny) {
        this.miny = miny;
    }

    public boolean evaluate(Feature feature) {
        if (!this.validate(feature)) {
            return false;
        }
        Geometry left = this.getLeftGeometry(feature);
        Geometry right = this.getRightGeometry(feature);
        Envelope envLeft = left.getEnvelopeInternal();
        Envelope envRight = right.getEnvelopeInternal();
        if (envRight.contains(envLeft) || envLeft.contains(envRight)) {
            return true;
        }
        if (envRight.intersects(envLeft)) {
            return left.intersects(right);
        }
        return false;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((BBOX)this, extraData);
    }
}

