/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.LiteralExpression;
import org.geotools.util.ProgressListener;

public abstract class ClassificationFunction
extends FunctionExpressionImpl
implements FunctionExpression {
    FeatureCollection fc = null;
    int classNum;
    Expression expr;
    ProgressListener progress;

    public int getArgCount() {
        return 2;
    }

    public int getNumberOfClasses() {
        return this.classNum;
    }

    public void setNumberOfClasses(int i) {
        this.classNum = i;
    }

    public FeatureCollection getCollection() {
        return this.fc;
    }

    public void setCollection(FeatureCollection fc) {
        this.fc = fc;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public void setExpression(Expression e) {
        this.expr = e;
    }

    public ProgressListener getProgressListener() {
        return this.progress;
    }

    public void setProgressListener(ProgressListener progress) {
        this.progress = progress;
    }

    public Expression[] getArgs() {
        Expression[] ret = new Expression[2];
        ret[0] = this.expr;
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        ret[1] = ff.createLiteralExpression(this.classNum);
        return ret;
    }

    public abstract String getName();

    public void setArgs(Expression[] args) {
        this.expr = args[0];
        this.classNum = ((Number)((LiteralExpression)args[1]).getLiteral()).intValue();
    }

    public abstract Object evaluate(Feature var1);

    public Object getValue(int index) {
        return null;
    }

    protected int decimalPlaces(double slotWidth) {
        int val = new Double(Math.log(1.0 / slotWidth) / 2.0).intValue();
        if (val < 0) {
            return 0;
        }
        return val + 1;
    }

    protected double round(double value, int decimalPlaces) {
        double divisor = Math.pow(10.0, decimalPlaces);
        double newVal = value * divisor;
        newVal = (double)new Long(Math.round(newVal)).intValue() / divisor;
        return newVal;
    }

    protected double fixRound(double value, int decimalPlaces, boolean up) {
        double divisor = Math.pow(10.0, decimalPlaces);
        double newVal = value * divisor;
        newVal = up ? (newVal += 1.0) : (newVal -= 1.0);
        return newVal /= divisor;
    }
}

