/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import org.geotools.feature.Feature;
import org.geotools.filter.Filters;
import org.geotools.filter.MathExpressionImpl;
import org.geotools.resources.Utilities;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Subtract;

public class SubtractImpl
extends MathExpressionImpl
implements Subtract {
    public SubtractImpl(Expression expr1, Expression expr2) {
        super(expr1, expr2);
        this.expressionType = (short)106;
    }

    public Object evaluate(Feature feature) throws IllegalArgumentException {
        this.ensureOperandsSet();
        double leftDouble = Filters.number(this.getExpression1().evaluate((Object)feature));
        double rightDouble = Filters.number(this.getExpression2().evaluate((Object)feature));
        return this.number(leftDouble - rightDouble);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Subtract)this, extraData);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SubtractImpl) {
            SubtractImpl other = (SubtractImpl)obj;
            return Utilities.equals((Object)this.getExpression1(), (Object)other.getExpression1()) && Utilities.equals((Object)this.getExpression2(), (Object)other.getExpression2());
        }
        return false;
    }

    public int hashCode() {
        int result = 23;
        result = 37 * result + this.getExpression1().hashCode();
        result = 37 * result + this.getExpression2().hashCode();
        return result;
    }

    public String toString() {
        return "(" + this.getExpression1().toString() + "-" + this.getExpression2().toString() + ")";
    }
}

