/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.filter.BinaryLogicAbstract;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LogicFilter;
import org.opengis.filter.FilterVisitor;

public abstract class LogicFilterImpl
extends BinaryLogicAbstract
implements LogicFilter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");

    protected LogicFilterImpl(FilterFactory factory) {
        this(factory, new ArrayList());
    }

    protected LogicFilterImpl(FilterFactory factory, List children) {
        super(factory, children);
    }

    protected LogicFilterImpl(short filterType) throws IllegalFilterException {
        super(FilterFactoryFinder.createFilterFactory(), new ArrayList());
        LOGGER.finest("filtertype " + filterType);
        if (!LogicFilterImpl.isLogicFilter(filterType)) {
            throw new IllegalFilterException("Attempted to create logic filter with non-logic type.");
        }
        this.filterType = filterType;
    }

    protected LogicFilterImpl(Filter filter, short filterType) throws IllegalFilterException {
        super(FilterFactoryFinder.createFilterFactory(), new ArrayList());
        if (!LogicFilterImpl.isLogicFilter(filterType)) {
            throw new IllegalFilterException("Attempted to create logic filter with non-logic type.");
        }
        this.filterType = filterType;
        this.children.add(filter);
    }

    protected LogicFilterImpl(Filter filter1, Filter filter2, short filterType) throws IllegalFilterException {
        super(FilterFactoryFinder.createFilterFactory(), new ArrayList());
        if (!LogicFilterImpl.isLogicFilter(filterType)) {
            throw new IllegalFilterException("Attempted to create logic filter with non-logic type.");
        }
        this.filterType = filterType;
        this.children.add(filter1);
        this.addFilter(filter2);
    }

    public final void addFilter(Filter filter) throws IllegalFilterException {
        if (this.filterType == 3 && this.children.size() != 0) {
            throw new IllegalFilterException("Attempted to add an more than one filter to a NOT filter.");
        }
        this.children.add(filter);
    }

    public Iterator getFilterIterator() {
        return this.children.iterator();
    }

    public abstract boolean evaluate(Feature var1);

    public Filter or(Filter filter) {
        if (this.filterType == 1) {
            this.children.add(filter);
            return this;
        }
        return super.or(filter);
    }

    public Filter and(Filter filter) {
        if (this.filterType == 2) {
            this.children.add(filter);
            return this;
        }
        return super.and(filter);
    }

    public Filter not() {
        if (this.filterType == 3) {
            return (Filter)this.children.get(0);
        }
        return super.not();
    }

    List getSubFilters() {
        return this.children;
    }

    public String toString() {
        String returnString = "[";
        String operator = "";
        Iterator iterator = this.children.iterator();
        if (this.filterType == 1) {
            operator = " OR ";
        } else if (this.filterType == 2) {
            operator = " AND ";
        } else if (this.filterType == 3) {
            return "NOT " + ((Filter)iterator.next()).toString();
        }
        while (iterator.hasNext()) {
            returnString = returnString + ((Filter)iterator.next()).toString();
            if (!iterator.hasNext()) continue;
            returnString = returnString + operator;
        }
        return returnString + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            LogicFilterImpl logFilter = (LogicFilterImpl)obj;
            LOGGER.finest("filter type match:" + (logFilter.getFilterType() == this.filterType));
            LOGGER.finest("same size:" + (logFilter.getSubFilters().size() == this.children.size()) + "; inner size: " + logFilter.getSubFilters().size() + "; outer size: " + this.children.size());
            LOGGER.finest("contains:" + logFilter.getSubFilters().containsAll(this.children));
            return logFilter.getFilterType() == this.filterType && logFilter.getSubFilters().size() == this.children.size() && logFilter.getSubFilters().containsAll(this.children);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.filterType;
        result = 37 * result + ((Object)this.children).hashCode();
        return result;
    }

    public abstract Object accept(FilterVisitor var1, Object var2);
}

