/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.visitor.DuplicatorFilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class Filters {
    public static final int NOTFOUND = -1;
    FilterFactory ff;

    public Filters() {
        this(FilterFactoryFinder.createFilterFactory());
    }

    public Filters(FilterFactory factory) {
        this.ff = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.ff = factory;
    }

    public Filter duplicate(Filter filter) {
        DuplicatorFilterVisitor xerox = new DuplicatorFilterVisitor(this.ff);
        filter.accept((FilterVisitor)xerox);
        return (Filter)xerox.getCopy();
    }

    public static int asInt(Expression expr) {
        Number number = (Number)Filters.asType(expr, Number.class);
        if (number != null) {
            return number.intValue();
        }
        String string = (String)Filters.asType(expr, String.class);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static String asString(Expression expr) {
        String string = (String)Filters.asType(expr, String.class);
        return string;
    }

    public static double asDouble(Expression expr) {
        Number number = (Number)Filters.asType(expr, Number.class);
        if (number != null) {
            return number.doubleValue();
        }
        String string = (String)Filters.asType(expr, String.class);
        if (string != null) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    public static Object asType(Expression expr, Class TYPE) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            Object value = literal.getValue();
            if (TYPE.isInstance(value)) {
                return value;
            }
        } else if (expr instanceof Function) {
            Function function = (Function)expr;
            List params = function.getParameters();
            if (params != null && params.size() != 0) {
                for (int i = 0; i < params.size(); ++i) {
                    Expression e = (Expression)params.get(i);
                    Object value = Filters.asType(e, TYPE);
                    if (value == null) continue;
                    return value;
                }
            }
        } else {
            try {
                Object value = expr.evaluate(null);
                if (TYPE.isInstance(value)) {
                    return value;
                }
            }
            catch (NullPointerException expected) {
                return null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static double number(Object value) {
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof String) {
            String text = (String)value;
            try {
                Number number = (Number)Filters.gets(text, Number.class);
                return number.doubleValue();
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Unable to decode '" + text + "' as a number");
            }
        }
        if (value instanceof Expression) {
            throw new IllegalArgumentException("Cannot deal with un evaulated Expression");
        }
        throw new IllegalArgumentException("Unable to evaulate " + value.getClass() + " in a numeric context");
    }

    public static Object gets(String text, Class TYPE) throws Throwable {
        if (text == null) {
            return null;
        }
        if (TYPE == String.class) {
            return text;
        }
        if (TYPE == Integer.class) {
            return Integer.decode(text);
        }
        if (TYPE == Double.class) {
            return Double.valueOf(text);
        }
        if (TYPE == Number.class) {
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException ignore) {
                return Integer.decode(text);
            }
        }
        if (TYPE == Color.class) {
            return new Color(Integer.decode(text));
        }
        try {
            Constructor create = TYPE.getConstructor(String.class);
            return create.newInstance(text);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return null;
    }

    public static String puts(double number) {
        if (Math.rint(number) == number) {
            return Integer.toString((int)number);
        }
        return Double.toString(number);
    }

    public static String puts(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Color) {
            Color color = (Color)obj;
            return Filters.puts(color);
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return Filters.puts(number.doubleValue());
        }
        return obj.toString();
    }

    public static String puts(Color color) {
        String redCode = Integer.toHexString(color.getRed());
        String greenCode = Integer.toHexString(color.getGreen());
        String blueCode = Integer.toHexString(color.getBlue());
        if (redCode.length() == 1) {
            redCode = "0" + redCode;
        }
        if (greenCode.length() == 1) {
            greenCode = "0" + greenCode;
        }
        if (blueCode.length() == 1) {
            blueCode = "0" + blueCode;
        }
        return "#" + redCode + greenCode + blueCode;
    }
}

