/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.factory.FactoryFinder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.filter.AndImpl;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.AttributeExpressionImpl2;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.BBoxExpressionImpl;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.BetweenFilterImpl;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.EnvironmentVariable;
import org.geotools.filter.Expr;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryDistanceFilter;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.IsEqualsToImpl;
import org.geotools.filter.IsGreaterThanImpl;
import org.geotools.filter.IsGreaterThanOrEqualToImpl;
import org.geotools.filter.IsLessThenImpl;
import org.geotools.filter.IsLessThenOrEqualToImpl;
import org.geotools.filter.IsNotEqualToImpl;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MapScaleDenominatorImpl;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NotImpl;
import org.geotools.filter.NullFilter;
import org.geotools.filter.NullFilterImpl;
import org.geotools.filter.OrImpl;
import org.geotools.filter.SortByImpl;
import org.geotools.filter.expression.AddImpl;
import org.geotools.filter.expression.DivideImpl;
import org.geotools.filter.expression.MultiplyImpl;
import org.geotools.filter.expression.SubtractImpl;
import org.geotools.filter.spatial.BBOXImpl;
import org.geotools.filter.spatial.BeyondImpl;
import org.geotools.filter.spatial.ContainsImpl;
import org.geotools.filter.spatial.CrossesImpl;
import org.geotools.filter.spatial.DWithinImpl;
import org.geotools.filter.spatial.DisjointImpl;
import org.geotools.filter.spatial.EqualsImpl;
import org.geotools.filter.spatial.IntersectsImpl;
import org.geotools.filter.spatial.OverlapsImpl;
import org.geotools.filter.spatial.TouchesImpl;
import org.geotools.filter.spatial.WithinImpl;
import org.opengis.filter.And;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class FilterFactoryImpl
extends Expr
implements FilterFactory {
    static Map filterFunctionCache = null;
    static final Object lock = new Object();

    public AttributeExpression createAttributeExpression(String xpath) {
        return new AttributeExpressionImpl(xpath);
    }

    public AttributeExpression createAttributeExpression(FeatureType schema) {
        return new AttributeExpressionImpl(schema);
    }

    public AttributeExpression createAttributeExpression(FeatureType schema, String path) throws IllegalFilterException {
        return new AttributeExpressionImpl(schema, path);
    }

    public AttributeExpression createAttributeExpression(AttributeType at) throws IllegalFilterException {
        return new AttributeExpressionImpl2(at);
    }

    public BBoxExpression createBBoxExpression(Envelope env) throws IllegalFilterException {
        return new BBoxExpressionImpl(env);
    }

    public BetweenFilter createBetweenFilter() throws IllegalFilterException {
        return new BetweenFilterImpl();
    }

    public CompareFilter createCompareFilter(short type) throws IllegalFilterException {
        switch (type) {
            case 14: {
                return new IsEqualsToImpl(this);
            }
            case 23: {
                return new IsNotEqualToImpl(this);
            }
            case 16: {
                return new IsGreaterThanImpl(this);
            }
            case 18: {
                return new IsGreaterThanOrEqualToImpl(this);
            }
            case 15: {
                return new IsLessThenImpl(this);
            }
            case 17: {
                return new IsLessThenOrEqualToImpl(this);
            }
            case 19: {
                return new BetweenFilterImpl(this);
            }
        }
        throw new IllegalFilterException("Must be one of <,<=,==,>,>=,<>");
    }

    public FidFilter createFidFilter() {
        return new FidFilterImpl();
    }

    public FidFilter createFidFilter(String fid) {
        return new FidFilterImpl(fid);
    }

    public GeometryFilter createGeometryFilter(short filterType) throws IllegalFilterException {
        switch (filterType) {
            case 5: {
                return new EqualsImpl(this, null, null);
            }
            case 6: {
                return new DisjointImpl(this, null, null);
            }
            case 24: {
                return new DWithinImpl(this, null, null);
            }
            case 7: {
                return new IntersectsImpl(this, null, null);
            }
            case 9: {
                return new CrossesImpl(this, null, null);
            }
            case 10: {
                return new WithinImpl(this, null, null);
            }
            case 11: {
                return new ContainsImpl(this, null, null);
            }
            case 12: {
                return new OverlapsImpl(this, null, null);
            }
            case 13: {
                return new BeyondImpl(this, null, null);
            }
            case 4: {
                return new BBOXImpl(this, null, null);
            }
            case 8: {
                return new TouchesImpl(this, null, null);
            }
        }
        throw new IllegalFilterException("Not one of the accepted spatial filter types.");
    }

    public GeometryDistanceFilter createGeometryDistanceFilter(short filterType) throws IllegalFilterException {
        switch (filterType) {
            case 13: {
                return new BeyondImpl(this, null, null);
            }
            case 24: {
                return new DWithinImpl(this, null, null);
            }
        }
        throw new IllegalFilterException("Not one of the accepted spatial filter types.");
    }

    public LikeFilter createLikeFilter() {
        return new LikeFilterImpl();
    }

    public LiteralExpression createLiteralExpression() {
        return new LiteralExpressionImpl();
    }

    public LiteralExpression createLiteralExpression(Object o) throws IllegalFilterException {
        return new LiteralExpressionImpl(o);
    }

    public LiteralExpression createLiteralExpression(int i) {
        return new LiteralExpressionImpl(i);
    }

    public LiteralExpression createLiteralExpression(double d) {
        return new LiteralExpressionImpl(d);
    }

    public LiteralExpression createLiteralExpression(String s) {
        return new LiteralExpressionImpl(s);
    }

    public LogicFilter createLogicFilter(short filterType) throws IllegalFilterException {
        ArrayList children = new ArrayList();
        switch (filterType) {
            case 2: {
                return new AndImpl(this, children);
            }
            case 1: {
                return new OrImpl(this, children);
            }
            case 3: {
                return new NotImpl(this);
            }
        }
        throw new IllegalFilterException("Must be one of AND,OR,NOT.");
    }

    public LogicFilter createLogicFilter(Filter filter, short filterType) throws IllegalFilterException {
        ArrayList<Filter> children = new ArrayList<Filter>();
        children.add(filter);
        switch (filterType) {
            case 2: {
                return new AndImpl(this, children);
            }
            case 1: {
                return new OrImpl(this, children);
            }
            case 3: {
                return new NotImpl((FilterFactory)this, (org.opengis.filter.Filter)filter);
            }
        }
        throw new IllegalFilterException("Must be one of AND,OR,NOT.");
    }

    public LogicFilter createLogicFilter(Filter filter1, Filter filter2, short filterType) throws IllegalFilterException {
        ArrayList<Filter> children = new ArrayList<Filter>();
        children.add(filter1);
        children.add(filter2);
        switch (filterType) {
            case 2: {
                return new AndImpl(this, children);
            }
            case 1: {
                return new OrImpl(this, children);
            }
            case 3: {
                return new NotImpl((FilterFactory)this, (org.opengis.filter.Filter)filter1);
            }
        }
        throw new IllegalFilterException("Must be one of AND,OR,NOT.");
    }

    public MathExpression createMathExpression() {
        throw new UnsupportedOperationException();
    }

    public MathExpression createMathExpression(short expressionType) throws IllegalFilterException {
        switch (expressionType) {
            case 105: {
                return new AddImpl(null, null);
            }
            case 106: {
                return new SubtractImpl(null, null);
            }
            case 107: {
                return new MultiplyImpl(null, null);
            }
            case 108: {
                return new DivideImpl(null, null);
            }
        }
        throw new IllegalFilterException("Unsupported math expression");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionExpression createFunctionExpression(String name) {
        int index = -1;
        index = name.indexOf("Function");
        if (index != -1) {
            name = name.substring(0, index);
        }
        name = name.toLowerCase().trim();
        char c = name.charAt(0);
        name = name.replaceFirst("" + c, "" + Character.toUpperCase(c));
        try {
            Object object = lock;
            synchronized (object) {
                if (filterFunctionCache == null) {
                    filterFunctionCache = new HashMap();
                    Iterator it = FactoryFinder.factories((Class)FunctionExpression.class);
                    String funName = "";
                    Object exp = null;
                    while (it.hasNext()) {
                        FunctionExpression fe = (FunctionExpression)it.next();
                        filterFunctionCache.put(fe.getName().toLowerCase(), fe.getClass());
                    }
                }
            }
            Class filterClass = (Class)filterFunctionCache.get(name.toLowerCase());
            return (FunctionExpression)filterClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create class " + name + "Function", e);
        }
    }

    public NullFilter createNullFilter() {
        return new NullFilterImpl();
    }

    public EnvironmentVariable createEnvironmentVariable(String name) {
        if (name.equalsIgnoreCase("MapScaleDenominator")) {
            return new MapScaleDenominatorImpl();
        }
        throw new RuntimeException("Unknown environment variable:" + name);
    }

    public Map getImplementationHints() {
        return null;
    }

    public Filter and(Filter f1, Filter f2) {
        And f = this.and((org.opengis.filter.Filter)f1, (org.opengis.filter.Filter)f2);
        return (Filter)f;
    }

    public Filter or(Filter f1, Filter f2) {
        Or f = this.or((org.opengis.filter.Filter)f1, (org.opengis.filter.Filter)f2);
        return (Filter)f;
    }

    public Filter not(Filter f) {
        Not f1 = this.not((org.opengis.filter.Filter)f);
        return (Filter)f1;
    }

    public SortBy sort(String propertyName, SortOrder order) {
        return new SortByImpl(this.property(propertyName), order);
    }
}

