/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.feature.Feature;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.GeometryDistanceFilter;
import org.geotools.filter.GeometryFilterImpl;
import org.geotools.filter.IllegalFilterException;
import org.opengis.filter.expression.Expression;

public abstract class CartesianDistanceFilter
extends GeometryFilterImpl
implements GeometryDistanceFilter {
    private double distance;
    private String units;

    protected CartesianDistanceFilter(FilterFactory factory) {
        super(factory);
    }

    protected CartesianDistanceFilter(FilterFactory factory, Expression e1, Expression e2) {
        super(factory, e1, e2);
    }

    protected CartesianDistanceFilter(short filterType) throws IllegalFilterException {
        super(filterType);
        if (!CartesianDistanceFilter.isGeometryDistanceFilter(filterType)) {
            throw new IllegalFilterException("Attempted to create distance geometry filter with nondistance geometry type.");
        }
        this.filterType = filterType;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getDistance() {
        return this.distance;
    }

    public String getDistanceUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public abstract boolean evaluate(Feature var1);

    public String toString() {
        String operator = null;
        if (this.filterType == 13) {
            operator = " beyond ";
        } else if (this.filterType == 24) {
            operator = " dwithin ";
        }
        String distStr = ", distance: " + this.distance;
        Expression leftGeometry = this.getExpression1();
        Expression rightGeometry = this.getExpression2();
        if (leftGeometry == null && rightGeometry == null) {
            return "[ null" + operator + "null" + distStr + " ]";
        }
        if (leftGeometry == null) {
            return "[ null" + operator + rightGeometry.toString() + distStr + " ]";
        }
        if (rightGeometry == null) {
            return "[ " + leftGeometry.toString() + operator + "null" + distStr + " ]";
        }
        return "[ " + leftGeometry.toString() + operator + rightGeometry.toString() + distStr + " ]";
    }

    public boolean equals(Object oFilter) {
        return super.equals(oFilter) && this.distance == this.distance;
    }

    public int hashCode() {
        int result = super.hashCode();
        long bits = Double.doubleToLongBits(this.distance);
        result = 37 * result + (int)(bits ^ bits >>> 32);
        return result;
    }
}

