/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.Iterator;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.FeatureVisitor;

public class CollectionUtil {
    static void accept(FeatureCollection collection, FeatureVisitor visitor) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            visitor.visit(feature);
        }
        collection.close(iterator);
    }

    static void accept(FeatureCollection collection, FeatureVisitor[] visitors) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            for (int i = 0; i < visitors.length; ++i) {
                FeatureVisitor visitor = visitors[i];
                visitor.visit(feature);
            }
        }
        collection.close(iterator);
    }

    public static Object calc(FeatureCollection collection, FeatureCalc calculator) {
        CollectionUtil.accept(collection, calculator);
        return calculator.getResult();
    }
}

