/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.geotools.data.collection.ResourceCollection;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureList;
import org.geotools.feature.collection.RandomFeatureAccess;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.feature.collection.SubFeatureState;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.SortBy;
import org.geotools.filter.SortOrder;
import org.opengis.filter.expression.PropertyName;

public class SubFeatureList
extends SubFeatureCollection
implements FeatureList,
RandomFeatureAccess {
    List sort;
    List index;

    public SubFeatureList(FeatureCollection list, Filter filter) {
        this(list, filter, null);
    }

    public SubFeatureList(FeatureCollection list, SortBy sort) {
        this(list, null, sort);
    }

    public SubFeatureList(FeatureCollection list, Filter filter, SortBy subSort) {
        super(list, filter);
        this.state = new SubFeatureState(list, this);
        if (subSort == null) {
            this.sort = Collections.EMPTY_LIST;
        } else {
            this.sort = new ArrayList();
            if (this.collection instanceof SubFeatureList) {
                SubFeatureList sorted = (SubFeatureList)this.collection;
                this.sort.addAll(sorted.sort);
            }
            this.sort.add(subSort);
        }
        this.index = null;
    }

    public SubFeatureList(FeatureCollection list, List order) {
        super(list);
        this.state = new SubFeatureState(list, this);
        this.index = order;
        this.filter = null;
    }

    protected Filter createFilter() {
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        FidFilter fids = ff.createFidFilter();
        fids.addAllFids((Collection)this.index);
        return fids;
    }

    protected List index() {
        if (this.index == null) {
            this.index = this.createIndex();
        }
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List createIndex() {
        ArrayList<String> fids = new ArrayList<String>();
        Iterator it = this.collection.iterator();
        try {
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                if (!this.filter.contains(feature)) continue;
                fids.add(feature.getID());
            }
            if (this.sort != null && !this.sort.isEmpty()) {
                final SortBy initialOrder = (SortBy)this.sort.get(this.sort.size() - 1);
                Collections.sort(fids, new Comparator(){

                    public int compare(Object key1, Object key2) {
                        Feature feature2;
                        Feature feature1 = SubFeatureList.this.getFeatureMember((String)key1);
                        int compare = this.compare(feature1, feature2 = SubFeatureList.this.getFeatureMember((String)key2), initialOrder);
                        if (compare == 0 && SubFeatureList.this.sort.size() > 1) {
                            for (int i = SubFeatureList.this.sort.size() - 1; compare == 0 && i >= 0; --i) {
                                compare = this.compare(feature1, feature2, (SortBy)SubFeatureList.this.sort.get(i));
                            }
                        }
                        return compare;
                    }

                    protected int compare(Feature feature1, Feature feature2, SortBy order) {
                        PropertyName name = order.getPropertyName();
                        Comparable value1 = (Comparable)name.evaluate((Object)feature1);
                        Comparable value2 = (Comparable)name.evaluate((Object)feature2);
                        if (order.getSortOrder() == SortOrder.ASCENDING) {
                            return value1.compareTo(value2);
                        }
                        return value2.compareTo(value1);
                    }
                });
            }
        }
        finally {
            this.collection.close(it);
        }
        return fids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection c) {
        boolean modified = false;
        Iterator e = c.iterator();
        try {
            while (e.hasNext()) {
                this.add(index++, e.next());
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            if (c instanceof ResourceCollection) {
                ((ResourceCollection)c).close(e);
            }
        }
    }

    public Object get(int index) {
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess random = (RandomFeatureAccess)this.collection;
            String id = (String)this.index().get(index);
            random.getFeatureMember(id);
        }
        Iterator it = this.iterator();
        try {
            int i = 0;
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                if (i == index) {
                    Feature feature2 = feature;
                    return feature2;
                }
                ++i;
            }
            throw new IndexOutOfBoundsException();
        }
        finally {
            this.close(it);
        }
    }

    public Object set(int index, Object feature) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, Object feature) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        String fid = (String)this.index().get(index);
        Feature feature = this.getFeatureMember(fid);
        if (this.collection.remove((Object)feature)) {
            return feature;
        }
        return null;
    }

    public int indexOf(Object o) {
        Feature feature = (Feature)o;
        return this.index().indexOf(feature.getID());
    }

    public int lastIndexOf(Object o) {
        Feature feature = (Feature)o;
        return this.index().lastIndexOf(feature.getID());
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        ListIterator iterator = this.openIterator(index);
        this.open.add(iterator);
        return iterator;
    }

    public ListIterator openIterator(int index) {
        return new SubListItr(index);
    }

    public FeatureList subList(Filter subfilter) {
        return new SubFeatureList((FeatureCollection)this, subfilter);
    }

    public Feature getFeatureMember(String id) throws NoSuchElementException {
        int position = this.index.indexOf(id);
        if (position == -1) {
            throw new NoSuchElementException(id);
        }
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess random = (RandomFeatureAccess)this.collection;
            random.getFeatureMember(id);
        }
        return (Feature)this.get(position);
    }

    public Feature removeFeatureMember(String id) {
        int position = this.index.indexOf(id);
        if (position == -1) {
            throw new NoSuchElementException(id);
        }
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess random = (RandomFeatureAccess)this.collection;
            if (this.index != null) {
                this.index.remove(id);
            }
            return random.removeFeatureMember(id);
        }
        return (Feature)this.remove(position);
    }

    public List subList(int fromIndex, int toIndex) {
        return new SubFeatureList((FeatureCollection)this, this.index().subList(fromIndex, toIndex));
    }

    public FeatureList sort(SortBy order) {
        return super.sort(order);
    }

    class SubListItr
    implements ListIterator {
        ListIterator it;
        String fid;

        public SubListItr(int fromIndex) {
            this.it = SubFeatureList.this.index().subList(fromIndex, SubFeatureList.this.index.size()).listIterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            this.fid = (String)this.it.next();
            return SubFeatureList.this.getFeatureMember(this.fid);
        }

        public void remove() {
            this.it.remove();
            if (this.fid == null) {
                throw new IllegalStateException();
            }
            SubFeatureList.this.removeFeatureMember(this.fid);
            SubFeatureList.this.index.remove(this.fid);
        }

        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        public Object previous() {
            this.fid = (String)this.it.previous();
            return SubFeatureList.this.getFeatureMember(this.fid);
        }

        public int nextIndex() {
            return this.it.nextIndex();
        }

        public int previousIndex() {
            return this.it.previousIndex();
        }

        public void set(Object arg0) {
            throw new UnsupportedOperationException();
        }

        public void add(Object feature) {
            SubFeatureList.this.add(this.it.nextIndex() - 1, feature);
        }
    }
}

