/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Iterator;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureList;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.AbstractResourceCollection;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.feature.collection.FeatureState;
import org.geotools.feature.collection.FilteredIterator;
import org.geotools.feature.collection.SubFeatureState;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.filter.Filter;
import org.geotools.filter.SortBy;
import org.geotools.util.ProgressListener;

public class SubFeatureCollection
extends AbstractResourceCollection
implements FeatureCollection {
    protected Filter filter;
    protected FeatureCollection collection;
    protected FeatureState state;

    public SubFeatureCollection(FeatureCollection collection) {
        this(collection, null);
    }

    public SubFeatureCollection(FeatureCollection collection, Filter subfilter) {
        if (subfilter != null && subfilter.equals(Filter.ALL)) {
            throw new IllegalArgumentException("A subcollection with Filter.ALL is a null operation");
        }
        if (subfilter != null && subfilter.equals(Filter.NONE)) {
            throw new IllegalArgumentException("A subcollection with Filter.NONE should be a FeatureCollectionEmpty");
        }
        if (subfilter != null && collection instanceof SubFeatureCollection) {
            SubFeatureCollection filtered = (SubFeatureCollection)collection;
            this.collection = filtered.collection;
            this.filter = filtered.filter().and(subfilter);
        } else {
            this.collection = collection;
            this.filter = subfilter;
        }
        this.state = new SubFeatureState(this.collection, this);
    }

    protected Filter filter() {
        if (this.filter == null) {
            this.filter = this.createFilter();
        }
        return this.filter;
    }

    protected Filter createFilter() {
        return Filter.NONE;
    }

    public FeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public FeatureIterator features() {
        return new DelegateFeatureIterator(this, this.iterator());
    }

    public void closeIterator(Iterator iterator) {
        if (iterator == null) {
            return;
        }
        if (iterator instanceof FilteredIterator) {
            FilteredIterator filtered = (FilteredIterator)iterator;
            filtered.close();
        }
    }

    public void close(FeatureIterator close) {
        if (close != null) {
            close.close();
        }
    }

    public String getID() {
        return this.state.getId();
    }

    public Envelope getBounds() {
        return this.state.getBounds();
    }

    public Geometry getDefaultGeometry() {
        return this.state.getDefaultGeometry();
    }

    public void setDefaultGeometry(Geometry g) throws IllegalAttributeException {
        this.state.setDefaultGeometry(g);
    }

    public void addListener(CollectionListener listener) throws NullPointerException {
        this.state.addListener(listener);
    }

    public void removeListener(CollectionListener listener) throws NullPointerException {
        this.state.removeListener(listener);
    }

    public FeatureCollection getParent() {
        return this.state.getParent();
    }

    public void setParent(FeatureCollection collection) {
        this.state.setParent(collection);
    }

    public Object[] getAttributes(Object[] attributes) {
        return this.state.getAttributes(attributes);
    }

    public Object getAttribute(String xPath) {
        return this.state.getAttribute(xPath);
    }

    public Object getAttribute(int index) {
        return this.state.getAttribute(index);
    }

    public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
        this.state.setAttribute(position, val);
    }

    public int getNumberOfAttributes() {
        return this.state.getNumberOfAttributes();
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        this.state.setAttribute(xPath, attribute);
    }

    public FeatureCollection subCollection(Filter filter) {
        if (filter.equals(Filter.NONE)) {
            return this;
        }
        if (filter.equals(Filter.ALL)) {
            // empty if block
        }
        return new SubFeatureCollection(this, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int count = 0;
        Iterator i = null;
        try {
            i = this.iterator();
            while (i.hasNext()) {
                i.next();
                ++count;
            }
        }
        finally {
            this.close(i);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Iterator iterator = this.iterator();
        try {
            boolean bl = iterator.hasNext();
            return bl;
        }
        finally {
            this.close(iterator);
        }
    }

    public Iterator openIterator() {
        return new FilteredIterator(this.collection, this.filter());
    }

    public FeatureType getSchema() {
        return this.collection.getSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        Iterator iterator = null;
        try {
            float size = this.size();
            float position = 0.0f;
            progress.started();
            iterator = this.iterator();
            while (!progress.isCanceled() && iterator.hasNext()) {
                try {
                    Feature feature = (Feature)iterator.next();
                    visitor.visit(feature);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                }
                float f = position;
                position = f + 1.0f;
                progress.progress(f / size);
            }
        }
        catch (Throwable throwable) {
            progress.complete();
            this.close(iterator);
            throw throwable;
        }
        progress.complete();
        this.close(iterator);
    }

    public FeatureReader reader() throws IOException {
        return new DelegateFeatureReader(this.getSchema(), this.features());
    }

    public int getCount() throws IOException {
        return this.size();
    }

    public FeatureCollection collection() throws IOException {
        return this;
    }

    public FeatureList sort(SortBy order) {
        return null;
    }

    public void purge() {
        this.collection.purge();
    }
}

