/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.LengthFunction;
import org.geotools.filter.LiteralExpression;
import org.geotools.geometry.JTS;
import org.geotools.xml.gml.GMLSchema;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class FeatureTypes {
    public static final int ANY_LENGTH = -1;

    public static int getFieldLength(AttributeType type) {
        Class colType = type.getType();
        String colName = type.getName();
        int fieldLen = -1;
        Filter f = type.getRestriction();
        if (f != null && f != Filter.ALL && f != Filter.NONE && (f.getFilterType() == 15 || f.getFilterType() == 17)) {
            try {
                CompareFilter cf = (CompareFilter)f;
                if (cf.getLeftValue() instanceof LengthFunction) {
                    return Integer.parseInt(((LiteralExpression)cf.getRightValue()).getLiteral().toString());
                }
                if (cf.getRightValue() instanceof LengthFunction) {
                    return Integer.parseInt(((LiteralExpression)cf.getLeftValue()).getLiteral().toString());
                }
                return -1;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public static FeatureType transform(FeatureType schema, CoordinateReferenceSystem crs) throws SchemaException {
        return FeatureTypes.transform(schema, crs, false);
    }

    public static FeatureType transform(FeatureType schema, CoordinateReferenceSystem crs, boolean forceOnlyMissing) throws SchemaException {
        FeatureTypeFactory factory = FeatureTypeFactory.newInstance(schema.getTypeName());
        factory.setNamespace(schema.getNamespace());
        factory.setName(schema.getTypeName());
        GeometryAttributeType defaultGeometryType = null;
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeType attributeType = schema.getAttributeType(i);
            if (attributeType instanceof GeometryAttributeType) {
                GeometryAttributeType geometryType = (GeometryAttributeType)attributeType;
                GeometryAttributeType forced = forceOnlyMissing && geometryType.getCoordinateSystem() != null ? geometryType : (GeometryAttributeType)AttributeTypeFactory.newAttributeType(geometryType.getName(), geometryType.getType(), geometryType.isNillable(), 0, geometryType.createDefaultValue(), (Object)crs);
                if (defaultGeometryType == null || geometryType == schema.getDefaultGeometry()) {
                    defaultGeometryType = forced;
                }
                factory.addType((AttributeType)forced);
                continue;
            }
            factory.addType(attributeType);
        }
        factory.setDefaultGeometry(defaultGeometryType);
        return factory.getFeatureType();
    }

    public static Feature transform(Feature feature, FeatureType schema, MathTransform transform) throws MismatchedDimensionException, TransformException, IllegalAttributeException {
        feature = schema.create(feature.getAttributes(null), feature.getID());
        GeometryAttributeType geomType = schema.getDefaultGeometry();
        Geometry geom = (Geometry)feature.getAttribute(geomType.getName());
        geom = JTS.transform(geom, transform);
        try {
            feature.setAttribute(geomType.getName(), (Object)geom);
        }
        catch (IllegalAttributeException shouldNotHappen) {
            // empty catch block
        }
        return feature;
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract, FeatureType[] superTypes) throws FactoryConfigurationError, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, superTypes, null);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract, FeatureType[] superTypes, AttributeType defaultGeometry) throws FactoryConfigurationError, SchemaException {
        FeatureTypeFactory factory = FeatureTypeFactory.newInstance(name);
        factory.addTypes(types);
        factory.setNamespace(ns);
        factory.setAbstract(isAbstract);
        if (defaultGeometry != null) {
            factory.setDefaultGeometry((GeometryAttributeType)defaultGeometry);
        }
        if (superTypes != null) {
            factory.setSuperTypes(Arrays.asList(superTypes));
        }
        return factory.getFeatureType();
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract, FeatureType[] superTypes, GeometryAttributeType defaultGeometry) throws FactoryConfigurationError, SchemaException {
        FeatureTypeFactory factory = FeatureTypeFactory.newInstance(name);
        factory.addTypes(types);
        factory.setNamespace(ns);
        factory.setAbstract(isAbstract);
        if (superTypes != null) {
            factory.setSuperTypes(Arrays.asList(superTypes));
        }
        if (defaultGeometry != null) {
            factory.setDefaultGeometry(defaultGeometry);
        }
        return factory.getFeatureType();
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract) throws FactoryConfigurationError, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, null);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns) throws FactoryConfigurationError, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, false);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name) throws FactoryConfigurationError, SchemaException {
        return FeatureTypes.newFeatureType(types, name, GMLSchema.NAMESPACE, false);
    }

    public static boolean isDecendedFrom(FeatureType featureType, URI namespace, String typeName) {
        if (featureType == null) {
            return false;
        }
        FeatureType[] ancestors = featureType.getAncestors();
        if (ancestors != null) {
            for (int i = 0; i < ancestors.length; ++i) {
                FeatureType ancestor = ancestors[i];
                if (namespace != null && !namespace.equals(ancestor.getNamespace()) || typeName != null && !namespace.equals(ancestor.getTypeName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDecendedFrom(FeatureType featureType, FeatureType isParentType) {
        if (featureType == null || isParentType == null) {
            return false;
        }
        FeatureType[] ancestors = featureType.getAncestors();
        if (ancestors != null) {
            for (int i = 0; i < ancestors.length; ++i) {
                FeatureType ancestor = ancestors[i];
                if (isParentType != ancestor) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(FeatureType typeA, FeatureType typeB) {
        if (typeA == typeB) {
            return true;
        }
        if (typeA == null || typeB == null) {
            return false;
        }
        return FeatureTypes.equalsId(typeA, typeB) && FeatureTypes.equals(typeA.getAttributeTypes(), typeB.getAttributeTypes()) && FeatureTypes.equalsAncestors(typeA, typeB);
    }

    public static boolean equals(AttributeType[] attributesA, AttributeType[] attributesB) {
        if (attributesA.length != attributesB.length) {
            return false;
        }
        int length = attributesA.length;
        for (int i = 0; i < length; ++i) {
            if (FeatureTypes.equals(attributesA[i], attributesB[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAncestors(FeatureType typeA, FeatureType typeB) {
        return ((Object)FeatureTypes.ancestors(typeA)).equals(typeB);
    }

    public static Set ancestors(FeatureType featureType) {
        if (featureType == null || featureType.getAncestors() == null || featureType.getAncestors().length == 0) {
            return Collections.EMPTY_SET;
        }
        return new HashSet<FeatureType>(Arrays.asList(featureType.getAncestors()));
    }

    public static boolean equals(AttributeType a, AttributeType b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean equalsId(FeatureType typeA, FeatureType typeB) {
        if (typeA == typeB) {
            return true;
        }
        if (typeA == null || typeB == null) {
            return false;
        }
        String typeNameA = typeA.getTypeName();
        String typeNameB = typeB.getTypeName();
        if (typeNameA == null && typeNameB != null) {
            return false;
        }
        if (!typeNameA.equals(typeNameB)) {
            return false;
        }
        URI namespaceA = typeA.getNamespace();
        URI namespaceB = typeB.getNamespace();
        if (namespaceA == null && namespaceB != null) {
            return false;
        }
        return namespaceA.equals(namespaceB);
    }
}

