/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Date;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultAttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.type.FeatureAttributeType;
import org.geotools.feature.type.GeometricAttributeType;
import org.geotools.feature.type.NumericAttributeType;
import org.geotools.feature.type.TemporalAttributeType;
import org.geotools.feature.type.TextualAttributeType;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LengthFunction;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultAttributeTypeFactory
extends AttributeTypeFactory {
    private FilterFactory ff;

    public DefaultAttributeTypeFactory() {
        this(FilterFactoryFinder.createFilterFactory());
    }

    public DefaultAttributeTypeFactory(FilterFactory factory) {
        this.ff = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.ff = factory;
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, int fieldLength) {
        return this.createAttributeType(name, clazz, isNillable, fieldLength, null);
    }

    protected AttributeType createAttributeType(String name, FeatureType type, boolean isNillable) {
        return new FeatureAttributeType(name, type, isNillable, 1, 1);
    }

    protected Filter length(int fieldLength, String attributeXPath) {
        LengthFunction length = (LengthFunction)this.ff.createFunctionExpression("LengthFunction");
        if (length == null) {
            return null;
        }
        length.setArgs(new Expression[]{this.ff.createAttributeExpression(attributeXPath)});
        CompareFilter cf = null;
        try {
            cf = this.ff.createCompareFilter((short)17);
            cf.addLeftValue((Expression)length);
            cf.addRightValue((Expression)this.ff.createLiteralExpression(fieldLength));
        }
        catch (IllegalFilterException e) {
            // empty catch block
        }
        return cf == null ? Filter.ALL : cf;
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, int fieldLength, Object defaultValue) {
        Filter f = this.length(fieldLength, name);
        if (Number.class.isAssignableFrom(clazz)) {
            return new NumericAttributeType(name, clazz, isNillable, 1, 1, defaultValue, f);
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return new TextualAttributeType(name, isNillable, 1, 1, defaultValue, f);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new TemporalAttributeType(name, isNillable, 1, 1, defaultValue, f);
        }
        if (Geometry.class.isAssignableFrom(clazz)) {
            return new GeometricAttributeType(name, clazz, isNillable, 1, 1, defaultValue, null, f);
        }
        return new DefaultAttributeType(name, clazz, isNillable, 1, 1, defaultValue, f);
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, Filter filter, Object defaultValue, Object metadata) {
        LengthFunction length = (LengthFunction)this.ff.createFunctionExpression("LengthFunction");
        length.setArgs(new Expression[]{this.ff.createAttributeExpression(name)});
        if (Number.class.isAssignableFrom(clazz)) {
            return new NumericAttributeType(name, clazz, isNillable, 1, 1, defaultValue, filter);
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return new TextualAttributeType(name, isNillable, 1, 1, defaultValue, filter);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new TemporalAttributeType(name, isNillable, 1, 1, defaultValue, filter);
        }
        if (Geometry.class.isAssignableFrom(clazz)) {
            if (metadata instanceof CoordinateReferenceSystem) {
                return new GeometricAttributeType(name, clazz, isNillable, 1, 1, defaultValue, (CoordinateReferenceSystem)metadata, filter);
            }
            return new GeometricAttributeType(name, clazz, isNillable, 1, 1, defaultValue, null, filter);
        }
        return new DefaultAttributeType(name, clazz, isNillable, 1, 1, defaultValue, filter);
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, int fieldLength, Object defaultValue, Object metaData) {
        if (Geometry.class.isAssignableFrom(clazz) && metaData instanceof CoordinateReferenceSystem) {
            LengthFunction length = (LengthFunction)this.ff.createFunctionExpression("LengthFunction");
            length.setArgs(new Expression[]{this.ff.createAttributeExpression(name)});
            CompareFilter cf = null;
            try {
                cf = this.ff.createCompareFilter((short)17);
                cf.addLeftValue((Expression)length);
                cf.addRightValue((Expression)this.ff.createLiteralExpression(fieldLength));
            }
            catch (IllegalFilterException e) {
                // empty catch block
            }
            Filter f = cf == null ? Filter.ALL : cf;
            return new GeometricAttributeType(name, clazz, isNillable, 1, 1, defaultValue, (CoordinateReferenceSystem)metaData, f);
        }
        return this.createAttributeType(name, clazz, isNillable, fieldLength, defaultValue);
    }
}

