/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.event;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.geotools.event.GTDelta;
import org.geotools.event.GTDeltaVisitor;
import org.geotools.event.GTNote;

public class GTDeltaImpl
implements GTDelta {
    private String name;
    private int position;
    private GTDelta.Kind kind;
    private Object value;
    private Object oldValue;
    private List children;

    public GTDeltaImpl(GTNote notification, Object before, Object after) {
        this(notification, GTDeltaImpl.magic(before, after), before, after);
    }

    public GTDeltaImpl(GTNote notification, GTDelta.Kind kind, Object value, Object oldValue) {
        this(notification, kind, value, oldValue, Collections.EMPTY_LIST);
    }

    public GTDeltaImpl(GTNote notification, GTDelta.Kind kind, Object value, Object oldValue, GTDelta delta) {
        this(notification, kind, value, oldValue, Collections.singletonList(delta));
    }

    public GTDeltaImpl(GTNote notification, GTDelta.Kind kind, Object value, Object oldValue, List children) {
        this.name = notification.getNotificationName();
        this.position = notification.getNotificationPosition();
        this.kind = kind;
        this.value = value;
        this.oldValue = oldValue;
        this.children = children;
    }

    private static GTDelta.Kind magic(Object before, Object after) {
        if (before == null && after == null) {
            return GTDelta.Kind.NO_CHANGE;
        }
        if (before == after) {
            return GTDelta.Kind.NO_CHANGE;
        }
        if (before != null && after == null) {
            return GTDelta.Kind.REMOVED;
        }
        if (before == null && after != null) {
            return GTDelta.Kind.ADDED;
        }
        if (before != after) {
            return GTDelta.Kind.CHANGED;
        }
        return GTDelta.Kind.CHANGED;
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public GTDelta.Kind getKind() {
        return this.kind;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public List getChildren() {
        return this.children;
    }

    public void accept(GTDeltaVisitor visitor) {
        boolean visitChildren = visitor.visit((GTDelta)this);
        if (!visitChildren) {
            return;
        }
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            GTDelta delta = (GTDelta)i.next();
            delta.accept(visitor);
        }
    }
}

