/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.fidmapper;

import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Statement;
import org.geotools.data.jdbc.fidmapper.AbstractFIDMapper;
import org.geotools.feature.Feature;

public class AutoIncrementFIDMapper
extends AbstractFIDMapper {
    private static final long serialVersionUID = 1L;

    public AutoIncrementFIDMapper(String colName, int dataType) {
        this(null, null, colName, dataType);
    }

    public AutoIncrementFIDMapper(String tableSchemaName, String tableName, String colName, int dataType) {
        super(tableSchemaName, tableName);
        this.setInfo(colName, dataType, 0, 0, true);
    }

    public AutoIncrementFIDMapper(String tableName, String colName, int dataType) {
        this(null, tableName, colName, dataType);
    }

    public String getID(Object[] attributes) {
        if (attributes != null && attributes.length == 1 && attributes[0] != null) {
            return attributes[0].toString();
        }
        return null;
    }

    public Object[] getPKAttributes(String FID) throws IOException {
        Object pk = null;
        switch (this.getColumnType(0)) {
            case -6: 
            case 4: 
            case 5: {
                try {
                    pk = new Integer(Integer.parseInt(FID));
                }
                catch (NumberFormatException nfe) {
                    pk = new Integer(-1);
                }
                break;
            }
            case -5: {
                try {
                    pk = new BigInteger(FID);
                }
                catch (NumberFormatException nfe) {
                    pk = new BigInteger("-1");
                }
                break;
            }
            case 2: {
                try {
                    pk = new Long(Long.parseLong(FID));
                }
                catch (NumberFormatException nfe) {
                    pk = new Integer(-1);
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                pk = new String(FID);
            }
        }
        return new Object[]{pk};
    }

    public String createID(Connection conn, Feature feature, Statement statement) throws IOException {
        return null;
    }
}

