/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class JDBCFeatureReader
implements FeatureReader {
    FeatureType featureType;
    QueryData queryData;
    Object[] attributes;
    Object[] fidAttributes;

    public JDBCFeatureReader(QueryData queryData) throws IOException {
        this.queryData = queryData;
        this.attributes = new Object[queryData.getAttributeHandlers().length];
        this.fidAttributes = new Object[queryData.getMapper().getColumnCount()];
    }

    public void close() throws IOException {
        this.close(null);
    }

    void close(SQLException sqlException) {
        this.queryData.close(sqlException);
    }

    public boolean hasNext() throws IOException {
        if (this.queryData.isClosed()) {
            throw new IOException("Reader is closed");
        }
        return this.queryData.hasNext();
    }

    public Feature next() throws IllegalAttributeException, IOException {
        if (this.queryData.isClosed()) {
            throw new IOException("The feature reader has been closed");
        }
        return this.readFeature();
    }

    private Feature readFeature() throws IllegalAttributeException, IOException {
        this.queryData.next();
        for (int i = 0; i < this.fidAttributes.length; ++i) {
            this.fidAttributes[i] = this.queryData.readFidColumn(i);
        }
        FIDMapper mapper = this.queryData.getMapper();
        String fid = mapper.getID(this.fidAttributes);
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = this.queryData.read(i);
        }
        return this.queryData.getFeatureType().create(this.attributes, fid);
    }

    public FeatureType getFeatureType() {
        return this.queryData.getFeatureType();
    }
}

