/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.DefaultSQLBuilder;
import org.geotools.data.jdbc.FeatureTypeHandler;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCFeatureLocking;
import org.geotools.data.jdbc.JDBCFeatureReader;
import org.geotools.data.jdbc.JDBCFeatureSource;
import org.geotools.data.jdbc.JDBCFeatureStore;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.JDBCTransactionState;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.attributeio.BasicAttributeIO;
import org.geotools.data.jdbc.fidmapper.DefaultFIDMapperFactory;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapperFactory;
import org.geotools.data.view.DefaultView;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeBuilder;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;

public abstract class JDBC1DataStore
implements DataStore {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    protected static final Map TYPE_MAPPINGS = new HashMap();
    private BasicAttributeIO basicAttributeIO;
    public FeatureListenerManager listenerManager = new FeatureListenerManager();
    private LockingManager lockingManager = this.createLockingManager();
    protected final JDBCDataStoreConfig config;
    protected FeatureTypeHandler typeHandler = null;
    protected String sqlNameEscape = "";
    protected boolean allowWriteOnVolatileFIDs;
    protected int transactionIsolation = 0;

    public JDBC1DataStore(JDBCDataStoreConfig config) throws IOException {
        this.config = config;
        this.typeHandler = this.getFeatureTypeHandler(config);
    }

    public String getSqlNameEscape() {
        return this.sqlNameEscape;
    }

    protected void setSqlNameEscape(String sqlNameEscape) {
        this.sqlNameEscape = sqlNameEscape;
    }

    protected FeatureTypeHandler getFeatureTypeHandler(JDBCDataStoreConfig config) throws IOException {
        return new FeatureTypeHandler(this, this.buildFIDMapperFactory(config), config.getTypeHandlerTimeout());
    }

    protected FIDMapperFactory buildFIDMapperFactory(JDBCDataStoreConfig config) {
        return new DefaultFIDMapperFactory();
    }

    public FIDMapper getFIDMapper(String tableName) throws IOException {
        return this.typeHandler.getFIDMapper(tableName);
    }

    protected LockingManager createLockingManager() {
        return new InProcessLockingManager();
    }

    public String[] getTypeNames() throws IOException {
        return this.typeHandler.getTypeNames();
    }

    public FeatureType getSchema(String typeName) throws IOException {
        return this.typeHandler.getSchema(typeName);
    }

    public void createSchema(FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Table creation not implemented");
    }

    public void updateSchema(String typeName, FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Table modification not supported");
    }

    public FeatureSource getView(Query query) throws IOException, SchemaException {
        return new DefaultView(this.getFeatureSource(query.getTypeName()), query);
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        if (!this.typeHandler.getFIDMapper(typeName).isVolatile() || this.allowWriteOnVolatileFIDs) {
            if (this.getLockingManager() != null) {
                return new JDBCFeatureLocking(this, this.getSchema(typeName));
            }
            return new JDBCFeatureStore(this, this.getSchema(typeName));
        }
        return new JDBCFeatureSource(this, this.getSchema(typeName));
    }

    /*
     * WARNING - void declaration
     */
    public FeatureReader getFeatureReader(FeatureType requestType, Filter filter, Transaction transaction) throws IOException {
        void var7_7;
        DefaultQuery query;
        String typeName = requestType.getTypeName();
        FeatureType schemaType = this.getSchema(typeName);
        int compare = DataUtilities.compare(requestType, schemaType);
        if (compare == 0) {
            query = new DefaultQuery(typeName, filter);
        } else if (compare == 1) {
            String[] names = this.attributeNames(requestType, filter);
            query = new DefaultQuery(typeName, filter, Integer.MAX_VALUE, names, "getFeatureReader");
        } else {
            throw new IOException("Type " + typeName + " does match request");
        }
        if (filter == Filter.ALL || filter.equals(Filter.ALL)) {
            return new EmptyFeatureReader(requestType);
        }
        FeatureReader reader = this.getFeatureReader((Query)var7_7, transaction);
        if (compare == 1) {
            reader = new ReTypeFeatureReader(reader, requestType, false);
        }
        return reader;
    }

    protected String[] attributeNames(FeatureType featureType, Filter filter) throws IOException {
        String typeName = featureType.getTypeName();
        FeatureType origional = this.getSchema(typeName);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        if (featureType.getAttributeCount() == origional.getAttributeCount()) {
            return DataUtilities.attributeNames(featureType);
        }
        String[] typeAttributes = DataUtilities.attributeNames(featureType);
        String[] filterAttributes = DataUtilities.attributeNames(sqlBuilder.getPostQueryFilter(filter));
        if (filterAttributes == null || filterAttributes.length == 0) {
            return typeAttributes;
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(typeAttributes));
        set.addAll(Arrays.asList(filterAttributes));
        if (set.size() == typeAttributes.length) {
            return typeAttributes;
        }
        return set.toArray(new String[set.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public FeatureReader getFeatureReader(Query query, Transaction trans) throws IOException {
        FeatureType schema;
        void var11_11;
        String[] propertyNames;
        String typeName = query.getTypeName();
        FeatureType featureType = this.getSchema(typeName);
        FeatureTypeInfo typeInfo = this.typeHandler.getFeatureTypeInfo(typeName);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        Filter preFilter = sqlBuilder.getPreQueryFilter(query.getFilter());
        Filter postFilter = sqlBuilder.getPostQueryFilter(query.getFilter());
        Filter originalFilter = query.getFilter();
        ((DefaultQuery)query).setFilter(preFilter);
        String[] requestedNames = this.propertyNames(query);
        if (this.allSameOrder(requestedNames, featureType)) {
            propertyNames = requestedNames;
        } else if (requestedNames.length <= featureType.getAttributeCount()) {
            String[] filterNames = DataUtilities.attributeNames(postFilter);
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(requestedNames));
            set.addAll(Arrays.asList(filterNames));
            propertyNames = set.size() == requestedNames.length ? requestedNames : set.toArray(new String[set.size()]);
            try {
                typeInfo = new FeatureTypeInfo(typeInfo.getFeatureTypeName(), DataUtilities.createSubType(typeInfo.getSchema(), propertyNames), typeInfo.getFIDMapper());
            }
            catch (SchemaException e1) {
                throw new DataSourceException("Could not create subtype", (Throwable)e1);
            }
        } else {
            throw new DataSourceException(typeName + " does not contain requested properties:" + query);
        }
        AttributeType[] attrTypes = null;
        try {
            attrTypes = this.getAttributeTypes(typeName, (String[])var11_11);
        }
        catch (SchemaException schemaException) {
            throw new DataSourceException("Some Attribute Names were specified that do not exist in the FeatureType " + typeName + ". " + "Requested names: " + Arrays.asList(var11_11) + ", " + "FeatureType: " + featureType, (Throwable)schemaException);
        }
        String sqlQuery = this.constructQuery(query, attrTypes);
        ((DefaultQuery)query).setFilter(originalFilter);
        QueryData queryData = this.executeQuery(typeInfo, typeName, sqlQuery, trans, false);
        try {
            schema = FeatureTypeBuilder.newFeatureType(attrTypes, typeName, this.getNameSpace());
        }
        catch (FactoryRegistryException e) {
            throw new DataSourceException("Schema Factory Error when creating schema for FeatureReader", (Throwable)e);
        }
        catch (SchemaException e) {
            throw new DataSourceException("Schema Error when creating schema for FeatureReader", (Throwable)e);
        }
        FeatureReader reader = this.createFeatureReader(schema, postFilter, queryData);
        if (requestedNames.length < ((void)var11_11).length) {
            try {
                FeatureType requestType = DataUtilities.createSubType(schema, requestedNames);
                reader = new ReTypeFeatureReader(reader, requestType, false);
            }
            catch (SchemaException schemaException) {
                throw new DataSourceException("Could not handle query", (Throwable)schemaException);
            }
        }
        return reader;
    }

    private String constructQuery(Query query, AttributeType[] attrTypes) throws IOException, DataSourceException {
        String sqlQuery;
        String typeName = query.getTypeName();
        SQLBuilder sqlBuilder = this.getSqlBuilder(query.getTypeName());
        Filter preFilter = sqlBuilder.getPreQueryFilter(query.getFilter());
        FIDMapper mapper = this.getFIDMapper(typeName);
        try {
            StringBuffer buf;
            LOGGER.fine("calling sql builder with filter " + preFilter);
            if (query.getFilter() == Filter.ALL) {
                buf = new StringBuffer("SELECT ");
                sqlBuilder.sqlColumns(buf, mapper, attrTypes);
                sqlBuilder.sqlFrom(buf, typeName);
                buf.append(" WHERE '1' = '0'");
                sqlQuery = buf.toString();
            } else {
                sqlQuery = sqlBuilder.buildSQLQuery(typeName, mapper, attrTypes, preFilter);
            }
            if (query.getSortBy() != null) {
                buf = new StringBuffer();
                buf.append(sqlQuery);
                sqlBuilder.sqlOrderBy(buf, query.getSortBy());
                sqlQuery = buf.toString();
            }
            LOGGER.fine("sql is " + sqlQuery);
        }
        catch (SQLEncoderException e) {
            throw new DataSourceException("Error building SQL Query", (Throwable)e);
        }
        return sqlQuery;
    }

    protected FeatureReader createFeatureReader(FeatureType schema, Filter postFilter, QueryData queryData) throws IOException {
        Object fReader = this.getJDBCFeatureReader(queryData);
        if (postFilter != null && postFilter != Filter.NONE) {
            fReader = new FilteringFeatureReader((FeatureReader)fReader, postFilter);
        }
        if (postFilter == Filter.ALL) {
            return new EmptyFeatureReader(schema);
        }
        return fReader;
    }

    protected JDBCFeatureReader getJDBCFeatureReader(QueryData queryData) throws IOException {
        return new JDBCFeatureReader(queryData);
    }

    protected AttributeIO getAttributeIO(AttributeType type) {
        if (this.basicAttributeIO == null) {
            this.basicAttributeIO = new BasicAttributeIO();
        }
        return this.basicAttributeIO;
    }

    protected abstract AttributeIO getGeometryAttributeIO(AttributeType var1, QueryData var2) throws IOException;

    protected QueryData executeQuery(FeatureTypeInfo featureTypeInfo, String tableName, String sqlQuery, Transaction transaction, boolean forWrite) throws IOException {
        LOGGER.fine("About to execute query: " + sqlQuery);
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(transaction);
            this.setAutoCommit(forWrite, conn);
            statement = conn.createStatement(this.getResultSetType(forWrite), this.getConcurrency(forWrite));
            statement.setFetchSize(1000);
            rs = statement.executeQuery(sqlQuery);
            return new QueryData(featureTypeInfo, this, conn, statement, rs, transaction);
        }
        catch (SQLException e) {
            String msg = "Error Performing SQL query: " + sqlQuery;
            LOGGER.log(Level.SEVERE, msg, e);
            JDBCUtils.close(rs);
            JDBCUtils.close(statement);
            JDBCUtils.close(conn, transaction, e);
            throw new DataSourceException(msg, (Throwable)e);
        }
    }

    protected void setAutoCommit(boolean forWrite, Connection conn) throws SQLException {
        if (!forWrite) {
            conn.setAutoCommit(false);
        }
    }

    protected int getResultSetType(boolean forWrite) {
        return 1003;
    }

    protected int getConcurrency(boolean forWrite) {
        if (forWrite) {
            return 1008;
        }
        return 1007;
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        SQLEncoder encoder = new SQLEncoder();
        encoder.setFIDMapper(this.getFIDMapper(typeName));
        return new DefaultSQLBuilder(encoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(Transaction transaction) throws IOException {
        if (transaction != Transaction.AUTO_COMMIT) {
            JDBCTransactionState state;
            Transaction transaction2 = transaction;
            synchronized (transaction2) {
                state = (JDBCTransactionState)transaction.getState((Object)this);
                if (state == null) {
                    try {
                        Connection conn = this.createConnection();
                        conn.setAutoCommit(this.requireAutoCommit());
                        if (this.getTransactionIsolation() != 0) {
                            conn.setTransactionIsolation(this.getTransactionIsolation());
                        }
                        state = new JDBCTransactionState(conn);
                        transaction.putState((Object)this, (Transaction.State)state);
                    }
                    catch (SQLException eep) {
                        throw new DataSourceException("Connection failed:" + eep, (Throwable)eep);
                    }
                }
            }
            return state.getConnection();
        }
        try {
            return this.createConnection();
        }
        catch (SQLException sqle) {
            throw new DataSourceException("Connection failed:" + sqle, (Throwable)sqle);
        }
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int value) {
        this.transactionIsolation = value;
    }

    protected boolean requireAutoCommit() {
        return false;
    }

    protected abstract Connection createConnection() throws SQLException;

    protected boolean allowTable(String tablename) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FIDMapper buildFIDMapper(String typeName, FIDMapperFactory factory) throws IOException {
        Connection conn = null;
        try {
            FIDMapper mapper;
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            FIDMapper fIDMapper = mapper = factory.getMapper(null, this.config.getDatabaseSchemaName(), typeName, conn);
            return fIDMapper;
        }
        finally {
            JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FeatureType buildSchema(String typeName, FIDMapper mapper) throws IOException {
        FeatureType featureType;
        int NAME_COLUMN = 4;
        int TYPE_NAME = 6;
        Connection conn = null;
        ResultSet tableInfo = null;
        try {
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            ArrayList<AttributeType> attributeTypes = new ArrayList<AttributeType>();
            tableInfo = dbMetaData.getColumns(null, this.config.getDatabaseSchemaName(), typeName, "%");
            boolean tableInfoFound = false;
            while (tableInfo.next()) {
                tableInfoFound = true;
                try {
                    AttributeType attributeType;
                    String columnName = tableInfo.getString(4);
                    if (!mapper.returnFIDColumnsAsAttributes()) {
                        boolean isPresent = false;
                        for (int i = 0; i < mapper.getColumnCount(); ++i) {
                            if (!columnName.equalsIgnoreCase(mapper.getColumnName(i))) continue;
                            isPresent = true;
                            break;
                        }
                        if (isPresent) continue;
                    }
                    if ((attributeType = this.buildAttributeType(tableInfo)) != null) {
                        attributeTypes.add(attributeType);
                        continue;
                    }
                    LOGGER.finest("Unknown SQL Type: " + tableInfo.getString(6));
                }
                catch (DataSourceException dse) {
                    String msg = "Error building attribute type. The column will be ignored";
                    LOGGER.log(Level.WARNING, msg, dse);
                }
            }
            if (!tableInfoFound) {
                throw new SchemaNotFoundException(typeName);
            }
            AttributeType[] types = attributeTypes.toArray(new AttributeType[0]);
            featureType = FeatureTypeBuilder.newFeatureType(types, typeName, this.getNameSpace());
        }
        catch (SQLException sqlException) {
            try {
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, sqlException);
                conn = null;
                throw new DataSourceException("SQL Error building FeatureType for " + typeName + " " + sqlException.getMessage(), (Throwable)sqlException);
                catch (FactoryRegistryException e) {
                    throw new DataSourceException("Error creating FeatureType " + typeName, (Throwable)e);
                }
                catch (SchemaException e) {
                    throw new DataSourceException("Error creating FeatureType for " + typeName, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.close(tableInfo);
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
                throw throwable;
            }
        }
        JDBCUtils.close(tableInfo);
        JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        return featureType;
    }

    protected AttributeType buildAttributeType(ResultSet rs) throws IOException {
        try {
            int COLUMN_NAME = 4;
            int DATA_TYPE = 5;
            String columnName = rs.getString(4);
            int dataType = rs.getInt(5);
            Class type = (Class)TYPE_MAPPINGS.get(new Integer(dataType));
            if (type == null) {
                return null;
            }
            return AttributeTypeFactory.newAttributeType(columnName, type);
        }
        catch (SQLException e) {
            throw new IOException("SQL exception occurred: " + e.getMessage());
        }
    }

    protected int determineSRID(String tableName, String geometryColumnName) throws IOException {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String determineFidColumnName(String typeName) throws IOException {
        Connection conn;
        ResultSet rs;
        String fidColumnName;
        block4: {
            int NAME_COLUMN = 4;
            fidColumnName = null;
            rs = null;
            conn = null;
            try {
                conn = this.getConnection(Transaction.AUTO_COMMIT);
                DatabaseMetaData dbMetadata = conn.getMetaData();
                rs = dbMetadata.getPrimaryKeys(null, null, typeName);
                if (!rs.next()) break block4;
                fidColumnName = rs.getString(4);
            }
            catch (SQLException sqlException) {
                try {
                    JDBCUtils.close(conn, Transaction.AUTO_COMMIT, sqlException);
                    conn = null;
                    LOGGER.warning("Could not find the primary key - using the default");
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(rs);
                    JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
                    throw throwable;
                }
                JDBCUtils.close(rs);
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
            }
        }
        JDBCUtils.close(rs);
        JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        return fidColumnName;
    }

    public URI getNameSpace() {
        try {
            if (this.config.getNamespace() != null) {
                return new URI(this.config.getNamespace());
            }
        }
        catch (URISyntaxException e) {
            LOGGER.warning("Could not use namespace " + this.config.getNamespace() + " - " + e.getMessage());
            return null;
        }
        return null;
    }

    public FeatureWriter getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.getFeatureWriter(typeName, Filter.NONE, transaction);
    }

    public FeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        FeatureWriter writer = this.getFeatureWriter(typeName, Filter.ALL, transaction);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    public FeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        String sqlQuery;
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.NONE?");
        }
        if (transaction == null) {
            throw new NullPointerException("getFeatureReader requires Transaction: did you mean Transaction.AUTO_COMMIT");
        }
        FeatureType featureType = this.getSchema(typeName);
        FeatureTypeInfo info = this.typeHandler.getFeatureTypeInfo(typeName);
        LOGGER.fine("getting feature writer for " + typeName + ": " + info);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        Filter preFilter = sqlBuilder.getPreQueryFilter(filter);
        Filter postFilter = sqlBuilder.getPostQueryFilter(filter);
        DefaultQuery query = new DefaultQuery(typeName, preFilter);
        try {
            sqlQuery = this.constructQuery(query, this.getAttributeTypes(typeName, this.propertyNames(query)));
        }
        catch (SchemaException e) {
            throw new DataSourceException("Some Attribute Names were specified that do not exist in the FeatureType " + typeName + ". " + "Requested names: " + Arrays.asList(query.getPropertyNames()) + ", " + "FeatureType: " + featureType, (Throwable)e);
        }
        QueryData queryData = this.executeQuery(this.typeHandler.getFeatureTypeInfo(typeName), typeName, sqlQuery, transaction, true);
        FeatureReader reader = this.createFeatureReader(info.getSchema(), postFilter, queryData);
        JDBCFeatureWriter writer = this.createFeatureWriter(reader, queryData);
        if (this.getLockingManager() != null && this.getLockingManager() instanceof InProcessLockingManager) {
            InProcessLockingManager inProcess = (InProcessLockingManager)this.getLockingManager();
            writer = inProcess.checkedWriter(writer, transaction);
        }
        return writer;
    }

    protected JDBCFeatureWriter createFeatureWriter(FeatureReader reader, QueryData queryData) throws IOException {
        LOGGER.fine("returning jdbc feature writer");
        JDBCFeatureWriter featureWriter = new JDBCFeatureWriter(reader, queryData);
        featureWriter.setFeatureListenerManager(this.listenerManager);
        return featureWriter;
    }

    protected String[] propertyNames(Query query) throws IOException {
        String[] names = query.getPropertyNames();
        if (names == null || query.retrieveAllProperties()) {
            String typeName = query.getTypeName();
            FeatureType schema = this.getSchema(typeName);
            names = new String[schema.getAttributeCount()];
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                names[i] = schema.getAttributeType(i).getName();
            }
        }
        return names;
    }

    protected final AttributeType[] getAttributeTypes(String typeName, String[] propertyNames) throws IOException, SchemaException {
        FeatureType schema = this.getSchema(typeName);
        AttributeType[] types = new AttributeType[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            types[i] = schema.getAttributeType(propertyNames[i]);
            if (types[i] != null) continue;
            throw new SchemaException(typeName + " does not contain requested " + propertyNames[i] + " attribute");
        }
        return types;
    }

    public LockingManager getLockingManager() {
        return this.lockingManager;
    }

    public void setFIDMapper(String featureTypeName, FIDMapper fidMapper) {
        this.typeHandler.setFIDMapper(featureTypeName, fidMapper);
    }

    public FIDMapperFactory getFIDMapperFactory() {
        return this.typeHandler.getFIDMapperFactory();
    }

    public void setFIDMapperFactory(FIDMapperFactory fmFactory) throws UnsupportedOperationException {
        this.typeHandler.setFIDMapperFactory(fmFactory);
    }

    public boolean allSameOrder(String[] requestedNames, FeatureType ft) {
        if (requestedNames.length != ft.getAttributeCount()) {
            return false;
        }
        for (int t = 0; t < requestedNames.length; ++t) {
            if (requestedNames[t].equals(ft.getAttributeType(t).getName())) continue;
            return false;
        }
        return true;
    }

    public Envelope getEnvelope(String typeName) {
        return null;
    }

    static {
        TYPE_MAPPINGS.put(new Integer(12), String.class);
        TYPE_MAPPINGS.put(new Integer(1), String.class);
        TYPE_MAPPINGS.put(new Integer(-1), String.class);
        TYPE_MAPPINGS.put(new Integer(-7), Boolean.class);
        TYPE_MAPPINGS.put(new Integer(16), Boolean.class);
        TYPE_MAPPINGS.put(new Integer(-6), Short.class);
        TYPE_MAPPINGS.put(new Integer(5), Short.class);
        TYPE_MAPPINGS.put(new Integer(4), Integer.class);
        TYPE_MAPPINGS.put(new Integer(-5), Long.class);
        TYPE_MAPPINGS.put(new Integer(7), Float.class);
        TYPE_MAPPINGS.put(new Integer(6), Double.class);
        TYPE_MAPPINGS.put(new Integer(8), Double.class);
        TYPE_MAPPINGS.put(new Integer(3), BigDecimal.class);
        TYPE_MAPPINGS.put(new Integer(2), BigDecimal.class);
        TYPE_MAPPINGS.put(new Integer(91), Date.class);
        TYPE_MAPPINGS.put(new Integer(92), Time.class);
        TYPE_MAPPINGS.put(new Integer(93), Timestamp.class);
    }
}

