/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ForceCoordinateSystemFeatureReader
implements FeatureReader {
    protected FeatureReader reader;
    protected FeatureType schema;

    ForceCoordinateSystemFeatureReader(FeatureReader reader, FeatureType schema) {
        this.reader = reader;
        this.schema = schema;
    }

    public ForceCoordinateSystemFeatureReader(FeatureReader reader, CoordinateReferenceSystem cs) throws SchemaException {
        this(reader, cs, false);
    }

    public ForceCoordinateSystemFeatureReader(FeatureReader reader, CoordinateReferenceSystem cs, boolean forceOnlyMissing) throws SchemaException {
        if (cs == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        FeatureType type = reader.getFeatureType();
        CoordinateReferenceSystem originalCs = type.getDefaultGeometry().getCoordinateSystem();
        if (!cs.equals(originalCs)) {
            this.schema = FeatureTypes.transform(type, cs, forceOnlyMissing);
        }
        this.reader = reader;
    }

    public FeatureType getFeatureType() {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        if (this.schema == null) {
            return this.reader.getFeatureType();
        }
        return this.schema;
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        Feature next = this.reader.next();
        if (this.schema == null) {
            return next;
        }
        return this.schema.create(next.getAttributes(null), next.getID());
    }

    public boolean hasNext() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    public void close() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        this.reader.close();
        this.reader = null;
        this.schema = null;
    }
}

