/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.unijena.jams.runtime.JAMSRuntime;

public class JAMSClassLoader
extends URLClassLoader {
    private URL[] urls;

    public JAMSClassLoader(URL[] urls) {
        super(urls, ClassLoader.getSystemClassLoader());
        this.urls = urls;
    }

    public JAMSClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.urls = urls;
    }

    private void loadAll() {
        for (URL jar : this.urls) {
            System.out.println(jar.getFile());
            try {
                JarInputStream jis = new JarInputStream(new FileInputStream(jar.getFile()));
                JarEntry entry = jis.getNextJarEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (name.endsWith(".class")) {
                        name = name.substring(0, name.length() - 6);
                        name = name.replace('/', '.');
                        System.out.print("> " + name);
                        try {
                            this.loadClass(name);
                            System.out.println("\t- loaded");
                        }
                        catch (Throwable e) {
                            System.out.println("\t- not loaded");
                            System.out.println("\t " + e.getClass().getName() + ": " + e.getMessage());
                        }
                    }
                    entry = jis.getNextJarEntry();
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    public Class load(String name, byte[] data) {
        return this.defineClass(name, data, 0, data.length);
    }

    private static void addFile(Set<URL> urls, File f, JAMSRuntime rt) {
        try {
            URL url = f.toURI().toURL();
            if (!urls.add(url)) {
                rt.println("WARNING : The file " + f.getAbsolutePath() + " is already loaded");
            }
        }
        catch (MalformedURLException murle) {
            rt.println("WARNING : The file " + f.getAbsolutePath() + " could not be converted to URL.");
        }
    }

    public static ClassLoader createClassLoader(String[] libs, JAMSRuntime rt) {
        HashSet<URL> urls = new HashSet<URL>();
        for (String lib : libs) {
            File dir = new File(lib);
            if (!dir.exists()) {
                rt.println("DANGER - directory " + dir.getAbsolutePath() + " does not exist", 1);
                continue;
            }
            if (dir.isDirectory()) {
                File[] files;
                for (File file : files = dir.listFiles()) {
                    if (!file.getName().endsWith(".jar")) continue;
                    JAMSClassLoader.addFile(urls, file, rt);
                }
                continue;
            }
            JAMSClassLoader.addFile(urls, dir, rt);
        }
        rt.println("created class loader using " + urls, 1);
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        JAMSClassLoader cl = new JAMSClassLoader(urlArray);
        return cl;
    }
}

