/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class XMLProcessor {
    static String[] regex = new String[]{"jamsvar class=\".*\" name", "compoundcomponent", "jamsvar", "providervar", "spatattrib", "provider=", "org\\.unijena\\.jams\\.gui", "org\\.unijena\\.jamscomponents"};
    static String[] replace = new String[]{"jamsvar name", "contextcomponent", "var", "cvar", "attribute", "context=", "jams.components.gui", "jams.components"};

    public static String modelDocConverter(String inFileName) {
        String outFileName = inFileName;
        try {
            String s;
            BufferedReader reader = new BufferedReader(new FileReader(inFileName));
            String newDoc = "";
            while ((s = reader.readLine()) != null) {
                newDoc = newDoc + s + "\n";
            }
            String oldDoc = newDoc = newDoc.substring(0, newDoc.length() - 1);
            for (int i = 0; i < regex.length; ++i) {
                newDoc = newDoc.replaceAll(regex[i], replace[i]);
            }
            if (!newDoc.contentEquals(oldDoc)) {
                File f = new File(inFileName);
                String fName = "_" + f.getCanonicalFile().getName();
                String pName = f.getParent();
                outFileName = pName + File.separator + fName;
                BufferedWriter writer = new BufferedWriter(new FileWriter(outFileName));
                writer.write(newDoc);
                writer.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return outFileName;
    }
}

