/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.data;

import java.util.ArrayList;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityEnumerator;
import org.unijena.jams.data.JAMSSerializableData;

public class JAMSEntityCollection
extends JAMSSerializableData {
    protected ArrayList<JAMSEntity> entities = new ArrayList();
    protected JAMSEntity[] entityArray;
    protected JAMSEntity current;

    public JAMSEntity[] getEntityArray() {
        return this.entityArray;
    }

    public JAMSEntityEnumerator getEntityEnumerator() {
        return new EntityEnumerator();
    }

    public ArrayList<JAMSEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(ArrayList<JAMSEntity> entities) {
        this.entities = entities;
        this.entityArray = entities.toArray(new JAMSEntity[entities.size()]);
        this.current = this.entityArray.length > 0 ? this.entityArray[0] : null;
    }

    public JAMSEntity getCurrent() {
        return this.current;
    }

    @Override
    public void setValue(String data) {
    }

    public void setValue(ArrayList<JAMSEntity> entities) {
        this.setEntities(entities);
    }

    public ArrayList<JAMSEntity> getValue() {
        return this.getEntities();
    }

    class EntityEnumerator
    implements JAMSEntityEnumerator {
        JAMSEntity[] entityArray;
        int index;

        EntityEnumerator() {
            this.entityArray = JAMSEntityCollection.this.getEntityArray();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.entityArray.length;
        }

        @Override
        public JAMSEntity next() {
            ++this.index;
            JAMSEntityCollection.this.current = this.entityArray[this.index];
            return this.entityArray[this.index];
        }

        @Override
        public void reset() {
            this.index = 0;
            JAMSEntityCollection.this.current = this.entityArray[this.index];
        }
    }
}

