/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import org.unijena.jams.io.XMLIO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ModelConfig {
    private HashMap<String, ArrayList<Setting>> settings = new HashMap();

    public ModelConfig() {
    }

    public ModelConfig(Document doc) {
        this.readConfig(doc);
    }

    public ModelConfig(String fileName) {
        this.readConfig(fileName);
    }

    public void readConfig(String fileName) {
        try {
            this.readConfig(XMLIO.getDocument(fileName));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void readConfig(Document doc) {
        Element root = (Element)doc.getDocumentElement().getElementsByTagName("launcher").item(0);
        NodeList groups = root.getElementsByTagName("group");
        for (int i = 0; i < groups.getLength(); ++i) {
            Element group = (Element)groups.item(i);
            NodeList properties = group.getElementsByTagName("property");
            for (int j = 0; j < properties.getLength(); ++j) {
                Element property = (Element)properties.item(j);
                this.addSetting(property.getAttribute("component"), property.getAttribute("attribute"), property.getAttribute("value"));
            }
        }
    }

    public void addSetting(String componentName, String attributeName, String attributeValue) {
        ArrayList<Setting> list = this.settings.get(componentName);
        if (list == null) {
            list = new ArrayList();
        }
        list.add(new Setting(attributeName, attributeValue));
        this.settings.put(componentName, list);
    }

    public ArrayList<Setting> getSettings(String componentName) {
        return this.settings.get(componentName);
    }

    public class Setting {
        private String attribute;
        private String value;

        public Setting(String attribute, String value) {
            this.attribute = attribute;
            this.value = value;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getValue() {
            return this.value;
        }
    }
}

