/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;

public class Debug {
    public static String DEBUG_PROPERTY_NAME = "jts.debug";
    public static String DEBUG_PROPERTY_VALUE_ON = "on";
    public static String DEBUG_PROPERTY_VALUE_TRUE = "true";
    private static boolean debugOn = false;
    private static final Debug debug;
    private static final GeometryFactory fact;
    private static final String DEBUG_LINE_TAG = "D! ";
    private PrintStream out;
    private Class[] printArgs;
    private Object watchObj = null;
    private Object[] args = new Object[1];

    public static void main(String[] args) {
        System.out.println("JTS Debugging is " + (debugOn ? "ON" : "OFF"));
    }

    public static boolean isDebugging() {
        return debugOn;
    }

    public static LineString toLine(Coordinate p0, Coordinate p1) {
        return fact.createLineString(new Coordinate[]{p0, p1});
    }

    public static LineString toLine(Coordinate p0, Coordinate p1, Coordinate p2) {
        return fact.createLineString(new Coordinate[]{p0, p1, p2});
    }

    public static LineString toLine(Coordinate p0, Coordinate p1, Coordinate p2, Coordinate p3) {
        return fact.createLineString(new Coordinate[]{p0, p1, p2, p3});
    }

    public static void print(String str) {
        if (!debugOn) {
            return;
        }
        debug.instancePrint(str);
    }

    public static void print(Object obj) {
        if (!debugOn) {
            return;
        }
        debug.instancePrint(obj);
    }

    public static void print(boolean isTrue, Object obj) {
        if (!debugOn) {
            return;
        }
        if (!isTrue) {
            return;
        }
        debug.instancePrint(obj);
    }

    public static void println(Object obj) {
        if (!debugOn) {
            return;
        }
        debug.instancePrint(obj);
        debug.println();
    }

    public static void addWatch(Object obj) {
        debug.instanceAddWatch(obj);
    }

    public static void printWatch() {
        debug.instancePrintWatch();
    }

    public static void printIfWatch(Object obj) {
        debug.instancePrintIfWatch(obj);
    }

    private Debug() {
        this.out = System.out;
        this.printArgs = new Class[1];
        try {
            this.printArgs[0] = Class.forName("java.io.PrintStream");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void instancePrintWatch() {
        if (this.watchObj == null) {
            return;
        }
        this.instancePrint(this.watchObj);
    }

    public void instancePrintIfWatch(Object obj) {
        if (obj != this.watchObj) {
            return;
        }
        if (this.watchObj == null) {
            return;
        }
        this.instancePrint(this.watchObj);
    }

    public void instancePrint(Object obj) {
        if (obj instanceof Collection) {
            this.instancePrint(((Collection)obj).iterator());
        } else if (obj instanceof Iterator) {
            this.instancePrint((Iterator)obj);
        } else {
            this.instancePrintObject(obj);
        }
    }

    public void instancePrint(Iterator it) {
        while (it.hasNext()) {
            Object obj = it.next();
            this.instancePrintObject(obj);
        }
    }

    public void instancePrintObject(Object obj) {
        Method printMethod = null;
        try {
            Class<?> cls = obj.getClass();
            try {
                printMethod = cls.getMethod("print", this.printArgs);
                this.args[0] = this.out;
                this.out.print(DEBUG_LINE_TAG);
                printMethod.invoke(obj, this.args);
            }
            catch (NoSuchMethodException ex) {
                this.instancePrint(obj.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(this.out);
        }
    }

    public void println() {
        this.out.println();
    }

    private void instanceAddWatch(Object obj) {
        this.watchObj = obj;
    }

    private void instancePrint(String str) {
        this.out.print(DEBUG_LINE_TAG);
        this.out.print(str);
    }

    static {
        String debugValue = System.getProperty(DEBUG_PROPERTY_NAME);
        if (debugValue != null && (debugValue.equalsIgnoreCase(DEBUG_PROPERTY_VALUE_ON) || debugValue.equalsIgnoreCase(DEBUG_PROPERTY_VALUE_TRUE))) {
            debugOn = true;
        }
        debug = new Debug();
        fact = new GeometryFactory();
    }
}

