/*
 * Decompiled with CFR 0.152.
 */
package jams.components.optimizer;

import jams.components.optimizer.MOCOM_Comparator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSIntegerArray;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class MOCOM
extends JAMSContext {
    int randcounter = 0;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter identifiers to be sampled")
    public JAMSString parameterIDs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter value bounaries corresponding to parameter identifiers")
    public JAMSString boundaries;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="efficiency methods")
    public JAMSString effMethodNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="efficiency values")
    public JAMSDouble[] effValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="maximize efficiency?")
    public JAMSIntegerArray MaximizeEff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Flag for enabling/disabling this sampler")
    public JAMSBoolean enable;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file name")
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="population size")
    public JAMSInteger populationSize;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="maximum number of iterations")
    public JAMSInteger maxIter;
    JAMSDouble[] parameters;
    String[] parameterNames;
    String[] effNames;
    double[] lowBound;
    double[] upBound;
    int currentCount;
    Random generator = new Random();
    GenericDataWriter writer;
    static final int MAXIMIZATION = 1;
    static final int MINIMIZATION = 2;
    static final int ABSMAXIMIZATION = 3;
    static final int ABSMINIMIZATION = 4;
    int N;
    int M;
    int n;
    int s;
    int m;
    int icall = 0;
    int MaxIter;
    boolean continousOutput = false;
    long start;
    long end = 0L;

    public void init() {
        this.start = System.currentTimeMillis();
        if (this.enable.getValue()) {
            int p;
            String key;
            this.icall = 0;
            StringTokenizer tok = new StringTokenizer(this.parameterIDs.getValue(), ";");
            this.parameters = new JAMSDouble[tok.countTokens()];
            this.parameterNames = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                this.parameterNames[i] = key = tok.nextToken();
                this.parameters[i] = (JAMSDouble)this.getModel().getRuntime().getDataHandles().get(key);
                ++i;
            }
            this.entities = (JAMSEntityCollection)this.getModel().getRuntime().getDataHandles().get("hrus");
            tok = new StringTokenizer(this.boundaries.getValue(), ";");
            int n = tok.countTokens();
            this.lowBound = new double[n];
            this.upBound = new double[n];
            if (n != i) {
                this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": Different number of parameterIDs and boundaries!");
            }
            i = 0;
            while (tok.hasMoreTokens()) {
                key = tok.nextToken();
                key = key.substring(1, key.length() - 1);
                StringTokenizer boundTok = new StringTokenizer(key, ">");
                this.lowBound[i] = Double.parseDouble(boundTok.nextToken());
                this.upBound[i] = Double.parseDouble(boundTok.nextToken());
                if (this.upBound[i] <= this.lowBound[i]) {
                    this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": upBound must be higher than lowBound!");
                }
                ++i;
            }
            i = 0;
            tok = new StringTokenizer(this.effMethodNames.getValue(), ";");
            this.effNames = new String[tok.countTokens()];
            while (tok.hasMoreTokens()) {
                this.effNames[i] = key = tok.nextToken();
                ++i;
            }
            this.N = this.parameterNames.length;
            this.M = this.effNames.length;
            this.writer = new GenericDataWriter(this.dirName.getValue() + "/" + this.fileName.getValue());
            this.writer.addComment("MOCOM output start: ");
            for (p = 0; p < this.parameterNames.length; ++p) {
                this.writer.addColumn(this.parameterNames[p]);
            }
            for (p = 0; p < this.effNames.length; ++p) {
                this.writer.addColumn(this.effNames[p]);
            }
            this.writer.writeHeader();
            this.writer.flush();
        }
    }

    public double Custom_rand() {
        ++this.randcounter;
        return this.generator.nextDouble();
    }

    private void singleRun() {
        JAMSComponent comp;
        ++this.icall;
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void disabledRun() {
        JAMSComponent comp;
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (IOException e) {
                System.out.println(comp.getInstanceName());
                e.printStackTrace();
            }
            catch (Exception exception) {}
        }
    }

    private boolean IsSampleValid(double[] sample) {
        JAMSDouble[] conv_sample = new JAMSDouble[sample.length];
        for (int i = 0; i < sample.length; ++i) {
            conv_sample[i] = new JAMSDouble(sample[i]);
        }
        return this.IsSampleValid(conv_sample);
    }

    private boolean IsSampleValid(JAMSDouble[] sample) {
        int paras = this.parameterNames.length;
        boolean criticalPara = false;
        double criticalParaValue = 0.0;
        for (int i = 0; i < paras; ++i) {
            if (!(sample[i].getValue() < this.lowBound[i]) && !(sample[i].getValue() > this.upBound[i])) continue;
            return false;
        }
        return true;
    }

    public double[] compob(double[] x) {
        double value = 0.0;
        for (int j = 0; j < this.parameters.length; ++j) {
            this.parameters[j].setValue(x[j]);
        }
        this.singleRun();
        double[] F = new double[this.M];
        for (int i = 0; i < this.M; ++i) {
            if (this.MaximizeEff.getValue()[i] == 2) {
                F[i] = this.effValues[i].getValue();
                continue;
            }
            if (this.MaximizeEff.getValue()[i] == 4) {
                F[i] = Math.abs(this.effValues[i].getValue());
                continue;
            }
            if (this.MaximizeEff.getValue()[i] == 3) {
                F[i] = -Math.abs(this.effValues[i].getValue());
                continue;
            }
            if (this.MaximizeEff.getValue()[i] != 1) continue;
            F[i] = -this.effValues[i].getValue();
        }
        return F;
    }

    public void sort(double[][] x, int col) {
        MOCOM_Comparator comparator = new MOCOM_Comparator(col, false);
        Arrays.sort(x, comparator);
    }

    public int[] randperm(int upto) {
        int i;
        int[] perm = new int[upto];
        int[] freenums = new int[upto];
        for (i = 0; i < upto; ++i) {
            freenums[i] = i + 1;
        }
        for (i = 1; i <= upto; ++i) {
            int num = (int)Math.floor(this.Custom_rand() * (double)(upto + 1 - i) + 1.0);
            perm[i - 1] = freenums[num - 1];
            freenums[num - 1] = freenums[upto - i];
        }
        return perm;
    }

    public double[][] lhsu(double[] xmin, double[] xmax, int nsample) {
        int nvar = xmin.length;
        double[][] s = new double[nsample][nvar];
        for (int j = 0; j < nvar; ++j) {
            int[] idx = this.randperm(nsample);
            for (int i = 0; i < nsample; ++i) {
                double P = ((double)idx[i] - this.Custom_rand()) / (double)nsample;
                s[i][j] = xmin[j] + P * (xmax[j] - xmin[j]);
            }
        }
        return s;
    }

    public double[][] compf(double[][] D, int m) {
        int s = D.length;
        int r = 0;
        if (s == 0) {
            return null;
        }
        r = D[0].length;
        double[][] F = new double[s][];
        for (int i = 0; i < s; ++i) {
            F[i] = this.compob(D[i]);
        }
        return F;
    }

    public int IntMax(int[] R) {
        int RMax = Integer.MIN_VALUE;
        for (int i = 0; i < R.length; ++i) {
            if (RMax >= R[i]) continue;
            RMax = R[i];
        }
        return RMax;
    }

    public Object[] parrank(double[][] ObjVals, int nmbOfObjs) {
        int i;
        int nmbOfIndivs = ObjVals.length;
        Vector[] Dominated = new Vector[nmbOfIndivs];
        Vector Front = new Vector();
        int[] NmbOfFront = new int[nmbOfIndivs];
        int[] NmbOfDominating = new int[nmbOfIndivs];
        for (i = 0; i < nmbOfIndivs; ++i) {
            NmbOfFront[i] = 0;
            NmbOfDominating[i] = 0;
            Dominated[i] = new Vector();
        }
        for (int p = 0; p < nmbOfIndivs; ++p) {
            for (int q = 0; q < nmbOfIndivs; ++q) {
                int k;
                int sumA1 = 0;
                int sumA2 = 0;
                int sumB1 = 0;
                int sumB2 = 0;
                for (k = 0; k < nmbOfObjs; ++k) {
                    if (ObjVals[p][k] <= ObjVals[q][k]) {
                        ++sumA1;
                    }
                    if (!(ObjVals[p][k] < ObjVals[q][k])) continue;
                    ++sumA2;
                }
                for (k = 0; k < nmbOfObjs; ++k) {
                    if (ObjVals[q][k] <= ObjVals[p][k]) {
                        ++sumB1;
                    }
                    if (!(ObjVals[q][k] < ObjVals[p][k])) continue;
                    ++sumB2;
                }
                if (sumA1 == nmbOfObjs && sumA2 > 0) {
                    Dominated[p].addElement(new Integer(q));
                    continue;
                }
                if (sumB1 != nmbOfObjs || sumB2 <= 0) continue;
                int n = p;
                NmbOfDominating[n] = NmbOfDominating[n] + 1;
            }
            if (NmbOfDominating[p] != 0) continue;
            NmbOfFront[p] = 1;
            if (Front.size() == 0) {
                Front.add(new Vector());
            }
            ((Vector)Front.get(0)).add(new Integer(p));
        }
        i = 0;
        while (((Vector)Front.get(i)).size() != 0) {
            Vector<Integer> NextFront = new Vector<Integer>();
            for (int k = 0; k < ((Vector)Front.get(i)).size(); ++k) {
                int p = (Integer)((Vector)Front.get(i)).get(k);
                for (int l = 0; l < Dominated[p].size(); ++l) {
                    int q;
                    int n = q = ((Integer)Dominated[p].get(l)).intValue();
                    NmbOfDominating[n] = NmbOfDominating[n] - 1;
                    if (NmbOfDominating[q] != 0) continue;
                    NmbOfFront[q] = i + 2;
                    NextFront.add(new Integer(q));
                }
            }
            ++i;
            Front.add(NextFront);
        }
        Integer RMax = this.IntMax(NmbOfFront);
        return new Object[]{NmbOfFront, RMax};
    }

    public double[] asswght(int[] R, int RMax, int s) {
        int i;
        double[] P = new double[s];
        double sum = 0.0;
        for (i = 0; i < R.length; ++i) {
            sum += (double)R[i];
        }
        for (i = 0; i < s; ++i) {
            P[i] = (double)(RMax - R[i] + 1) / ((double)(RMax + 1) * (double)s - sum);
        }
        return P;
    }

    public Object[] worst(double[][] D, int n, int[] R, int Rmax) {
        Vector<Integer> Ltmp = new Vector<Integer>();
        for (int i = 0; i < R.length; ++i) {
            if (R[i] != Rmax) continue;
            Ltmp.add(new Integer(i));
        }
        int[] L = new int[Ltmp.size()];
        for (int i = 0; i < Ltmp.size(); ++i) {
            L[i] = (Integer)Ltmp.get(i);
        }
        int nA = L.length;
        double[][] A = new double[nA][n];
        for (int i = 0; i < L.length; ++i) {
            for (int j = 0; j < n; ++j) {
                A[i][j] = D[L[i]][j];
            }
        }
        return new Object[]{A, L, new Integer(nA)};
    }

    public Object[] choose(double[] P, double[][] D, double[][] F, int[] Rank, int n) {
        double[] sP = new double[P.length];
        double sum = 0.0;
        int counter = 0;
        int[] Selected = new int[n];
        double[][] S1 = new double[n][D[0].length];
        double[][] F1 = new double[n][F[0].length];
        int[] R1 = new int[n];
        for (int i = 0; i < P.length; ++i) {
            sP[i] = sum += P[i];
        }
        while (counter < n) {
            int j;
            int R = -1;
            boolean multipleOccurrences = false;
            block2: do {
                int i;
                multipleOccurrences = false;
                double U = this.Custom_rand();
                for (i = 0; i < P.length; ++i) {
                    if (!(U < sP[i])) continue;
                    R = i;
                    break;
                }
                for (i = 0; i < counter; ++i) {
                    if (Selected[i] != R) continue;
                    multipleOccurrences = true;
                    continue block2;
                }
            } while (multipleOccurrences);
            Selected[counter] = R;
            for (j = 0; j < D[0].length; ++j) {
                S1[counter][j] = D[R][j];
            }
            for (j = 0; j < F[0].length; ++j) {
                F1[counter][j] = F[R][j];
            }
            R1[counter] = Rank[R];
            ++counter;
        }
        return new Object[]{S1, F1, R1};
    }

    public Object[] mosim(double[][] S, double[][] SF, int[] SR, int n, double[] minn, double[] maxn) {
        int i;
        double[] Fnew;
        double[] Snew;
        int lenS = S[0].length;
        int lenSF = SF[0].length;
        int e = S.length;
        int r = lenS + lenSF + 1;
        double[][] Simplex = new double[S.length][lenS + lenSF + 1];
        for (int i2 = 0; i2 < S.length; ++i2) {
            int j;
            for (j = 0; j < lenS; ++j) {
                Simplex[i2][j] = S[i2][j];
            }
            for (j = 0; j < lenSF; ++j) {
                Simplex[i2][lenS + j] = SF[i2][j];
            }
            Simplex[i2][lenS + lenSF] = SR[i2];
        }
        this.sort(Simplex, r - 1);
        double[] Fw = new double[lenSF];
        for (int i3 = 0; i3 < lenSF; ++i3) {
            Fw[i3] = Simplex[Simplex.length - 1][n + i3];
        }
        double[] Sw = new double[n];
        for (int i4 = 0; i4 < n; ++i4) {
            Sw[i4] = Simplex[Simplex.length - 1][i4];
        }
        double[] Sg = new double[n];
        int i5 = 0;
        while (i5 < n) {
            Sg[i5] = 0.0;
            for (int j = 0; j < Simplex.length - 1; ++j) {
                int n2 = i5;
                Sg[n2] = Sg[n2] + Simplex[j][i5];
            }
            int n3 = i5++;
            Sg[n3] = Sg[n3] / (double)(Simplex.length - 1);
        }
        double[] Sref = new double[n];
        for (int i6 = 0; i6 < n; ++i6) {
            Sref[i6] = 2.0 * Sg[i6] - Sw[i6];
        }
        boolean accept = this.IsSampleValid(Sref);
        if (!accept) {
            double[] Scon = new double[n];
            for (int i7 = 0; i7 < n; ++i7) {
                Scon[i7] = 0.5 * Sg[i7] + 0.5 * Sw[i7];
            }
            accept = this.IsSampleValid(Scon);
            while (!accept) {
                double[][] newpar = this.lhsu(this.lowBound, this.upBound, 1);
                Scon = newpar[0];
                accept = this.IsSampleValid(Scon);
            }
            double[] Fcon = this.compob(Scon);
            Snew = Scon;
            Fnew = Fcon;
        } else {
            double[] Fref = this.compob(Sref);
            double[][] SimplexTmp = new double[Simplex.length][lenSF];
            for (int j = 0; j < lenSF; ++j) {
                for (int i8 = 0; i8 < Simplex.length - 1; ++i8) {
                    SimplexTmp[i8][j] = Simplex[i8][n + j];
                }
                SimplexTmp[Simplex.length - 1][j] = Fref[j];
            }
            Object[] ret = this.parrank(SimplexTmp, 2);
            int[] Rref = (int[])ret[0];
            int Rrefmax = Integer.MIN_VALUE;
            for (int i9 = 0; i9 < Rref.length - 1; ++i9) {
                if (Rref[i9] <= Rrefmax) continue;
                Rrefmax = Rref[i9];
            }
            if (Rref[Rref.length - 1] <= Rrefmax) {
                Snew = Sref;
                Fnew = Fref;
            } else {
                double[] Scon = new double[n];
                for (int i10 = 0; i10 < n; ++i10) {
                    Scon[i10] = 0.5 * Sg[i10] + 0.5 * Sw[i10];
                }
                accept = this.IsSampleValid(Scon);
                while (!accept) {
                    double[][] newpar = this.lhsu(this.lowBound, this.upBound, 1);
                    Scon = newpar[0];
                    accept = this.IsSampleValid(Scon);
                }
                double[] Fcon = this.compob(Scon);
                Snew = Scon;
                Fnew = Fcon;
            }
        }
        for (i = 0; i < n; ++i) {
            S[S.length - 1][i] = Snew[i];
        }
        for (i = 0; i < SF[0].length; ++i) {
            SF[SF.length - 1][i] = Fnew[i];
        }
        return new Object[]{S, SF};
    }

    public Object[] update(double[][] D, int[] L, double[][] A, int n, int nA, double[][] F, double[][] FA) {
        for (int i = 0; i < nA; ++i) {
            int j;
            for (j = 0; j < n; ++j) {
                D[L[i]][j] = A[i][j];
            }
            for (j = 0; j < FA[0].length; ++j) {
                F[L[i]][j] = FA[i][j];
            }
        }
        return new Object[]{D, F};
    }

    public Object[] mocom(int n, int s, double[] minn, double[] maxn, int m, int MaxIter) {
        double[][] D = this.lhsu(minn, maxn, s);
        double[][] F = this.compf(D, m);
        int nobj = F[0].length;
        Object[] ret = this.parrank(F, nobj);
        int[] R = (int[])ret[0];
        int Rmax = (Integer)ret[1];
        int loopcounter = 1;
        while (Rmax > 1) {
            int i;
            int c;
            double[] P = this.asswght(R, Rmax, s);
            ret = this.worst(D, n, R, Rmax);
            double[][] A = (double[][])ret[0];
            int[] L = (int[])ret[1];
            int nA = (Integer)ret[2];
            ret = this.choose(P, D, F, R, n);
            double[][] S1 = (double[][])ret[0];
            double[][] F1 = (double[][])ret[1];
            int[] R1 = (int[])ret[2];
            double[][] FA = new double[nA][F[0].length];
            for (int j = 0; j < nA; ++j) {
                int c1;
                int c12;
                if (S1.length != F1.length || F1.length != R1.length) {
                    this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": interner Fehler");
                }
                double[][] S = new double[S1.length + 1][S1[0].length];
                double[][] SF = new double[F1.length + 1][F1[0].length];
                int[] SR = new int[R1.length + 1];
                for (c12 = 0; c12 < S1.length; ++c12) {
                    int c2;
                    for (c2 = 0; c2 < S1[0].length; ++c2) {
                        S[c12][c2] = S1[c12][c2];
                    }
                    for (c2 = 0; c2 < F1[0].length; ++c2) {
                        SF[c12][c2] = F1[c12][c2];
                    }
                    SR[c12] = R1[c12];
                }
                for (c12 = 0; c12 < S1[0].length; ++c12) {
                    S[S1.length][c12] = A[j][c12];
                }
                for (c12 = 0; c12 < F1[0].length; ++c12) {
                    SF[F1.length][c12] = F[L[j]][c12];
                }
                SR[R1.length] = R[L[j]];
                Object[] res = this.mosim(S, SF, SR, n, minn, maxn);
                S = (double[][])res[0];
                SF = (double[][])res[1];
                for (c1 = 0; c1 < n; ++c1) {
                    A[j][c1] = S[S.length - 1][c1];
                }
                for (c1 = 0; c1 < FA[j].length; ++c1) {
                    FA[j][c1] = SF[SF.length - 1][c1];
                }
            }
            ret = this.update(D, L, A, n, nA, F, FA);
            D = (double[][])ret[0];
            F = (double[][])ret[1];
            ret = this.parrank(F, nobj);
            R = (int[])ret[0];
            Rmax = (Integer)ret[1];
            double[][] currentResult = new double[s][this.N + this.M + 1];
            for (int i2 = 0; i2 < s; ++i2) {
                int j;
                for (j = 0; j < this.N; ++j) {
                    currentResult[i2][j] = D[i2][j];
                }
                for (j = 0; j < this.M; ++j) {
                    currentResult[i2][this.N + j] = F[i2][j];
                }
                currentResult[i2][this.N + this.M] = R[i2];
            }
            this.sort(currentResult, this.N + this.M);
            if (this.continousOutput) {
                for (c = 0; c < s && loopcounter % 10 == 0; ++c) {
                    int i3;
                    this.writer.write("" + currentResult[c][this.N + this.M] + "\t");
                    for (i3 = 0; i3 < this.N; ++i3) {
                        this.writer.write("" + currentResult[c][i3] + "\t");
                    }
                    for (i3 = 0; i3 < this.M; ++i3) {
                        this.writer.write("" + currentResult[c][this.N + i3] + "\t");
                    }
                    this.writer.writeLine("");
                    this.writer.flush();
                }
            }
            if (MaxIter < ++loopcounter) {
                int i4;
                System.out.println("********************************************");
                System.out.println("---------->OPTIMIZATION STOP<---------------");
                System.out.println("--->MAXIMUM NUMBER OF LOOPS HAS REACHED<----");
                System.out.println("********************************************");
                c = 0;
                System.out.print("Rank\t");
                for (i4 = 0; i4 < this.N; ++i4) {
                    System.out.print(this.parameterNames[i4] + "\t");
                }
                for (i4 = 0; i4 < this.M; ++i4) {
                    System.out.print(this.effNames[i4] + "\t");
                }
                System.out.println("");
                while (c < s) {
                    System.out.print("" + currentResult[c][this.N + this.M] + "\t");
                    for (i4 = 0; i4 < this.N; ++i4) {
                        System.out.print("" + currentResult[c][i4] + "\t");
                    }
                    for (i4 = 0; i4 < this.M; ++i4) {
                        System.out.print("" + currentResult[c][this.N + i4] + "\t");
                    }
                    System.out.println("");
                    ++c;
                }
                c = 0;
                this.writer.writeLine("Number of model runs: " + this.icall);
                this.writer.write("Rank\t");
                for (i4 = 0; i4 < this.N; ++i4) {
                    this.writer.write(this.parameterNames[i4] + "\t");
                }
                for (i4 = 0; i4 < this.M; ++i4) {
                    this.writer.write(this.effNames[i4] + "\t");
                }
                this.writer.write("\n");
                while (c < s) {
                    this.writer.write("" + currentResult[c][this.N + this.M] + "\t");
                    for (i4 = 0; i4 < this.N; ++i4) {
                        this.writer.write("" + currentResult[c][i4] + "\t");
                    }
                    for (i4 = 0; i4 < this.M; ++i4) {
                        this.writer.write("" + currentResult[c][this.N + i4] + "\t");
                    }
                    ++c;
                    this.writer.writeLine("");
                    this.writer.flush();
                }
                this.writer.flush();
                break;
            }
            if (Rmax > 1) continue;
            System.out.println("********************************************");
            System.out.println("---------->OPTIMIZATION STOP<---------------");
            System.out.println("-------------->SUCCESSFUL<------------------");
            System.out.println("********************************************");
            c = 0;
            System.out.print("Rank\t");
            for (i = 0; i < this.N; ++i) {
                System.out.print(this.parameterNames[i] + "\t");
            }
            for (i = 0; i < this.M; ++i) {
                System.out.print(this.effNames[i] + "\t");
            }
            System.out.println("");
            while (c < s) {
                System.out.print("" + currentResult[c][this.N + this.M] + "\t");
                for (i = 0; i < this.N; ++i) {
                    System.out.print("" + currentResult[c][i] + "\t");
                }
                for (i = 0; i < this.M; ++i) {
                    System.out.print("" + currentResult[c][this.N + i] + "\t");
                }
                System.out.println("");
                ++c;
            }
            c = 0;
            this.writer.writeLine("Number of model runs: " + this.icall);
            this.writer.write("Rank\t");
            for (i = 0; i < this.N; ++i) {
                this.writer.write(this.parameterNames[i] + "\t");
            }
            for (i = 0; i < this.M; ++i) {
                this.writer.write(this.effNames[i] + "\t");
            }
            this.writer.write("\n");
            while (c < s) {
                this.writer.write("" + currentResult[c][this.N + this.M] + "\t");
                for (i = 0; i < this.N; ++i) {
                    this.writer.write("" + currentResult[c][i] + "\t");
                }
                for (i = 0; i < this.M; ++i) {
                    this.writer.write("" + currentResult[c][this.N + i] + "\t");
                }
                ++c;
                this.writer.write("\n");
                this.writer.flush();
            }
            this.writer.flush();
        }
        return new Object[]{D, F, R, new Integer(Rmax)};
    }

    public void run() {
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        if (!this.enable.getValue()) {
            this.disabledRun();
            return;
        }
        if (this.maxIter == null) {
            this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": maxIter unknown. please set maxIter");
        }
        if (this.populationSize == null) {
            this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": populationsize unknown. please set populationsize");
        }
        int maxn = this.maxIter.getValue();
        this.s = this.populationSize.getValue();
        if (this.s <= 0) {
            this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": populationsize ist zero");
        }
        if (maxn <= 0) {
            this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": invalid maxIter");
        }
        Object[] ret = this.mocom(this.N, this.s, this.lowBound, this.upBound, this.m, maxn);
        System.out.println("Mocom has finished");
    }

    public void cleanup() {
        if (this.enable.getValue()) {
            this.end = System.currentTimeMillis();
            long duration = this.end - this.start;
            this.writer.writeLine("duration: " + duration / 1000L + " sec");
            this.writer.flush();
            this.writer.close();
        }
    }
}

