/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

@JAMSComponentDescription(title="Entity file writer (temporal)", author="S. Kralisch", description="This component can be used to output one selected entity attribute value for every time step. The resulting CSV formatted ASCII file will contain one line per time step and one column per entity. This component must be wrapped in a temporal, but not in a spatial context!")
public class TemporalEntityWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="EntitySet")
    public JAMSEntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file name")
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file attribute names")
    public JAMSString idAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file attribute names")
    public JAMSString dataAttributeName;
    private GenericDataWriter writer;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        this.writer = new GenericDataWriter(this.dirName.getValue() + "/" + this.fileName.getValue());
        this.writer.addComment("JAMS entity output from TemporalEntityWriter");
        this.writer.addComment("Attribute name: " + this.dataAttributeName);
        this.writer.addComment("");
        this.writer.addColumn("date/time");
        for (JAMSEntity e : this.entities.getEntityArray()) {
            this.writer.addColumn("HRU_" + (int)e.getDouble(this.idAttributeName.getValue()));
        }
        this.writer.writeHeader();
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        this.writer.addData((Object)this.time);
        for (JAMSEntity e : this.entities.getEntityArray()) {
            this.writer.addData((Object)e.getObject(this.dataAttributeName.getValue()).toString());
        }
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Exception)((Object)jre));
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

