/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui.spreadsheet;

import jams.components.gui.spreadsheet.CTSPlot;
import jams.components.gui.spreadsheet.GraphProperties;
import jams.components.gui.spreadsheet.JAMSTimePlot;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class JTSConfigurator
extends JFrame {
    GroupLayout gLayout;
    GroupLayout.SequentialGroup hGroup;
    GroupLayout.SequentialGroup vGroup;
    GroupLayout.Group group1;
    GroupLayout.Group group2;
    GroupLayout.Group group3;
    GroupLayout.Group group4;
    GroupLayout.Group group5;
    GroupLayout.Group group6;
    GroupLayout.Group group7;
    GroupLayout.Group group8;
    GroupLayout.Group group9;
    GroupLayout.Group group10;
    GroupLayout.Group group11;
    GroupLayout.Group group12;
    GroupLayout.Group group13;
    GroupLayout.Group group14;
    GroupLayout.Group group15;
    private Vector<ActionListener> addAction = new Vector();
    private JDialog parent;
    private JPanel frame;
    private JPanel mainpanel;
    private JPanel plotpanel;
    private JPanel optionpanel;
    private JPanel graphpanel;
    private JPanel southpanel;
    private JPanel edTitlePanel;
    private JPanel edLeftAxisPanel;
    private JPanel edRightAxisPanel;
    private JPanel edTimeAxisPanel;
    private JSplitPane split_hor = new JSplitPane(1);
    private JSplitPane split_vert = new JSplitPane(0);
    private JPanel[] datapanels;
    private JScrollPane graphScPane;
    private JScrollPane plotScPane;
    private JScrollPane mainScPane;
    private JScrollPane optScPane;
    private String[] headers;
    private JLabel edTitle = new JLabel("Plot Title: ");
    private JLabel edLeft = new JLabel("Left axis title: ");
    private JLabel edXAxis = new JLabel("X axis title");
    private JLabel edRight = new JLabel("Right axis title: ");
    private JLabel rLeftLabel = new JLabel("Renderer left");
    private JLabel rRightLabel = new JLabel("Renderer right");
    private JLabel invLeftLabel = new JLabel("Invert left axis");
    private JLabel invRightLabel = new JLabel("Invert right axis");
    private JTextField edTitleField = new JTextField(14);
    private JTextField edLeftField = new JTextField(14);
    private JTextField edRightField = new JTextField(14);
    private JTextField edXAxisField = new JTextField(14);
    private String[] types = new String[]{"Line", "Bar", "Area", "Line and Base", "Dot", "Difference", "Step", "StepArea"};
    private JComboBox rLeftBox = new JComboBox<String>(this.types);
    private JComboBox rRightBox = new JComboBox<String>(this.types);
    private JCheckBox invLeftBox = new JCheckBox("Invert left Axis");
    private JCheckBox invRightBox = new JCheckBox("Invert right Axis");
    private JButton applyButton = new JButton("Apply");
    private Vector<GraphProperties> propVector = new Vector();
    private JAMSTimePlot jts = new JAMSTimePlot();
    private int index;
    HashMap<String, Color> colorTable = new HashMap();
    int[] rows;
    int[] columns;
    JTable table;
    CTSPlot ctsplot;
    int graphCount = 0;
    JCheckBox[] activate;
    JComboBox[] datachoice;
    JComboBox[] poschoice;
    JComboBox[] typechoice;
    JComboBox[] colorchoice;
    ActionListener[] activationChange;
    ActionListener titleListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            JTSConfigurator.this.ctsplot.getChart().setTitle(JTSConfigurator.this.edTitleField.getText());
        }
    };
    ActionListener propbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JTSConfigurator.this.ctsplot.getChartPanel().doEditChartProperties();
        }
    };
    ActionListener addbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    ActionListener plotbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JTSConfigurator.this.updatePropVector();
            JTSConfigurator.this.jts.plotLeft(JTSConfigurator.this.rLeftBox.getSelectedIndex(), JTSConfigurator.this.edLeftField.getText(), JTSConfigurator.this.edXAxisField.getText(), JTSConfigurator.this.invLeftBox.isSelected());
            JTSConfigurator.this.jts.plotRight(JTSConfigurator.this.rRightBox.getSelectedIndex(), JTSConfigurator.this.edRightField.getText(), JTSConfigurator.this.edXAxisField.getText(), JTSConfigurator.this.invRightBox.isSelected());
            JTSConfigurator.this.jts.setTitle(JTSConfigurator.this.edTitleField.getText());
        }
    };
    ActionListener actChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };

    public JTSConfigurator() {
    }

    public JTSConfigurator(JFrame parent, JTable table) {
        this.setTitle("JAMS JTS Viewer");
        URL url = this.getClass().getResource("/jams/components/gui/resources/JAMSicon16.png");
        ImageIcon icon = new ImageIcon(url);
        this.setIconImage(icon.getImage());
        this.setLayout(new FlowLayout());
        Point parentloc = parent.getLocation();
        this.setLocation(parentloc.x + 30, parentloc.y + 30);
        this.table = table;
        this.rows = table.getSelectedRows();
        this.columns = table.getSelectedColumns();
        this.graphCount = this.columns.length;
        this.headers = new String[this.graphCount];
        this.setSize(680, 480);
        this.createPanel();
        this.pack();
        this.setVisible(true);
    }

    public void createPanel() {
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        JLabel nameLabel = new JLabel("Name");
        JLabel posLabel = new JLabel("Position");
        JLabel typeLabel = new JLabel("Renderer");
        JLabel colorLabel = new JLabel("Colour");
        JLabel dataLabel = new JLabel("Select Data / Legend Entry");
        JLabel timeLabel = new JLabel("Time Interval");
        JLabel emptyTimeLabel = new JLabel("    ");
        JLabel legendLabel = new JLabel("Legend Entry");
        nameLabel.setBackground(Color.DARK_GRAY);
        posLabel.setBackground(Color.DARK_GRAY);
        typeLabel.setBackground(Color.DARK_GRAY);
        colorLabel.setBackground(Color.DARK_GRAY);
        dataLabel.setBackground(Color.DARK_GRAY);
        timeLabel.setBackground(Color.DARK_GRAY);
        this.setLayout(new BorderLayout());
        this.plotpanel = new JPanel();
        this.plotpanel.setLayout(new BorderLayout());
        this.frame = new JPanel();
        this.frame.setLayout(new BorderLayout());
        this.graphScPane = new JScrollPane();
        this.optionpanel = new JPanel();
        this.graphpanel = new JPanel();
        this.initGroupUI();
        this.southpanel = new JPanel();
        this.southpanel.setLayout(new FlowLayout());
        this.edTitlePanel = new JPanel();
        this.edTitlePanel.setLayout(new FlowLayout());
        this.edLeftAxisPanel = new JPanel();
        this.edLeftAxisPanel.setLayout(new FlowLayout());
        this.edRightAxisPanel = new JPanel();
        this.edRightAxisPanel.setLayout(new FlowLayout());
        this.edTitleField.setText("Plot Title");
        this.edTitleField.setSize(40, 10);
        this.edTitleField.addActionListener(this.plotbuttonclick);
        this.edLeftField.setText("Left Axis Title");
        this.edLeftField.addActionListener(this.plotbuttonclick);
        this.edLeftField.setSize(40, 10);
        this.edRightField.setText("Right Axis Title");
        this.edRightField.addActionListener(this.plotbuttonclick);
        this.edRightField.setSize(40, 10);
        this.edXAxisField.setText("Time");
        this.edXAxisField.addActionListener(this.plotbuttonclick);
        this.applyButton.addActionListener(this.plotbuttonclick);
        this.optionpanel.add(this.edTitle);
        this.optionpanel.add(this.edTitleField);
        this.optionpanel.add(this.edLeft);
        this.optionpanel.add(this.edLeftField);
        this.optionpanel.add(this.edRight);
        this.optionpanel.add(this.edRightField);
        this.optionpanel.add(this.applyButton);
        for (int k = 0; k < this.graphCount; ++k) {
            GraphProperties prop = new GraphProperties(this.parent, this.table, this);
            prop.setIndex(k);
            prop.setSelectedColumn(this.columns[k]);
            prop.setSelectedRows(this.rows);
            prop.setTimeSTART(this.rows[0]);
            prop.setTimeEND(this.rows[this.rows.length - 1]);
            if (k <= 12) {
                prop.setColor(k);
            }
            prop.setName(this.table.getColumnName(k + 1));
            prop.setLegendName(this.table.getColumnName(k + 1));
            prop.applyProperties();
            this.addPropGroup(prop);
            this.propVector.add(k, prop);
        }
        this.finishGroupUI();
        this.createOptionPanel();
        this.jts.setPropVector(this.propVector);
        this.jts.createPlot();
        JPanel graphPanel = new JPanel();
        JPanel optPanel = new JPanel();
        graphPanel.add(this.graphpanel);
        optPanel.add(this.optionpanel);
        this.graphScPane = new JScrollPane(graphPanel);
        this.graphScPane.setVerticalScrollBarPolicy(22);
        this.optionpanel.setBorder(new EtchedBorder());
        this.plotScPane = new JScrollPane(this.jts.getPanel());
        this.optScPane = new JScrollPane(optPanel);
        this.split_hor.add((Component)this.optScPane, 0);
        this.split_hor.add((Component)this.graphScPane, 1);
        this.split_vert.add((Component)this.split_hor, 0);
        this.split_vert.add((Component)this.plotScPane, 1);
        this.add(this.split_vert);
        this.jts.plotLeft(0, "leftAxisName", "Time", false);
    }

    public void addGraph(int index) {
        int i = index;
        GraphProperties prop = new GraphProperties(this.parent, this.table, this);
        if (i > 0) {
            int t_s = this.propVector.get(i - 1).getTimeChoiceSTART().getSelectedIndex();
            int t_e = this.propVector.get(i - 1).getTimeChoiceEND().getSelectedIndex();
            prop.getTimeChoiceSTART().setSelectedIndex(t_s);
            prop.getTimeChoiceEND().setSelectedIndex(t_e);
        }
        this.propVector.add(i, prop);
        this.graphCount = this.propVector.size();
        this.initGroupUI();
        for (int k = 0; k < this.graphCount; ++k) {
            prop = this.propVector.get(k);
            prop.setIndex(k);
            this.addPropGroup(prop);
        }
        this.finishGroupUI();
        this.repaint();
    }

    public void removeGraph(int index) {
        if (this.graphCount > 1) {
            this.propVector.remove(index);
            this.graphCount = this.propVector.size();
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                GraphProperties prop = this.propVector.get(k);
                prop.setIndex(k);
                this.addPropGroup(prop);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void upGraph(int index) {
        int i = index;
        GraphProperties prop = this.propVector.get(i);
        if (i - 1 >= 0 && i - 1 < this.graphCount) {
            this.propVector.remove(i);
            this.propVector.add(i - 1, prop);
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                prop = this.propVector.get(k);
                prop.setIndex(k);
                this.addPropGroup(prop);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void downGraph(int index) {
        int i = index;
        GraphProperties prop = this.propVector.get(i + 1);
        if (i + 1 >= 0 && i + 1 < this.graphCount) {
            this.propVector.remove(i + 1);
            this.propVector.add(i, prop);
            this.graphCount = this.propVector.size();
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                prop = this.propVector.get(k);
                prop.setIndex(k);
                this.addPropGroup(prop);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    private void updatePropVector() {
        for (int i = 0; i < this.propVector.size(); ++i) {
            this.propVector.get(i).applyProperties();
        }
    }

    public void plotGraph(int i) {
        if (this.propVector.get(i).getPosChoice().getSelectedItem() == "left") {
            this.jts.plotLeft(this.rLeftBox.getSelectedIndex(), this.edLeftField.getText(), this.edXAxisField.getText(), this.invLeftBox.isSelected());
        }
        if (this.propVector.get(i).getPosChoice().getSelectedItem() == "right") {
            this.jts.plotRight(this.rRightBox.getSelectedIndex(), this.edRightField.getText(), this.edXAxisField.getText(), this.invRightBox.isSelected());
        }
    }

    private void createOptionPanel() {
        GroupLayout optLayout = new GroupLayout(this.optionpanel);
        this.optionpanel.setLayout(optLayout);
        optLayout.setAutoCreateGaps(true);
        optLayout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup optHGroup = optLayout.createSequentialGroup();
        GroupLayout.SequentialGroup optVGroup = optLayout.createSequentialGroup();
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitle).addComponent(this.edTitleField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edLeft).addComponent(this.edLeftField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edRight).addComponent(this.edRightField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edXAxis).addComponent(this.edXAxisField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.rLeftLabel).addComponent(this.rLeftBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.rRightLabel).addComponent(this.rRightBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.invLeftBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.invRightBox).addComponent(this.applyButton));
        optHGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitle).addComponent(this.edLeft).addComponent(this.edRight).addComponent(this.edXAxis).addComponent(this.rLeftLabel).addComponent(this.rRightLabel).addComponent(this.invLeftBox).addComponent(this.invRightBox));
        optHGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitleField).addComponent(this.edLeftField).addComponent(this.edRightField).addComponent(this.edXAxisField).addComponent(this.rLeftBox).addComponent(this.rRightBox).addGap(1, 1, 1).addComponent(this.applyButton));
        optLayout.setHorizontalGroup(optHGroup);
        optLayout.setVerticalGroup(optVGroup);
    }

    private void initGroupUI() {
        this.graphpanel.removeAll();
        JLabel nameLabel = new JLabel("Name");
        JLabel posLabel = new JLabel("Position");
        JLabel typeLabel = new JLabel("Colour / Position");
        JLabel colorLabel = new JLabel("Type/Colour");
        JLabel dataLabel = new JLabel("Data / Legend Entry");
        JLabel timeLabel = new JLabel("Time Interval");
        JLabel emptyTimeLabel = new JLabel("    ");
        JLabel legendLabel = new JLabel("Legend Entry: ");
        this.gLayout = new GroupLayout(this.graphpanel);
        this.graphpanel.setLayout(this.gLayout);
        this.gLayout.setAutoCreateGaps(true);
        this.gLayout.setAutoCreateContainerGaps(true);
        this.hGroup = this.gLayout.createSequentialGroup();
        this.vGroup = this.gLayout.createSequentialGroup();
        this.group1 = this.gLayout.createParallelGroup();
        this.group2 = this.gLayout.createParallelGroup();
        this.group3 = this.gLayout.createParallelGroup();
        this.group4 = this.gLayout.createParallelGroup();
        this.group5 = this.gLayout.createParallelGroup();
        this.group6 = this.gLayout.createParallelGroup();
        this.group7 = this.gLayout.createParallelGroup();
        this.group8 = this.gLayout.createParallelGroup();
        this.group9 = this.gLayout.createParallelGroup();
        this.group10 = this.gLayout.createParallelGroup();
        this.group11 = this.gLayout.createParallelGroup();
        this.group12 = this.gLayout.createParallelGroup();
        this.group13 = this.gLayout.createParallelGroup();
        this.group14 = this.gLayout.createParallelGroup();
        this.group15 = this.gLayout.createParallelGroup();
        this.group1.addComponent(dataLabel);
        this.group2.addComponent(timeLabel);
        this.group3.addComponent(typeLabel);
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(dataLabel).addComponent(timeLabel).addComponent(typeLabel));
    }

    private void addPropGroup(GraphProperties prop) {
        JLabel space1 = new JLabel(" ");
        JLabel space2 = new JLabel(" ");
        JLabel space3 = new JLabel(" ");
        JLabel space4 = new JLabel(" ");
        JLabel space5 = new JLabel("   ");
        JLabel space6 = new JLabel("   ");
        JTextField lf = prop.getLegendField();
        this.group6.addComponent(space5).addComponent(space6);
        this.group1.addComponent(prop.getDataChoice()).addComponent(lf).addGap(20);
        this.group2.addComponent(prop.getTimeChoiceSTART()).addComponent(prop.getTimeChoiceEND());
        this.group3.addComponent(prop.getColorChoice()).addComponent(prop.getPosChoice());
        this.group9.addComponent(space3);
        this.group10.addComponent(prop.getPlotButton());
        this.group11.addComponent(space4);
        this.group12.addComponent(prop.getAddButton());
        this.group13.addComponent(prop.getRemButton());
        this.group14.addComponent(prop.getUpButton());
        this.group15.addComponent(prop.getDownButton());
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(prop.getDataChoice()).addComponent(prop.getTimeChoiceSTART()).addComponent(space5).addComponent(prop.getColorChoice()));
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lf).addComponent(prop.getTimeChoiceEND()).addComponent(space6).addComponent(prop.getPosChoice()).addComponent(space3).addComponent(prop.getPlotButton()).addComponent(space4).addComponent(prop.getAddButton()).addComponent(prop.getRemButton()).addComponent(prop.getUpButton()).addComponent(prop.getDownButton()));
        this.vGroup.addGroup(this.gLayout.createParallelGroup().addGap(20));
    }

    private void finishGroupUI() {
        this.hGroup.addGroup(this.group1);
        this.hGroup.addGroup(this.group2);
        this.hGroup.addGroup(this.group6);
        this.hGroup.addGroup(this.group3);
        this.hGroup.addGroup(this.group9);
        this.hGroup.addGroup(this.group10);
        this.hGroup.addGroup(this.group11);
        this.hGroup.addGroup(this.group12);
        this.hGroup.addGroup(this.group13);
        this.hGroup.addGroup(this.group14);
        this.hGroup.addGroup(this.group15);
        this.gLayout.setHorizontalGroup(this.hGroup);
        this.gLayout.setVerticalGroup(this.vGroup);
    }

    public JPanel getPanel() {
        return this.mainpanel;
    }

    public JPanel getCTSPlot() {
        return this.ctsplot.getPanel();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setParent(JDialog parent) {
        this.parent = parent;
    }

    private void editProperties() {
        JDialog propDlg = new JDialog((Dialog)this.parent, "Properties");
        int ct = this.headers.length;
        JLabel[] labels = new JLabel[ct];
        JTextField[] textFields = new JTextField[ct];
        JPanel[] inputpanels = new JPanel[ct];
        JPanel proppanel = new JPanel();
        proppanel.setLayout(new GridLayout(ct, 1));
        for (int i = 0; i < ct; ++i) {
            labels[i] = new JLabel(this.headers[i]);
            textFields[i] = new JTextField(this.headers[i]);
            inputpanels[i] = new JPanel();
            inputpanels[i].setLayout(new FlowLayout());
            inputpanels[i].add(labels[i]);
            inputpanels[i].add(textFields[i]);
        }
        JScrollPane propPane = new JScrollPane(proppanel);
    }

    public void createActionListener() {
        Vector addAction = new Vector();
        for (int k = 0; k < this.graphCount; ++k) {
            this.activationChange[k] = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
        }
    }
}

