/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSStringArray;
import org.unijena.jams.model.JAMSGUIComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class TSPlot
extends JAMSGUIComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Title string for plot")
    public JAMSString plotTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Title strings for left graphs")
    public JAMSStringArray titleLeft;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Variable title strings for left graphs")
    public JAMSStringArray varTitleLeft;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Title strings for right graphs")
    public JAMSStringArray titleRight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Colors for left graphs (yellow, orange, red, pink, magenta, cyan, yellow, green, lightgray, gray, black)")
    public JAMSStringArray colorLeft;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Colors for right graphs (yellow, orange, red, pink, magenta, cyan, yellow, green, lightgray, gray, black)")
    public JAMSStringArray colorRight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Graph type for left y axis graphs")
    public JAMSInteger typeLeft;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Graph type for right y axis graphs")
    public JAMSInteger typeRight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Title string for x axis")
    public JAMSString xAxisTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Title string for left y axis")
    public JAMSString leftAxisTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Title string for right y axis")
    public JAMSString rightAxisTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Paint inverted right y axis?")
    public JAMSBoolean rightAxisInverted;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Date format")
    public JAMSString dateFormat;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Current time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Values to be plotted on left x-axis")
    public JAMSDouble[] valueLeft;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Values to be plotted on right x-axis")
    public JAMSDouble[] valueRight;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Value for \"No data\" (shouldn't be plotted)", defaultValue="-9999")
    public JAMSDouble noDataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Plot data after cacheSize values have been collected", defaultValue="10")
    public JAMSInteger cacheSize;
    TimeSeries[] tsLeft;
    TimeSeries[] tsRight;
    TimeSeriesCollection dataset1;
    TimeSeriesCollection dataset2;
    XYItemRenderer rightRenderer;
    XYItemRenderer leftRenderer;
    XYPlot plot;
    JFreeChart chart;
    JButton saveButton;
    int i;
    int graphCountLeft = 0;
    int graphCountRight = 0;
    HashMap<String, Color> colorTable = new HashMap();
    double noDataValue_;
    int cacheSize_;
    long[] timeStamps;
    double[] dataValuesLeft;
    double[] dataValuesRight;
    int count;

    public TSPlot() {
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
    }

    public JPanel getPanel() {
        this.dataset1 = new TimeSeriesCollection();
        this.dataset2 = new TimeSeriesCollection();
        this.chart = ChartFactory.createTimeSeriesChart((String)this.getInstanceName(), (String)this.xAxisTitle.getValue(), (String)this.leftAxisTitle.getValue(), (XYDataset)this.dataset1, (boolean)true, (boolean)true, (boolean)false);
        ChartPanel chartPanel = new ChartPanel(this.chart, true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)chartPanel, "Center");
        return panel;
    }

    private XYItemRenderer getRenderer(int type) {
        XYBarRenderer r;
        switch (type) {
            case 0: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(false);
                r = lsr;
                break;
            }
            case 1: {
                r = new XYBarRenderer();
                break;
            }
            case 2: {
                r = new XYAreaRenderer();
                break;
            }
            case 3: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(true);
                r = lsr;
                break;
            }
            case 4: {
                XYDotRenderer dotR = new XYDotRenderer();
                dotR.setDefaultEntityRadius(2);
                r = dotR;
                break;
            }
            case 5: {
                r = new XYDifferenceRenderer();
                break;
            }
            case 6: {
                r = new XYStepRenderer();
                break;
            }
            case 7: {
                r = new XYStepAreaRenderer();
                break;
            }
            default: {
                XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
                lsr.setBaseShapesVisible(false);
                r = lsr;
            }
        }
        return r;
    }

    public void init() {
        this.noDataValue_ = this.noDataValue.getValue();
        if (this.chart != null) {
            this.plot = this.chart.getXYPlot();
            DateAxis dateAxis = (DateAxis)this.plot.getDomainAxis();
            dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(this.dateFormat.getValue()));
            this.leftRenderer = this.getRenderer(this.typeLeft.getValue());
            this.plot.setRenderer(0, this.leftRenderer);
            this.graphCountLeft = this.valueLeft.length;
            this.tsLeft = new TimeSeries[this.graphCountLeft];
            this.i = 0;
            while (this.i < this.graphCountLeft) {
                String legendEntry = this.titleLeft.getValue()[this.i];
                if (this.varTitleLeft != null) {
                    legendEntry = legendEntry + this.getModel().getRuntime().getDataHandles().get(this.varTitleLeft.getValue()[this.i]);
                }
                this.leftRenderer.setSeriesPaint(this.i, (Paint)this.colorTable.get(this.colorLeft.getValue()[this.i]));
                this.tsLeft[this.i] = new TimeSeries(legendEntry, Second.class);
                this.dataset1.addSeries(this.tsLeft[this.i]);
                ++this.i;
            }
            if (this.valueRight != null) {
                NumberAxis axis2 = new NumberAxis(this.rightAxisTitle.getValue());
                axis2.setInverted(this.rightAxisInverted.getValue());
                this.plot.setRangeAxis(1, (ValueAxis)axis2);
                this.plot.setDataset(1, (XYDataset)this.dataset2);
                this.plot.mapDatasetToRangeAxis(1, 1);
                this.rightRenderer = this.getRenderer(this.typeRight.getValue());
                this.plot.setRenderer(1, this.rightRenderer);
                this.plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
                this.graphCountRight = this.valueRight.length;
                this.tsRight = new TimeSeries[this.graphCountRight];
                this.i = 0;
                while (this.i < this.graphCountRight) {
                    this.rightRenderer.setSeriesPaint(this.i, (Paint)this.colorTable.get(this.colorRight.getValue()[this.i]));
                    this.tsRight[this.i] = new TimeSeries(this.titleRight.getValue()[this.i], Second.class);
                    this.dataset2.addSeries(this.tsRight[this.i]);
                    ++this.i;
                }
            }
        }
        this.cacheSize_ = this.cacheSize.getValue();
        this.timeStamps = new long[this.cacheSize_];
        this.dataValuesRight = new double[this.cacheSize_ * this.graphCountRight];
        this.dataValuesLeft = new double[this.cacheSize_ * this.graphCountLeft];
        this.count = 0;
    }

    public void run() {
        double value;
        this.timeStamps[this.count] = this.time.getTimeInMillis();
        int offsetRight = this.count * this.graphCountRight;
        int offsetLeft = this.count * this.graphCountLeft;
        this.i = 0;
        while (this.i < this.graphCountRight) {
            value = this.valueRight[this.i].getValue();
            if (value == this.noDataValue_) {
                value = 0.0;
            }
            this.dataValuesRight[offsetRight + this.i] = value;
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.graphCountLeft) {
            value = this.valueLeft[this.i].getValue();
            if (value == this.noDataValue_) {
                value = 0.0;
            }
            this.dataValuesLeft[offsetLeft + this.i] = value;
            ++this.i;
        }
        if (this.count == this.cacheSize_ - 1) {
            this.plotData();
            this.count = 0;
        } else {
            ++this.count;
        }
    }

    private void plotData() {
        try {
            for (int i = 0; i <= this.count; ++i) {
                int j;
                Second second = new Second(new Date(this.timeStamps[i]));
                for (j = 0; j < this.graphCountRight; ++j) {
                    this.tsRight[j].add((RegularTimePeriod)second, this.dataValuesRight[i * this.graphCountRight + j]);
                }
                for (j = 0; j < this.graphCountLeft; ++j) {
                    this.tsLeft[j].add((RegularTimePeriod)second, this.dataValuesLeft[i * this.graphCountLeft + j]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run_() {
        try {
            double value;
            this.i = 0;
            while (this.i < this.graphCountRight) {
                value = this.valueRight[this.i].getValue();
                if (value == this.noDataValue_) {
                    value = 0.0;
                }
                this.tsRight[this.i].add((RegularTimePeriod)new Second(new Date(this.time.getTimeInMillis())), value);
                ++this.i;
            }
            this.i = 0;
            while (this.i < this.graphCountLeft) {
                value = this.valueLeft[this.i].getValue();
                if (value == this.noDataValue_) {
                    value = 0.0;
                }
                this.tsLeft[this.i].add((RegularTimePeriod)new Second(new Date(this.time.getTimeInMillis())), value);
                ++this.i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cleanup() {
        this.plotData();
    }
}

