/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.vividsolutions.jts.geom.Envelope;
import jams.components.gui.JAMSAscGridReader;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.HashMap;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.renderer.lite.StreamingRenderer;

public class Styled3DMapPane
extends Applet {
    TransformGroup objRotate = null;
    TransformGroup objScale = null;
    BufferedImage img = null;
    BranchGroup scene = null;
    SimpleUniverse simpleU = null;
    AffineTransform affineTransform = null;
    Rectangle bound = null;
    Envelope envelope = null;
    Canvas3D canvas3D = null;
    JAMSAscGridReader agr = null;
    MyOrbitBehavior orbit = null;
    public double textureHeight = 256.0;
    public double textureWidth = 256.0;
    public int xRes = 256;
    public int yRes = 256;
    public float scale = 1.2f;
    public float height = 0.5f;
    public float hScale = 1.0f;
    public boolean light = true;

    public Styled3DMapPane() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void init() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.canvas3D = new Canvas3D(config);
        this.add("Center", (Component)this.canvas3D);
        this.simpleU = new SimpleUniverse(this.canvas3D);
        this.simpleU.getViewer().getView().setFrontClipDistance(0.001);
        this.simpleU.getViewer().getView().setBackClipDistance(10.0);
        this.scene = this.createSceneGraph(this.simpleU);
        this.simpleU.addBranchGraph(this.scene);
    }

    public BranchGroup createSceneGraph(SimpleUniverse su) {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup vpTrans = null;
        BoundingSphere mouseBounds = null;
        vpTrans = su.getViewingPlatform().getViewPlatformTransform();
        mouseBounds = new BoundingSphere(new Point3d(), Double.POSITIVE_INFINITY);
        Background bg = new Background(new Color3f(0.8f, 0.8f, 0.85f));
        bg.setApplicationBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0));
        objRoot.addChild((Node)bg);
        this.objScale = new TransformGroup();
        this.objScale.setCapability(18);
        this.objScale.setCapability(17);
        Transform3D scale = new Transform3D();
        Matrix4d matrix = new Matrix4d();
        matrix.setIdentity();
        matrix.m00 = 1.0;
        matrix.m11 = 1.0;
        matrix.m22 = 1.0;
        matrix.m33 = 1.0;
        scale.set(matrix);
        this.objScale.setTransform(scale);
        this.objScale.addChild((Node)new Grid3D());
        this.objRotate = new TransformGroup();
        this.objRotate.setCapability(18);
        this.objRotate.setCapability(17);
        MyMouseRotateBehavior myMouseRotate = new MyMouseRotateBehavior();
        myMouseRotate.setTransformGroup(this.objRotate);
        myMouseRotate.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
        objRoot.addChild((Node)myMouseRotate);
        UpdateTextureBehavior utb = new UpdateTextureBehavior();
        utb.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 1000.0));
        this.objRotate.addChild((Node)this.objScale);
        this.objRotate.addChild((Node)utb);
        objRoot.addChild((Node)this.objRotate);
        MyScaleBehavior myScaleBehavior = new MyScaleBehavior();
        myScaleBehavior.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
        objRoot.addChild((Node)myScaleBehavior);
        if (this.light) {
            AmbientLight lightA = new AmbientLight();
            lightA.setColor(new Color3f(0.0f, 0.0f, 0.0f));
            lightA.setInfluencingBounds((Bounds)new BoundingSphere());
            objRoot.addChild((Node)lightA);
            DirectionalLight lightD1 = new DirectionalLight();
            lightD1.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
            Vector3f direction1 = new Vector3f(-1.0f, -1.0f, -0.5f);
            direction1.normalize();
            lightD1.setDirection(direction1);
            lightD1.setColor(new Color3f(0.1f, 0.1f, 0.1f));
            objRoot.addChild((Node)lightD1);
        }
        this.orbit = new MyOrbitBehavior(su.getCanvas());
        this.orbit.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
        su.getViewingPlatform().setViewPlatformBehavior((ViewPlatformBehavior)this.orbit);
        objRoot.compile();
        int x = su.getCanvas().getBounds().x + 20;
        int y = su.getCanvas().getBounds().y + 20;
        MouseWheelEvent m = new MouseWheelEvent((Component)this, 507, 0L, 0, x, y, 0, false, 0, 3, 1);
        this.orbit.mouseWheelMoved(m);
        this.orbit.mouseWheelMoved(m);
        this.orbit.mouseWheelMoved(m);
        this.orbit.mouseWheelMoved(m);
        this.orbit.mouseWheelMoved(m);
        return objRoot;
    }

    public void setHeightMap(JAMSAscGridReader agr) {
        this.agr = agr;
    }

    public void setContext(MapContext map) {
        double width = this.textureWidth;
        double height = this.textureHeight;
        this.img = new BufferedImage((int)width, (int)height, 1);
        Graphics2D graphics2D = this.img.createGraphics();
        double xs = this.agr.x11corner;
        double ys = this.agr.y11corner;
        double xe = xs + (double)this.agr.ncols * this.agr.cellsize;
        double ye = ys + (double)this.agr.nrows * this.agr.cellsize;
        this.envelope = new Envelope();
        for (MapLayer mapLayer : map.getLayers()) {
            try {
                this.envelope.expandToInclude(mapLayer.getFeatureSource().getFeatures().getBounds());
            }
            catch (Exception e) {
                System.out.println("Error because: " + e.toString());
            }
        }
        xs = (double)((int)(this.envelope.getMinX() / this.agr.cellsize)) * this.agr.cellsize;
        xe = (double)((int)(this.envelope.getMaxX() / this.agr.cellsize)) * this.agr.cellsize;
        ys = (double)((int)(this.envelope.getMinY() / this.agr.cellsize)) * this.agr.cellsize;
        ye = (double)((int)(this.envelope.getMaxY() / this.agr.cellsize)) * this.agr.cellsize;
        this.envelope = new Envelope(xs, xe, ys, ye);
        this.bound = new Rectangle();
        this.bound.x = 0;
        this.bound.y = 0;
        this.bound.width = (int)width;
        this.bound.height = (int)height;
        StreamingRenderer myRender = new StreamingRenderer();
        myRender.setContext(map);
        HashMap hints = new HashMap();
        myRender.setRendererHints(hints);
        myRender.paint(graphics2D, this.bound, this.envelope);
    }

    public class Grid3D
    extends Shape3D {
        public Grid3D() {
            this.Init();
        }

        public void Init() {
            this.setCapability(13);
            this.setCapability(12);
            this.setGeometry(this.createGeometry());
            Appearance appear = new Appearance();
            PolygonAttributes polyAttr = new PolygonAttributes();
            polyAttr.setCullFace(0);
            appear.setPolygonAttributes(polyAttr);
            BufferedImage bImage = new BufferedImage((int)Styled3DMapPane.this.textureWidth, (int)Styled3DMapPane.this.textureWidth, 2);
            ImageComponent2D image = new ImageComponent2D(1, bImage, true, true);
            image.setCapability(3 | 2 | 1);
            Texture2D texture = new Texture2D(1, 6, image.getWidth(), image.getHeight());
            texture.setImage(0, (ImageComponent)image);
            appear.setTexture((Texture)texture);
            appear.setCapability(3 | 2 | 4 | 5 | 6 | 7);
            texture.setCapability(1 | 0 | 7);
            Material material = new Material();
            material.setDiffuseColor(0.0f, 0.0f, 0.0f);
            material.setAmbientColor(0.0f, 0.0f, 0.0f);
            material.setEmissiveColor(0.0f, 0.0f, 0.0f);
            material.setShininess(0.0f);
            material.setLightingEnable(true);
            appear.setMaterial(material);
            this.setAppearance(appear);
        }

        public Geometry createGeometry() {
            double scaley;
            double scalex = Styled3DMapPane.this.envelope.getWidth();
            if (scalex > (scaley = Styled3DMapPane.this.envelope.getHeight())) {
                scaley = scaley / scalex * (double)Styled3DMapPane.this.scale;
                scalex = Styled3DMapPane.this.scale;
            } else {
                scalex = scalex / scaley * (double)Styled3DMapPane.this.scale;
                scaley = Styled3DMapPane.this.scale;
            }
            double offsetx = 0.5 * scalex;
            double offsety = 0.5 * scaley;
            double invxRes = scalex / (double)(Styled3DMapPane.this.xRes - 1);
            double invyRes = scaley / (double)(Styled3DMapPane.this.yRes - 1);
            float minHeight = Float.POSITIVE_INFINITY;
            float maxHeight = Float.NEGATIVE_INFINITY;
            float[][] hMap = new float[Styled3DMapPane.this.xRes][Styled3DMapPane.this.yRes];
            for (int x = 0; x < Styled3DMapPane.this.xRes; ++x) {
                for (int y = 0; y < Styled3DMapPane.this.yRes; ++y) {
                    float value;
                    float fx = x;
                    float fy = y;
                    if (Styled3DMapPane.this.agr == null || Styled3DMapPane.this.envelope == null) continue;
                    double posX = Styled3DMapPane.this.envelope.getMinX() + (double)fx * (invxRes / scalex) * Styled3DMapPane.this.envelope.getWidth();
                    double posY = Styled3DMapPane.this.envelope.getMinY() + (double)fy * (invyRes / scaley) * Styled3DMapPane.this.envelope.getHeight();
                    hMap[x][y] = value = (float)Styled3DMapPane.this.agr.getValue(posX, posY);
                    if ((double)value == -1.0) continue;
                    if (minHeight > value) {
                        minHeight = value;
                    }
                    if (!(maxHeight < value)) continue;
                    maxHeight = value;
                }
            }
            float hScale = Styled3DMapPane.this.height / (maxHeight - minHeight);
            int indexCounter = 0;
            IndexedQuadArray grid = new IndexedQuadArray(Styled3DMapPane.this.xRes * Styled3DMapPane.this.yRes, 35, 4 * (Styled3DMapPane.this.xRes - 1) * (Styled3DMapPane.this.yRes - 1));
            for (int x = 0; x < Styled3DMapPane.this.xRes; ++x) {
                for (int y = 0; y < Styled3DMapPane.this.yRes; ++y) {
                    float fx = x;
                    float fy = y;
                    if (Styled3DMapPane.this.agr == null) {
                        grid.setCoordinate(x * Styled3DMapPane.this.xRes + y, new Point3f((float)((double)fx * invxRes - offsetx), (float)((double)fy * invyRes - offsety), 0.0f));
                    } else {
                        float value = hMap[x][y];
                        grid.setCoordinate(x * Styled3DMapPane.this.xRes + y, new Point3f((float)((double)fx * invxRes - offsetx), (float)((double)fy * invyRes - offsety), hScale * (value -= minHeight) - 0.5f * Styled3DMapPane.this.height));
                    }
                    grid.setTextureCoordinate(0, x * Styled3DMapPane.this.xRes + y, new TexCoord2f((float)((double)fx * invxRes / scalex), 1.0f - (float)((double)fy * invyRes / scaley)));
                    if (x != Styled3DMapPane.this.xRes - 1 && y != Styled3DMapPane.this.yRes - 1 && (double)hMap[x][y] >= 0.0 && (double)hMap[x + 1][y] >= 0.0 && (double)hMap[x][y + 1] >= 0.0 && (double)hMap[x + 1][y + 1] >= 0.0) {
                        grid.setCoordinateIndex(indexCounter + 0, x * Styled3DMapPane.this.xRes + y);
                        grid.setCoordinateIndex(indexCounter + 1, (x + 1) * Styled3DMapPane.this.xRes + y);
                        grid.setCoordinateIndex(indexCounter + 2, (x + 1) * Styled3DMapPane.this.xRes + y + 1);
                        grid.setCoordinateIndex(indexCounter + 3, x * Styled3DMapPane.this.xRes + y + 1);
                        grid.setTextureCoordinateIndex(0, indexCounter + 0, x * Styled3DMapPane.this.xRes + y);
                        grid.setTextureCoordinateIndex(0, indexCounter + 1, (x + 1) * Styled3DMapPane.this.xRes + y);
                        grid.setTextureCoordinateIndex(0, indexCounter + 2, (x + 1) * Styled3DMapPane.this.xRes + y + 1);
                        grid.setTextureCoordinateIndex(0, indexCounter + 3, x * Styled3DMapPane.this.xRes + y + 1);
                        grid.setNormalIndex(indexCounter + 0, x * Styled3DMapPane.this.xRes + y);
                        grid.setNormalIndex(indexCounter + 1, (x + 1) * Styled3DMapPane.this.xRes + y);
                        grid.setNormalIndex(indexCounter + 2, (x + 1) * Styled3DMapPane.this.xRes + y + 1);
                        grid.setNormalIndex(indexCounter + 3, x * Styled3DMapPane.this.xRes + y + 1);
                        indexCounter += 4;
                    }
                    Vector3f v11 = new Vector3f();
                    Vector3f v12 = new Vector3f();
                    Vector3f v13 = new Vector3f();
                    Vector3f v21 = new Vector3f();
                    Vector3f v22 = new Vector3f();
                    Vector3f v23 = new Vector3f();
                    Vector3f v31 = new Vector3f();
                    Vector3f v32 = new Vector3f();
                    Vector3f v33 = new Vector3f();
                    Vector3f vN1 = new Vector3f();
                    Vector3f vN2 = new Vector3f();
                    Vector3f vN3 = new Vector3f();
                    Vector3f vN4 = new Vector3f();
                    Vector3f vN5 = new Vector3f();
                    Vector3f vN6 = new Vector3f();
                    Vector3f vN7 = new Vector3f();
                    Vector3f vN8 = new Vector3f();
                    Vector3f vtmp1 = new Vector3f();
                    Vector3f vtmp2 = new Vector3f();
                    Vector3f vResult = new Vector3f();
                    v22.x = (float)((double)x * invxRes - offsetx);
                    v22.y = (float)((double)y * invyRes - offsety);
                    v22.z = hScale * hMap[x][y] - 2.5f;
                    v11.x = (float)((double)(x - 1) * invxRes - offsetx);
                    v11.y = (float)((double)(y - 1) * invxRes - offsety);
                    v11.z = x > 0 && y > 0 ? hScale * hMap[x - 1][y - 1] - 2.5f : v22.z;
                    v12.x = (float)((double)x * invxRes - offsetx);
                    v12.y = (float)((double)(y - 1) * invxRes - offsety);
                    v12.z = y > 0 ? hScale * hMap[x][y - 1] - 2.5f : v22.z;
                    v13.x = (float)((double)(x + 1) * invxRes - offsetx);
                    v13.y = (float)((double)(y - 1) * invxRes - offsety);
                    v13.z = x < Styled3DMapPane.this.xRes - 1 && y > 0 ? hScale * hMap[x + 1][y - 1] - 2.5f : v22.z;
                    v21.x = (float)((double)(x - 1) * invxRes - offsetx);
                    v21.y = (float)((double)y * invxRes - offsety);
                    v21.z = x > 0 ? hScale * hMap[x - 1][y] - 2.5f : v22.z;
                    v23.x = (float)((double)(x + 1) * invxRes - offsetx);
                    v23.y = (float)((double)y * invxRes - offsety);
                    v23.z = x < Styled3DMapPane.this.xRes - 1 ? hScale * hMap[x + 1][y] - 2.5f : v22.z;
                    v31.x = (float)((double)(x - 1) * invxRes - offsetx);
                    v31.y = (float)((double)(y + 1) * invxRes - offsety);
                    v31.z = x > 0 && y < Styled3DMapPane.this.yRes - 1 ? hScale * hMap[x - 1][y + 1] - 2.5f : v22.z;
                    v32.x = (float)((double)x * invxRes - offsetx);
                    v32.y = (float)((double)(y + 1) * invxRes - offsety);
                    v32.z = y < Styled3DMapPane.this.yRes - 1 ? hScale * hMap[x][y + 1] - 2.5f : v22.z;
                    v33.x = (float)((double)(x + 1) * invxRes - offsetx);
                    v33.y = (float)((double)(y + 1) * invxRes - offsety);
                    v33.z = x < Styled3DMapPane.this.xRes - 1 && y < Styled3DMapPane.this.yRes - 1 ? hScale * hMap[x + 1][y + 1] - 2.5f : v22.z;
                    vtmp1.sub((Tuple3f)v22, (Tuple3f)v11);
                    vtmp2.sub((Tuple3f)v21, (Tuple3f)v22);
                    vN1.cross(vtmp1, vtmp2);
                    vN1.normalize();
                    vtmp1.sub((Tuple3f)v22, (Tuple3f)v12);
                    vtmp2.sub((Tuple3f)v11, (Tuple3f)v22);
                    vN2.cross(vtmp1, vtmp2);
                    vN2.normalize();
                    vtmp1.sub((Tuple3f)v22, (Tuple3f)v13);
                    vtmp2.sub((Tuple3f)v12, (Tuple3f)v22);
                    vN3.cross(vtmp1, vtmp2);
                    vN3.normalize();
                    vtmp1.sub((Tuple3f)v22, (Tuple3f)v23);
                    vtmp2.sub((Tuple3f)v13, (Tuple3f)v22);
                    vN4.cross(vtmp1, vtmp2);
                    vN4.normalize();
                    vtmp1.sub((Tuple3f)v22, (Tuple3f)v33);
                    vtmp2.sub((Tuple3f)v23, (Tuple3f)v22);
                    vN5.cross(vtmp1, vtmp2);
                    vN5.normalize();
                    vtmp1.sub((Tuple3f)v22, (Tuple3f)v32);
                    vtmp2.sub((Tuple3f)v33, (Tuple3f)v22);
                    vN6.cross(vtmp1, vtmp2);
                    vN6.normalize();
                    vtmp1.sub((Tuple3f)v22, (Tuple3f)v31);
                    vtmp2.sub((Tuple3f)v32, (Tuple3f)v22);
                    vN7.cross(vtmp1, vtmp2);
                    vN7.normalize();
                    vtmp1.sub((Tuple3f)v22, (Tuple3f)v21);
                    vtmp2.sub((Tuple3f)v31, (Tuple3f)v22);
                    vN8.cross(vtmp1, vtmp2);
                    vN8.normalize();
                    vN1.add((Tuple3f)vN2);
                    vN1.add((Tuple3f)vN3);
                    vN1.add((Tuple3f)vN4);
                    vN1.add((Tuple3f)vN5);
                    vN1.add((Tuple3f)vN6);
                    vN1.add((Tuple3f)vN7);
                    vN1.add((Tuple3f)vN8);
                    vResult = vN1;
                    vResult.normalize();
                    grid.setNormal(x * Styled3DMapPane.this.xRes + y, vResult);
                }
            }
            return grid;
        }
    }

    class UpdateTextureBehavior
    extends Behavior
    implements ImageComponent2D.Updater {
        WakeupOnElapsedFrames w = new WakeupOnElapsedFrames(0);

        public void initialize() {
            this.wakeupOn((WakeupCondition)this.w);
        }

        public void updateData(ImageComponent2D imageComponent, int x, int y, int width, int height) {
            imageComponent.set(Styled3DMapPane.this.img);
        }

        public void processStimulus(Enumeration critiria) {
            Grid3D grid = (Grid3D)Styled3DMapPane.this.objScale.getChild(0);
            ((ImageComponent2D)grid.getAppearance().getTexture().getImage(0)).updateData((ImageComponent2D.Updater)this, 0, 0, 0, 0);
            this.wakeupOn((WakeupCondition)this.w);
        }
    }

    class MyOrbitBehavior
    extends OrbitBehavior {
        MyOrbitBehavior(Canvas3D c3d) {
            super(c3d);
            this.setRotationCenter(new Point3d(0.0, 0.0, 0.0));
            this.setTranslateEnable(false);
            this.setRotYFactor(0.0);
            this.setRotXFactor(0.0);
            this.setZoomFactor(0.5);
            this.setMinRadius(100.0);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
        }

        public void mouseWheelMoved(MouseWheelEvent m) {
            super.mouseWheelMoved(m);
        }
    }

    class MyMouseRotateBehavior
    extends Behavior {
        double rotX = 0.0;
        double rotZ = 0.0;
        int x;
        int x_last;
        int y;
        int y_last;
        int x2;
        int x2_last;
        int y2;
        int y2_last;
        boolean init = false;
        boolean initb2 = false;
        double xFactor = 0.0015;
        double yFactor = 0.0015;
        double xTranslationFactor = 0.01;
        double yTranslationFactor = 0.01;
        TransformGroup transformGroup;
        private WakeupOr mouseCriterion;
        boolean bOnClick = false;
        boolean bOnClickb2 = false;

        MyMouseRotateBehavior() {
            WakeupCriterion[] mouseEvents = new WakeupCriterion[]{new WakeupOnAWTEvent(506), new WakeupOnAWTEvent(501), new WakeupOnAWTEvent(502)};
            this.mouseCriterion = new WakeupOr(mouseEvents);
        }

        public void initialize() {
            Transform3D trans = new Transform3D();
            trans.setTranslation(new Vector3d(0.0, 0.0, 0.0));
            this.rotX = 0.7853;
            trans.rotX(this.rotX);
            trans.rotY(0.0);
            trans.rotZ(0.0);
            this.transformGroup.setTransform(trans);
            this.init = false;
            this.wakeupOn((WakeupCondition)this.mouseCriterion);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 2) {
                return;
            }
            if (mouseEvent.getID() == 501) {
                if (mouseEvent.getButton() == 1) {
                    this.init = false;
                    this.bOnClick = true;
                }
            }
            if (mouseEvent.getID() == 502) {
                if (mouseEvent.getButton() == 1) {
                    this.bOnClick = false;
                }
            }
            if (mouseEvent.getID() == 501) {
                if (mouseEvent.getButton() == 3) {
                    this.initb2 = false;
                    this.bOnClickb2 = true;
                }
            }
            if (mouseEvent.getID() == 502) {
                if (mouseEvent.getButton() == 3) {
                    this.bOnClickb2 = false;
                }
            }
            if ((mouseEvent.getModifiersEx() & 0x400) != 0) {
                this.x = mouseEvent.getX();
                this.y = mouseEvent.getY();
                if (!this.init) {
                    this.x_last = this.x;
                    this.y_last = this.y;
                    this.init = true;
                }
            }
            if ((mouseEvent.getModifiersEx() & 0x1000) != 0) {
                this.x2 = mouseEvent.getX();
                this.y2 = mouseEvent.getY();
                if (!this.initb2) {
                    this.x2_last = this.x2;
                    this.y2_last = this.y2;
                    this.initb2 = true;
                }
            }
            if (this.x2 - this.x2_last < -40 || this.x2 - this.x2_last > 40) {
                this.x2_last = this.x2;
            }
            if (this.x - this.x_last < -40 || this.x - this.x_last > 40) {
                this.x_last = this.x;
            }
            if (this.y2 - this.y2_last < -40 || this.y2 - this.y2_last > 40) {
                this.y2_last = this.y2;
            }
            if (this.y - this.y_last < -40 || this.y - this.y_last > 40) {
                this.y_last = this.y;
            }
            if ((mouseEvent.getModifiersEx() & 0x400) != 0) {
                this.rotZ += (double)(this.x - this.x_last) * this.xFactor;
                this.rotX += (double)(this.y - this.y_last) * this.yFactor;
                if (this.rotX < -1.57) {
                    this.rotX = -1.57;
                }
                if (this.rotX > 0.0) {
                    this.rotX = 0.0;
                }
                Transform3D trans = new Transform3D();
                Transform3D transRotX = new Transform3D();
                transRotX.rotX(this.rotX);
                Transform3D transRotZ = new Transform3D();
                transRotZ.rotZ(this.rotZ);
                transRotX.mul(transRotZ);
                trans = transRotX;
                this.transformGroup.setTransform(trans);
            }
            if ((mouseEvent.getModifiersEx() & 0x1000) != 0) {
                if ((mouseEvent.getModifiersEx() & 0x400) == 0) {
                    Point3d point = new Point3d();
                    Styled3DMapPane.this.orbit.getRotationCenter(point);
                    Transform3D trans = new Transform3D();
                    this.transformGroup.getTransform(trans);
                    Matrix4d mat = new Matrix4d();
                    trans.get(mat);
                    Matrix4d mat2 = new Matrix4d();
                    mat2.setZero();
                    mat2.m20 = 1.0;
                    mat.mul(mat2);
                    Vector3d grad = new Vector3d(mat.m00, mat.m10, mat.m20);
                    Vector3d vTransX = new Vector3d();
                    Vector3d vTransY = new Vector3d();
                    if (grad.z != 0.0) {
                        vTransX.x = 1.0;
                        vTransX.y = 0.0;
                        vTransX.z = -grad.x / grad.z;
                        vTransX.normalize();
                        vTransX.x *= -((double)(this.x2 - this.x2_last)) * this.xFactor;
                        vTransX.z *= -((double)(this.x2 - this.x2_last)) * this.xFactor;
                    }
                    if (grad.x != 0.0) {
                        vTransX.x = -grad.z / grad.x;
                        vTransX.y = 0.0;
                        vTransX.z = 1.0;
                        vTransX.normalize();
                        vTransX.x *= -((double)(this.x2 - this.x2_last)) * this.xFactor;
                        vTransX.z *= -((double)(this.x2 - this.x2_last)) * this.xFactor;
                    }
                    if (grad.z != 0.0) {
                        vTransY.x = 0.0;
                        vTransY.y = 1.0;
                        vTransY.z = -grad.y / grad.z;
                        vTransY.normalize();
                        vTransY.y *= -((double)(this.y2 - this.y2_last)) * this.yFactor;
                        vTransY.z *= -((double)(this.y2 - this.y2_last)) * this.yFactor;
                    }
                    if (grad.y != 0.0) {
                        vTransY.x = 0.0;
                        vTransY.y = -grad.z / grad.y;
                        vTransY.z = 1.0;
                        vTransY.normalize();
                        vTransY.y *= -((double)(this.y2 - this.y2_last)) * this.yFactor;
                        vTransY.z *= -((double)(this.y2 - this.y2_last)) * this.yFactor;
                    }
                    point.x += vTransX.x + vTransY.x;
                    point.y += vTransX.y + vTransY.y;
                    point.z += vTransX.z + vTransY.z;
                    Styled3DMapPane.this.orbit.setRotationCenter(point);
                }
            }
            this.x_last = this.x;
            this.y_last = this.y;
            this.x2_last = this.x2;
            this.y2_last = this.y2;
        }

        public void setTransformGroup(TransformGroup gp) {
            this.transformGroup = gp;
        }

        public void processStimulus(Enumeration enumeration) {
            WakeupCriterion wakeup = (WakeupCriterion)enumeration.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent) {
                AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                for (int i = 0; i < event.length; ++i) {
                    this.processMouseEvent((MouseEvent)event[i]);
                }
            }
            this.wakeupOn((WakeupCondition)this.mouseCriterion);
        }
    }

    class MyScaleBehavior
    extends Behavior {
        MyScaleBehavior() {
        }

        public void initialize() {
            this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(0));
        }

        public void processStimulus(Enumeration enumeration) {
            Transform3D transform = new Transform3D();
            Styled3DMapPane.this.objScale.getTransform(transform);
            Matrix4d matrix = new Matrix4d();
            transform.get(matrix);
            matrix.m22 = (double)Styled3DMapPane.this.hScale * 1.0;
            transform.set(matrix);
            Styled3DMapPane.this.objScale.setTransform(transform);
            this.wakeupOn((WakeupCondition)new WakeupOnElapsedFrames(0));
        }
    }
}

