/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSGUIComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class SimpleXYPlot
extends JAMSGUIComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Title string for plot")
    public JAMSString plotTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Title string for x axis")
    public JAMSString xAxisTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Title string for x axis")
    public JAMSString yAxisTitle;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Title string for x axis")
    public JAMSDouble xValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Title string for x axis")
    public JAMSDouble[] yValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Flag for disabling or enabling the plot")
    public JAMSBoolean paint;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Flag for disabling or enabling the plot")
    public JAMSInteger PlotCount;
    private XYPlot plot;
    private XYSeries[] dataset;
    private JPanel panel;
    JFreeChart chart;
    JButton saveButton;
    int i;
    int graphCountLeft = 0;
    int graphCountRight = 0;
    HashMap<Integer, Color> colorTable = new HashMap();

    public SimpleXYPlot() {
        this.colorTable.put(0, Color.red);
        this.colorTable.put(1, Color.blue);
        this.colorTable.put(2, Color.green);
        this.colorTable.put(3, Color.pink);
        this.colorTable.put(4, Color.magenta);
        this.colorTable.put(5, Color.cyan);
        this.colorTable.put(6, Color.yellow);
        this.colorTable.put(7, Color.green);
        this.colorTable.put(8, Color.gray);
        this.colorTable.put(9, Color.lightGray);
        this.colorTable.put(10, Color.black);
        this.panel = null;
    }

    private void initDataSets() {
        this.dataset = new XYSeries[this.PlotCount.getValue()];
        for (int i = 0; i < this.PlotCount.getValue(); ++i) {
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            this.dataset[i] = new XYSeries((Comparable)((Object)this.plotTitle.getValue()));
            this.plot.setDataset(i, (XYDataset)new XYSeriesCollection(this.dataset[i]));
            renderer.setSeriesLinesVisible(0, true);
            renderer.setSeriesShapesVisible(0, false);
            renderer.setSeriesPaint(0, (Paint)this.colorTable.get(i));
            this.plot.setRenderer(i, (XYItemRenderer)renderer);
        }
    }

    private JPanel CreatePanel() {
        this.plot = new XYPlot();
        this.plot.setDomainAxis((ValueAxis)new NumberAxis(this.xAxisTitle.getValue()));
        this.plot.setRangeAxis((ValueAxis)new NumberAxis(this.yAxisTitle.getValue()));
        this.initDataSets();
        this.chart = new JFreeChart((Plot)this.plot);
        ChartPanel chartPanel = new ChartPanel(this.chart, true);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)chartPanel, "Center");
        return this.panel;
    }

    public JPanel getPanel() {
        if (this.paint == null || this.paint.getValue()) {
            return this.CreatePanel();
        }
        return null;
    }

    public void init() {
    }

    public void run() {
        if (this.dataset == null) {
            this.initDataSets();
        }
        if (this.paint == null || this.paint.getValue()) {
            for (int i = 0; i < this.dataset.length; ++i) {
                this.dataset[i].add(this.xValue.getValue(), this.yValue[i].getValue());
            }
        }
    }

    public void cleanup() {
    }
}

