/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import jams.components.gui.JAMSAscGridReader;
import jams.components.gui.MapCollection;
import jams.components.gui.Styled3DMapPane;
import jams.components.io.ShapeTool;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureTypeBuilder;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSStringArray;
import org.unijena.jams.model.JAMSGUIComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class MapCreator3D
extends JAMSGUIComponent
implements MouseListener {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of SLD-File containing layer style information")
    public JAMSString stylesFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="ID of a style in the SLD-File")
    public JAMSInteger styleID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of hru attribute to add for mapping")
    public JAMSStringArray showAttr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of ranges for classification attribute")
    public JAMSStringArray numOfRanges;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Color shading the ranges")
    public JAMSStringArray rangeColor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of shapefile to add as a layer to the map")
    public JAMSString shapeFileName1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of shapefile to add as a layer to the map")
    public JAMSString shapeFileName2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Name of shapefile to add as a layer to the map")
    public JAMSString shapeFileName3;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Colors for extra shapefiles")
    public JAMSStringArray shapeColors;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Original shape file name")
    public JAMSString baseShape;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HeightMapFile")
    public JAMSString heightMap;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HeightMapFile")
    public JAMSInteger resolution = null;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HeightMapFile")
    public JAMSBoolean light = null;
    private JPanel panel;
    private DefaultMapLayer[] optLayers = new DefaultMapLayer[3];
    private MapCollection[] mc;
    private int numOfParams;
    private int infoidx;
    private String mapFTypeName = "mapFType";
    private DefaultMutableTreeNode top;
    private DefaultMutableTreeNode last;
    private JTree tree;
    private boolean finished = false;
    private MapContext map;
    private Styled3DMapPane mp;
    private JTextPane info;
    private JSplitPane p;
    private JSplitPane splitPane;
    private JAMSAscGridReader asg;
    public JScrollPane treeView;
    private Feature selectedF = null;

    public void run() throws Exception {
        int i;
        int i2;
        if (!System.getProperty("os.name").contains("Windows")) {
            // empty if block
        }
        this.info.setText("3D Map Pane ... initializing");
        if (this.shapeFileName1 == null) {
            this.shapeFileName1 = new JAMSString("");
        }
        if (this.shapeFileName2 == null) {
            this.shapeFileName2 = new JAMSString("");
        }
        if (this.shapeFileName3 == null) {
            this.shapeFileName3 = new JAMSString("");
        }
        FeatureSource fs = null;
        String[] otherLayers = new String[]{this.shapeFileName1.getValue(), this.shapeFileName2.getValue(), this.shapeFileName3.getValue()};
        for (i2 = 0; i2 <= 2; ++i2) {
            if (otherLayers[i2].equals("")) continue;
            try {
                File shpFile = new File(this.dirName.getValue() + "/" + otherLayers[i2]);
                URL shpUrl = shpFile.toURI().toURL();
                String sourcename = shpFile.getName().split("\\.")[0];
                fs = new ShapefileDataStore(shpUrl).getFeatureSource(sourcename);
            }
            catch (Exception e) {
                // empty catch block
            }
            DefaultMapLayer layer = new DefaultMapLayer(fs, this.getStyle(fs, i2));
            layer.setTitle(otherLayers[i2]);
            this.optLayers[i2] = layer;
        }
        this.numOfParams = this.showAttr.getValue().length;
        this.mc = new MapCollection[this.numOfParams];
        for (i2 = 0; i2 <= this.numOfParams - 1; ++i2) {
            FeatureCollection fc = FeatureCollections.newCollection();
            GeometryAttributeType geo = (GeometryAttributeType)AttributeTypeFactory.newAttributeType((String)"geo", MultiPolygon.class);
            AttributeType newAt = AttributeTypeFactory.newAttributeType((String)"newAt", Object.class);
            FeatureTypeFactory mapFeatureType = FeatureTypeBuilder.newInstance((String)this.mapFTypeName);
            mapFeatureType.addType((AttributeType)geo);
            mapFeatureType.addType(newAt);
            DefaultFeatureType ft = null;
            try {
                ft = (DefaultFeatureType)mapFeatureType.getFeatureType();
            }
            catch (SchemaException e) {
                e.printStackTrace();
            }
            Iterator hrusIterate = this.hrus.getEntities().iterator();
            TreeSet<Double> s = new TreeSet<Double>();
            while (hrusIterate.hasNext()) {
                JAMSEntity e = (JAMSEntity)hrusIterate.next();
                Feature newFeature = ft.create(new Object[]{e.getGeometry("geom"), e.getDouble(this.showAttr.getValue()[i2])}, new Integer(new Double(e.getDouble("ID")).intValue()).toString());
                fc.add((Object)newFeature);
                s.add(e.getDouble(this.showAttr.getValue()[i2]));
            }
            this.mc[i2] = new MapCollection(this.showAttr.getValue()[i2], fc, s, this.rangeColor.getValue()[i2], Integer.parseInt(this.numOfRanges.getValue()[i2]));
            DefaultMutableTreeNode mapNode = new DefaultMutableTreeNode(this.mc[i2].getDesc());
            this.top.add(mapNode);
            Object[] nodeContent = this.mc[i2].getRanges();
            DefaultMutableTreeNode entry = null;
            for (int j = 1; j <= nodeContent.length - 1; ++j) {
                entry = new DefaultMutableTreeNode("<= " + (double)Math.round((Double)nodeContent[j] * 100000.0) / 100000.0, false);
                mapNode.add(entry);
            }
            for (int k = 0; k <= 2; ++k) {
                if (otherLayers[k].equals("")) continue;
                this.mc[i2].getMapContext().addLayer((MapLayer)this.optLayers[k]);
            }
        }
        DefaultMutableTreeNode layerEntry = null;
        for (i = 0; i <= 2; ++i) {
            if (otherLayers[i].equals("")) continue;
            layerEntry = new DefaultMutableTreeNode(this.optLayers[i].getTitle());
            this.top.add(layerEntry);
        }
        for (i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        if (this.mp == null) {
            this.mp = new Styled3DMapPane();
        }
        this.info.setText("3D Map Pane ... loading map");
        this.asg = new JAMSAscGridReader(this.dirName + "/" + this.heightMap.toString());
        boolean light = true;
        int Resolution = 256;
        if (this.resolution != null) {
            Resolution = this.resolution.getValue();
        }
        if (this.light != null) {
            light = this.light.getValue();
        }
        this.mp.light = light;
        this.mp.xRes = Resolution;
        this.mp.yRes = Resolution;
        this.mp.textureWidth = 2.0 * (double)Resolution;
        this.mp.textureHeight = 2.0 * (double)Resolution;
        this.map = new DefaultMapContext();
        this.setMap(this.mc[0]);
        this.mp.setHeightMap(this.asg);
        this.info.setText("3D Map Pane ... calculating normals");
        this.mp.init();
        this.p.setDividerLocation(0.8);
        this.splitPane.setDividerLocation(0.7);
        this.finished = true;
        this.tree.setVisible(true);
        this.panel.repaint();
        this.mp.repaint();
        this.info.setText("ready");
        this.mp.invalidate();
        this.mp.repaint();
    }

    protected Feature getSelectedFeature() {
        return this.selectedF;
    }

    private void setMap(MapCollection mc) throws Exception {
        this.map = mc.getMapContext();
        this.mp.setHeightMap(this.asg);
        this.mp.setContext(this.map);
    }

    public Style getStyle(FeatureSource fs, int i) {
        PointSymbolizer ps = null;
        LineSymbolizer ls = null;
        PolygonSymbolizer ms = null;
        StyleBuilder sb = new StyleBuilder();
        Style style = null;
        Class geoType = fs.getSchema().getDefaultGeometry().getType();
        if (geoType.equals(LineString.class) || geoType.equals(MultiLineString.class)) {
            ls = sb.createLineSymbolizer(Color.decode("#" + this.shapeColors.getValue()[i]), 2.0);
            style = sb.createStyle((Symbolizer)ls);
        } else if (geoType.equals(Point.class) || geoType.equals(MultiPoint.class)) {
            Mark pointMarker = sb.createMark("square", Color.decode("#" + this.shapeColors.getValue()[i]));
            ps = sb.createPointSymbolizer(sb.createGraphic(null, pointMarker, null));
            style = sb.createStyle((Symbolizer)ps);
        } else if (geoType.equals(Polygon.class) || geoType.equals(MultiPolygon.class)) {
            ms = sb.createPolygonSymbolizer(Color.decode("#" + this.shapeColors.getValue()[i]));
            style = sb.createStyle((Symbolizer)ms);
        }
        return style;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public JPanel getPanel() {
        try {
            this.panel = new GISPanel();
        }
        catch (Exception e) {
            System.out.println("Error during initialization of GIS Panel-->" + e.toString());
        }
        if (this.panel == null) {
            this.panel = new JPanel();
            JTextField text = new JTextField("Not available on this platform!");
            text.setEditable(false);
            text.setBorder(null);
            this.panel.add(text);
        }
        return this.panel;
    }

    public class GISPanel
    extends JPanel {
        public GISPanel() throws Exception {
            this.setLayout(new BorderLayout());
            MapCreator3D.this.top = new DefaultMutableTreeNode("Map List");
            MapCreator3D.this.tree = new JTree(MapCreator3D.this.top);
            MapCreator3D.this.tree.setCellRenderer(new NodeRenderer());
            MapCreator3D.this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)MapCreator3D.this.tree.getLastSelectedPathComponent();
                    MapCreator3D.this.last = node;
                    int idxToTopNode = node.isLeaf() ? MapCreator3D.this.top.getIndex(node.getParent()) : MapCreator3D.this.top.getIndex(node);
                    if (e.getClickCount() == 1 & (MapCreator3D.this.top.isNodeChild(node) || node.isLeaf())) {
                        try {
                            MapCreator3D.this.setMap(MapCreator3D.this.mc[idxToTopNode]);
                            MapCreator3D.this.mp.repaint();
                            if (MapCreator3D.this.last == null || MapCreator3D.this.last.isRoot()) {
                                MapCreator3D.this.infoidx = 0;
                            } else if (MapCreator3D.this.last.isLeaf()) {
                                MapCreator3D.this.infoidx = MapCreator3D.this.top.getIndex(MapCreator3D.this.last.getParent());
                            } else {
                                MapCreator3D.this.infoidx = MapCreator3D.this.top.getIndex(MapCreator3D.this.last);
                            }
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                }
            });
            MapCreator3D.this.info = new JTextPane();
            MapCreator3D.this.info.setEditable(false);
            MapCreator3D.this.info.setText("3D Map Pane has not been started yet, please wait ..");
            JSlider js = new JSlider();
            js.setMinimum(-20);
            js.setMaximum(20);
            js.setValue(0);
            js.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    ((MapCreator3D)MapCreator3D.this).mp.hScale = (float)Math.exp((double)source.getValue() / 10.0);
                }
            });
            JPanel sliderPanel = new JPanel();
            sliderPanel.setBorder(BorderFactory.createTitledBorder("Vertical exaggeration"));
            sliderPanel.add(js);
            JPanel miscPanel = new JPanel();
            miscPanel.setLayout(new BorderLayout());
            miscPanel.add((Component)sliderPanel, "North");
            miscPanel.add((Component)MapCreator3D.this.info, "Center");
            MapCreator3D.this.treeView = new JScrollPane(MapCreator3D.this.tree);
            MapCreator3D.this.p = new JSplitPane(0);
            MapCreator3D.this.p.setTopComponent(MapCreator3D.this.treeView);
            MapCreator3D.this.p.setBottomComponent(miscPanel);
            boolean light2 = true;
            int Resolution = 256;
            if (MapCreator3D.this.resolution != null) {
                Resolution = MapCreator3D.this.resolution.getValue();
            }
            if (MapCreator3D.this.light != null) {
                light2 = MapCreator3D.this.light.getValue();
            }
            if (MapCreator3D.this.mp == null) {
                MapCreator3D.this.mp = new Styled3DMapPane();
            }
            ((MapCreator3D)MapCreator3D.this).mp.light = light2;
            MapCreator3D.this.mp.setHeightMap(MapCreator3D.this.asg);
            ((MapCreator3D)MapCreator3D.this).mp.xRes = Resolution;
            ((MapCreator3D)MapCreator3D.this).mp.yRes = Resolution;
            ((MapCreator3D)MapCreator3D.this).mp.textureWidth = 2.0 * (double)Resolution;
            ((MapCreator3D)MapCreator3D.this).mp.textureHeight = 2.0 * (double)Resolution;
            URL url = this.getClass().getResource("resources/select.gif");
            ImageIcon iconSelect = new ImageIcon(url);
            ShapeExport export = new ShapeExport();
            MapCreator3D.this.splitPane = new JSplitPane(1);
            MapCreator3D.this.splitPane.setRightComponent(MapCreator3D.this.p);
            MapCreator3D.this.splitPane.setLeftComponent(MapCreator3D.this.mp);
            this.add(MapCreator3D.this.splitPane);
        }
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        private Icon blatt;
        private Icon blatt2;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            DefaultMutableTreeNode parentnode = (DefaultMutableTreeNode)node.getParent();
            int idxToParentNode = 0;
            int idxToTopNode = 0;
            if (!node.isRoot()) {
                idxToParentNode = parentnode.getIndex(node);
                idxToTopNode = MapCreator3D.this.top.getIndex(parentnode);
            }
            if (node.isRoot()) {
                // empty if block
            }
            if (leaf || !node.isRoot()) {
                // empty if block
            }
            if (leaf && node.getParent() == MapCreator3D.this.top) {
                this.blatt2 = new MyLayerIcon(MapCreator3D.this.top.getIndex(node));
                this.setIcon(this.blatt2);
            } else if (leaf) {
                this.blatt = new MyIcon(idxToTopNode, idxToParentNode);
                this.setIcon(this.blatt);
            }
            return this;
        }
    }

    class MyIcon
    implements Icon {
        private Integer a;
        private Integer b;

        public MyIcon(Integer a, Integer b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (MapCreator3D.this.finished) {
                g.drawRect(1, 1, 19, 14);
                g.setColor(Color.BLACK);
                g.setColor((Color)MapCreator3D.this.mc[this.a].getColors()[MapCreator3D.this.mc[this.a].getRanges().length - this.b - 1]);
                g.fillRect(1, 1, 19, 14);
            } else {
                MapCreator3D.this.tree.setVisible(false);
            }
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }

    class MyLayerIcon
    implements Icon {
        private int idx;

        public MyLayerIcon(Integer idx) {
            this.idx = idx - MapCreator3D.this.numOfParams;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.BLACK);
            g2d.drawRoundRect(0, 0, 20, 13, 5, 5);
            Class geoType = MapCreator3D.this.optLayers[this.idx].getFeatureSource().getSchema().getDefaultGeometry().getType();
            g2d.setColor(Color.decode("#" + MapCreator3D.this.shapeColors.getValue()[this.idx]));
            if (geoType.equals(LineString.class) || geoType.equals(MultiLineString.class)) {
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawLine(4, 4, 13, 6);
                g2d.drawLine(13, 6, 15, 9);
            } else if (geoType.equals(Point.class) || geoType.equals(MultiPoint.class)) {
                g2d.fillRect(4, 4, 4, 4);
                g2d.fillRect(13, 6, 4, 4);
            } else if (geoType.equals(Polygon.class) || geoType.equals(MultiPolygon.class)) {
                int[] xPoints = new int[]{2, 5, 9, 17};
                int[] yPoints = new int[]{3, 10, 12, 2};
                g2d.fillPolygon(xPoints, yPoints, 4);
            }
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }

    class ShapeExport
    extends AbstractAction {
        private ImageIcon icon;

        public ShapeExport() {
            this.putValue("ShortDescription", "Export actual map to ESRI shape format");
            URL url = this.getClass().getResource("resources/export.gif");
            this.icon = new ImageIcon(url);
            this.putValue("SmallIcon", this.icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int idx = MapCreator3D.this.last == null || MapCreator3D.this.last.isRoot() ? 0 : (MapCreator3D.this.last.isLeaf() ? MapCreator3D.this.top.getIndex(MapCreator3D.this.last.getParent()) : MapCreator3D.this.top.getIndex(MapCreator3D.this.last));
                ShapeTool expPanel = new ShapeTool(MapCreator3D.this.mc[idx].asCollectionDataStore(), MapCreator3D.this.baseShape, MapCreator3D.this.mc[idx].getDesc(), MapCreator3D.this.p, MapCreator3D.this.treeView);
                MapCreator3D.this.p.setTopComponent(expPanel);
                MapCreator3D.this.p.setDividerLocation(0.8);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

