/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Paint;
import org.geotools.feature.Feature;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.PolygonSymbolizer;

public class DynamicPolygonStyle2D
extends PolygonStyle2D {
    Feature feature;
    PolygonSymbolizer ps;

    public DynamicPolygonStyle2D(Feature f, PolygonSymbolizer sym) {
        this.feature = f;
        this.ps = sym;
    }

    public Paint getFill() {
        Fill fill = this.ps.getFill();
        if (fill == null) {
            return null;
        }
        Paint fillPaint = Color.decode((String)fill.getColor().getValue(this.feature));
        Graphic gr = fill.getGraphicFill();
        if (gr != null) {
            SLDStyleFactory fac = new SLDStyleFactory();
            fillPaint = fac.getTexturePaint(gr, this.feature);
        }
        return fillPaint;
    }

    public Composite getFillComposite() {
        Fill fill = this.ps.getFill();
        if (fill == null) {
            return null;
        }
        float opacity = ((Number)fill.getOpacity().getValue(this.feature)).floatValue();
        if (opacity == 1.0f) {
            return null;
        }
        return AlphaComposite.getInstance(3, opacity);
    }
}

