/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.coverage.Category;
import org.geotools.coverage.FactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.filter.Expression;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.util.NumberRange;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;

public final class RasterSymbolizerSupport {
    private final RasterSymbolizer symbolizer;

    public RasterSymbolizerSupport(RasterSymbolizer symbolizer) {
        this.symbolizer = symbolizer;
    }

    public GridCoverage recolorCoverage(GridCoverage grid) throws IllegalArgumentException {
        if (!(grid instanceof GridCoverage2D)) {
            throw new IllegalArgumentException("Cannot Recolor GridCoverage: GridCoverage2D is needed.");
        }
        GridCoverage2D gridCoverage = (GridCoverage2D)grid;
        int numBands = gridCoverage.getNumSampleDimensions();
        GridSampleDimension[] targetBands = new GridSampleDimension[numBands];
        Map[] colorMaps = new Map[numBands];
        for (int band = 0; band < numBands; ++band) {
            Map categories;
            colorMaps[band] = categories = this.getCategories(band);
            targetBands[band] = (GridSampleDimension)this.transformColormap(band, gridCoverage.getSampleDimension(band), colorMaps);
        }
        return FactoryFinder.getGridCoverageFactory(null).create((CharSequence)gridCoverage.getName(), gridCoverage.getRenderedImage(), (GridGeometry2D)gridCoverage.getGridGeometry(), targetBands, new GridCoverage[]{gridCoverage}, null);
    }

    public float getOpacity() {
        float alpha = 1.0f;
        Expression exp = this.symbolizer.getOpacity();
        if (exp == null) {
            return alpha;
        }
        Object obj = exp.getValue(null);
        if (obj == null) {
            return alpha;
        }
        Number num = null;
        if (obj instanceof Number) {
            num = (Number)obj;
        }
        if (num == null) {
            return alpha;
        }
        return num.floatValue();
    }

    public Map getCategories(int band) {
        String[] labels = this.getLabels(band);
        Color[] colors = this.getColors(band);
        HashMap<String, Color[]> categories = new HashMap<String, Color[]>();
        int labelsLength = labels.length;
        for (int i = 0; i < labelsLength; ++i) {
            if (!categories.containsKey(labels[i])) {
                categories.put(labels[i], new Color[]{colors[i]});
                continue;
            }
            Color[] oldCmap = (Color[])categories.get(labels[i]);
            int length = oldCmap.length;
            Color[] newCmap = new Color[length + 1];
            System.arraycopy(oldCmap, 0, newCmap, 0, length);
            newCmap[length] = colors[i];
            categories.put(labels[i], newCmap);
        }
        return categories;
    }

    public String[] getLabels(int band) {
        String[] labels = null;
        if (this.symbolizer.getColorMap() != null) {
            ColorMapEntry[] colors = this.symbolizer.getColorMap().getColorMapEntries();
            int numColors = colors.length;
            labels = new String[numColors];
            for (int ci = 0; ci < numColors; ++ci) {
                labels[ci] = colors[ci].getLabel();
            }
        }
        return labels;
    }

    public Color[] getColors(int band) {
        Color[] colorTable = null;
        if (this.symbolizer.getColorMap() != null) {
            ColorMapEntry[] colors = this.symbolizer.getColorMap().getColorMapEntries();
            int numColors = colors.length;
            colorTable = new Color[numColors];
            for (int ci = 0; ci < numColors; ++ci) {
                Expression exp = colors[ci].getColor();
                if (exp == null) {
                    return null;
                }
                Object obj = exp.getValue(null);
                if (obj == null) {
                    return null;
                }
                Double opacity = colors[ci].getOpacity() != null ? (colors[ci].getOpacity().getValue(null) instanceof String ? Double.valueOf((String)colors[ci].getOpacity().getValue(null)) : (Double)colors[ci].getOpacity().getValue(null)) : new Double(1.0);
                Integer intval = Integer.decode((String)obj);
                int i = intval;
                colorTable[ci] = new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, new Double(Math.ceil(255.0 * (double)opacity.floatValue())).intValue());
                if (colorTable[ci] != null) continue;
                return null;
            }
        }
        return colorTable;
    }

    public SampleDimension transformColormap(int band, SampleDimension dimension, Map[] colorMaps) {
        int length;
        if (colorMaps == null || colorMaps.length == 0) {
            return dimension;
        }
        boolean changed = false;
        Map colorMap = colorMaps[Math.min(band, colorMaps.length - 1)];
        List categoryList = ((GridSampleDimension)dimension).getCategories();
        if (categoryList == null) {
            return dimension;
        }
        Category[] categories = (Category[])categoryList.toArray();
        int j = length = categories.length;
        while (--j >= 0) {
            Category category = categories[j];
            Color[] colors = (Color[])colorMap.get(category.getName().toString());
            if (colors == null && (!category.isQuantitative() || (colors = (Color[])colorMap.get(null)) == null)) continue;
            NumberRange range = category.getRange();
            int lower = ((Number)((Object)range.getMinValue())).intValue();
            int upper = ((Number)((Object)range.getMaxValue())).intValue();
            if (!range.isMinIncluded()) {
                ++lower;
            }
            if (range.isMaxIncluded()) {
                ++upper;
            }
            if (categories[j].equals((Object)(category = category.recolor(colors)))) continue;
            categories[j] = category;
            changed = true;
        }
        return changed ? new GridSampleDimension((CharSequence)dimension.getDescription(), categories, dimension.getUnits()) : dimension;
    }
}

