/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CannotCropException;
import org.geotools.coverage.processing.DefaultProcessor;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.coverage.processing.operation.FilteredSubsample;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.coverage.processing.operation.Scale;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerSupport;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.image.CoverageUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.styling.RasterSymbolizer;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridRange;
import org.opengis.filter.expression.Literal;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;

public final class GridCoverageRenderer {
    private static final boolean DEBUG;
    protected static final double EPS = 1.0E-6;
    private static String debugDir;
    private static final Scale scaleFactory;
    private static final FilteredSubsample filteredSubsampleFactory;
    private static final Crop coverageCropFactory;
    private static final Logger LOGGER;
    private final CoordinateReferenceSystem destinationCRS;
    private final GeneralEnvelope destinationEnvelope;
    private final Rectangle destinationSize;
    private final GridToEnvelopeMapper gridToEnvelopeMapper;
    private final AffineTransform finalGridToWorld;
    private final AffineTransform finalWorldToGrid;
    private final Hints hints = new Hints(new HashMap(5));
    private static final ParameterValueGroup resampleParams;
    private static final ParameterValueGroup scaleParams;
    private static ParameterValueGroup cropParams;
    private static final ParameterValueGroup filteredSubsampleParams;
    private static final Resample resampleFactory;
    private static final int MIN_DIM_TOLERANCE = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, com.vividsolutions.jts.geom.Envelope envelope, Rectangle screenSize) throws TransformException, NoninvertibleTransformException {
        this(destinationCRS, envelope, screenSize, null);
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, com.vividsolutions.jts.geom.Envelope envelope, Rectangle screenSize, RenderingHints java2dHints) throws TransformException, NoninvertibleTransformException {
        this.destinationSize = screenSize;
        this.destinationCRS = CRSUtilities.getCRS2D((CoordinateReferenceSystem)destinationCRS);
        this.gridToEnvelopeMapper = new GridToEnvelopeMapper();
        this.gridToEnvelopeMapper.setGridType(PixelInCell.CELL_CORNER);
        this.gridToEnvelopeMapper.setGridRange((GridRange)new GeneralGridRange(this.destinationSize));
        this.destinationEnvelope = new GeneralEnvelope((Envelope)new ReferencedEnvelope(envelope, destinationCRS));
        this.gridToEnvelopeMapper.setEnvelope((Envelope)this.destinationEnvelope);
        this.finalGridToWorld = new AffineTransform(this.gridToEnvelopeMapper.createAffineTransform());
        this.finalWorldToGrid = this.finalGridToWorld.createInverse();
        if (java2dHints != null) {
            this.hints.add(java2dHints);
        }
        this.hints.add((RenderingHints)CoverageUtilities.LENIENT_HINT);
        this.hints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
    }

    public void paint(Graphics2D graphics, GridCoverage2D gridCoverage, RasterSymbolizer symbolizer) throws FactoryException, TransformException, NoninvertibleTransformException {
        GridCoverage2D preSymbolizer;
        boolean doReprojection;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Drawing coverage " + gridCoverage.toString());
        }
        CoordinateReferenceSystem sourceCoverageCRS = gridCoverage.getCoordinateReferenceSystem2D();
        GridGeometry2D sourceCoverageGG = (GridGeometry2D)gridCoverage.getGridGeometry();
        GeneralGridRange sourceRange = (GeneralGridRange)sourceCoverageGG.getGridRange();
        GeneralEnvelope sourceCoverageEnvelope = (GeneralEnvelope)gridCoverage.getEnvelope();
        MathTransform sourceCRSToDestinationCRSTransformation = StreamingRenderer.getMathTransform(sourceCoverageCRS, this.destinationCRS);
        MathTransform destinationCRSToSourceCRSTransformation = sourceCRSToDestinationCRSTransformation.inverse();
        boolean bl = doReprojection = !sourceCRSToDestinationCRSTransformation.isIdentity();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Transforming coverage envelope with transform " + destinationCRSToSourceCRSTransformation.toWKT());
        }
        GeneralEnvelope croppedDestinationEnvelope = null;
        if (doReprojection) {
            croppedDestinationEnvelope = new GeneralEnvelope((Envelope)this.destinationEnvelope);
            croppedDestinationEnvelope.setCoordinateReferenceSystem(this.destinationCRS);
            GeneralEnvelope transformedSourceCoverageEnvelope = CRSUtilities.transform((MathTransform)sourceCRSToDestinationCRSTransformation, (Envelope)sourceCoverageEnvelope);
            transformedSourceCoverageEnvelope.setCoordinateReferenceSystem(this.destinationCRS);
            croppedDestinationEnvelope.intersect((Envelope)transformedSourceCoverageEnvelope);
        }
        Interpolation interpolation = (Interpolation)this.hints.get((Object)JAI.KEY_INTERPOLATION);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Using interpolation " + interpolation);
        }
        if (!this.isScaleTranslate(gridCoverage.getGridGeometry().getGridToCRS())) {
            if (doReprojection) {
                preSymbolizer = this.resample(gridCoverage, this.destinationCRS, (Interpolation)(interpolation == null ? new InterpolationBilinear() : interpolation), croppedDestinationEnvelope);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Reprojecting to crs " + this.destinationCRS.toWKT());
                }
                if (DEBUG) {
                    try {
                        ImageIO.write(preSymbolizer.geophysics(false).getRenderedImage(), "tiff", new File(debugDir, "reprojected.tiff"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                preSymbolizer = gridCoverage;
            }
        } else {
            AffineTransform finalGridToWorldInGCCRS;
            GeneralEnvelope destinationEnvelopeInSourceGCCRS = doReprojection ? CRSUtilities.transform((MathTransform)destinationCRSToSourceCRSTransformation, (Envelope)this.destinationEnvelope) : new GeneralEnvelope((Envelope)this.destinationEnvelope);
            destinationEnvelopeInSourceGCCRS.setCoordinateReferenceSystem(sourceCoverageCRS);
            GridCoverage2D croppedGridCoverage = this.getCroppedCoverage(gridCoverage, destinationEnvelopeInSourceGCCRS, sourceCoverageCRS);
            if (croppedGridCoverage == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Skipping current coverage because cropped to an empty area");
                }
                return;
            }
            if (DEBUG) {
                try {
                    ImageIO.write(croppedGridCoverage.geophysics(false).getRenderedImage(), "tiff", new File(debugDir, "cropped.tiff"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (!sourceCRSToDestinationCRSTransformation.isIdentity()) {
                if (!$assertionsDisabled && !new GeneralGridRange(this.destinationSize).equals((Object)this.gridToEnvelopeMapper.getGridRange())) {
                    throw new AssertionError();
                }
                this.gridToEnvelopeMapper.setEnvelope((Envelope)destinationEnvelopeInSourceGCCRS);
                finalGridToWorldInGCCRS = new AffineTransform(this.gridToEnvelopeMapper.createAffineTransform());
            } else {
                finalGridToWorldInGCCRS = new AffineTransform(this.finalGridToWorld);
            }
            AffineTransform croppedCoverageGridToWorldTransformations = (AffineTransform)((GridGeometry2D)croppedGridCoverage.getGridGeometry()).getGridToCRS2D();
            boolean sourceGCHasLonFirst = XAffineTransform.getSwapXY((AffineTransform)croppedCoverageGridToWorldTransformations) != -1;
            boolean destinationHasLonFirst = XAffineTransform.getSwapXY((AffineTransform)finalGridToWorldInGCCRS) != -1;
            double actualScaleX = sourceGCHasLonFirst ? croppedCoverageGridToWorldTransformations.getScaleX() : croppedCoverageGridToWorldTransformations.getShearY();
            double actualScaleY = sourceGCHasLonFirst ? croppedCoverageGridToWorldTransformations.getScaleY() : croppedCoverageGridToWorldTransformations.getShearX();
            double scaleX = actualScaleX / (destinationHasLonFirst ? finalGridToWorldInGCCRS.getScaleX() : finalGridToWorldInGCCRS.getShearY());
            double scaleY = actualScaleY / (destinationHasLonFirst ? finalGridToWorldInGCCRS.getScaleY() : finalGridToWorldInGCCRS.getShearX());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Scale factors are " + scaleX + " " + scaleY);
            }
            int actualW = sourceRange.getLength(0);
            int actualH = sourceRange.getLength(1);
            if (Math.round((double)actualW * scaleX) < 2L && Math.round((double)actualH * scaleY) < 2L) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Skipping the actual coverage because one of the final dimension is null");
                }
                return;
            }
            if (scaleX * scaleY <= 1.0) {
                int scaleXInt = (int)Math.floor(1.0 / scaleX);
                scaleXInt = scaleXInt == 0 ? 1 : scaleXInt;
                int scaleYInt = (int)Math.floor(1.0 / scaleY);
                int n = scaleYInt = scaleYInt == 0 ? 1 : scaleYInt;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Filtered subsample with factors " + scaleXInt + scaleYInt);
                }
                GridCoverage2D preScaledGridCoverage = this.filteredSubsample(croppedGridCoverage, scaleXInt, scaleYInt, (Interpolation)new InterpolationNearest(), BorderExtender.createInstance((int)1));
                if (DEBUG) {
                    try {
                        ImageIO.write(preScaledGridCoverage.geophysics(false).getRenderedImage(), "tiff", new File(debugDir, "prescaled.tiff"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Scale down with factors " + scaleX * (double)scaleXInt + scaleY * (double)scaleYInt);
                }
                GridCoverage2D scaledGridCoverage = scaleX * (double)scaleXInt == 1.0 && scaleY * (double)scaleYInt == 1.0 ? preScaledGridCoverage : this.scale(scaleX * (double)scaleXInt, scaleY * (double)scaleYInt, 0.0f, 0.0f, (Interpolation)(interpolation == null ? new InterpolationBilinear() : interpolation), BorderExtender.createInstance((int)1), preScaledGridCoverage);
                if (DEBUG) {
                    try {
                        ImageIO.write(scaledGridCoverage.geophysics(false).getRenderedImage(), "tiff", new File(debugDir, "scaled.tiff"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (doReprojection) {
                    preSymbolizer = this.resample(scaledGridCoverage, this.destinationCRS, (Interpolation)(interpolation == null ? new InterpolationBilinear() : interpolation), croppedDestinationEnvelope);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Reprojecting to crs " + this.destinationCRS.toWKT());
                    }
                    if (DEBUG) {
                        try {
                            ImageIO.write(preSymbolizer.geophysics(false).getRenderedImage(), "tiff", new File(debugDir, "reprojected.tiff"));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    preSymbolizer = scaledGridCoverage;
                }
            } else {
                GridCoverage2D reprojectedCoverage;
                if (doReprojection) {
                    reprojectedCoverage = this.resample(croppedGridCoverage, this.destinationCRS, (Interpolation)(interpolation == null ? new InterpolationBilinear() : interpolation), croppedDestinationEnvelope);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Reprojecting to crs " + this.destinationCRS.toWKT());
                    }
                } else {
                    reprojectedCoverage = croppedGridCoverage;
                }
                if (DEBUG) {
                    try {
                        ImageIO.write(reprojectedCoverage.geophysics(false).getRenderedImage(), "tiff", new File("c:/reprojected.tiff"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Scale up with factors " + scaleX + scaleY);
                }
                preSymbolizer = this.scale(scaleX, scaleY, 0.0f, 0.0f, (Interpolation)(interpolation == null ? new InterpolationBilinear() : interpolation), BorderExtender.createInstance((int)1), reprojectedCoverage);
                if (DEBUG) {
                    try {
                        ImageIO.write(preSymbolizer.geophysics(false).getRenderedImage(), "tiff", new File(debugDir, "scaleup.tiff"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (DEBUG) {
                try {
                    ImageIO.write(preSymbolizer.geophysics(false).getRenderedImage(), "tiff", new File(debugDir, "preSymbolizer.tiff"));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Raster Symbolizer ");
        }
        RasterSymbolizerSupport rsp = new RasterSymbolizerSupport(symbolizer);
        float alpha = rsp.getOpacity();
        Composite oldAlphaComposite = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(3, alpha));
        GridCoverage2D recoloredGridCoverage = (GridCoverage2D)rsp.recolorCoverage((GridCoverage)preSymbolizer);
        RenderedImage finalImage = recoloredGridCoverage.geophysics(false).getRenderedImage();
        AffineTransform finalGCgridToWorld = new AffineTransform((AffineTransform)((GridGeometry2D)recoloredGridCoverage.getGridGeometry()).getGridToCRS2D());
        if (!(finalGCgridToWorld instanceof AffineTransform)) {
            throw new UnsupportedOperationException("Non-affine transformations not yet implemented");
        }
        finalGCgridToWorld.translate(-0.5, -0.5);
        AffineTransform clonedFinalWorldToGrid = (AffineTransform)this.finalWorldToGrid.clone();
        clonedFinalWorldToGrid.concatenate(finalGCgridToWorld);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("clonedFinalWorldToGrid " + clonedFinalWorldToGrid.toString());
        }
        RenderingHints oldHints = graphics.getRenderingHints();
        graphics.setRenderingHints((Map<?, ?>)this.hints);
        try {
            graphics.drawRenderedImage(finalImage, clonedFinalWorldToGrid);
        }
        catch (Throwable t) {
            try {
                if (DEBUG) {
                    try {
                        ImageIO.write(finalImage, "tiff", new File(debugDir, "final0.tiff"));
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                BufferedImage buf = new BufferedImage(finalImage.getWidth(), finalImage.getHeight(), 6);
                Graphics2D g = (Graphics2D)buf.getGraphics();
                g.drawRenderedImage(finalImage, AffineTransform.getScaleInstance(1.0, 1.0));
                g.dispose();
                if (DEBUG) {
                    try {
                        ImageIO.write((RenderedImage)buf, "tiff", new File(debugDir, "final1.tiff"));
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                graphics.drawImage(buf, clonedFinalWorldToGrid, null);
                buf.flush();
            }
            catch (Throwable t1) {
                LOGGER.log(Level.WARNING, t1.getLocalizedMessage(), t1);
            }
        }
        float opacity = ((Double)((Literal)symbolizer.getOpacity()).getValue()).floatValue();
        graphics.setComposite(AlphaComposite.getInstance(6));
        Color c = new Color(0.0f, 0.0f, 0.0f, opacity);
        graphics.setColor(c);
        graphics.fillRect(0, 0, this.destinationSize.width, this.destinationSize.height);
        graphics.setComposite(oldAlphaComposite);
        graphics.setRenderingHints(oldHints);
    }

    private GridCoverage2D scale(double scaleX, double scaleY, float xTrans, float yTrans, Interpolation interpolation, BorderExtender be, GridCoverage2D gc) {
        ParameterValueGroup param = (ParameterValueGroup)scaleParams.clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("xScale").setValue((Object)new Float(scaleX));
        param.parameter("yScale").setValue((Object)new Float(scaleY));
        param.parameter("xTrans").setValue((Object)new Float(xTrans));
        param.parameter("yTrans").setValue((Object)new Float(yTrans));
        param.parameter("Interpolation").setValue((Object)interpolation);
        if (!(interpolation instanceof InterpolationNearest)) {
            param.parameter("BorderExtender").setValue((Object)be);
        }
        return (GridCoverage2D)scaleFactory.doOperation(param, this.hints);
    }

    private GridCoverage2D resample(GridCoverage2D gc, CoordinateReferenceSystem crs, Interpolation interpolation, GeneralEnvelope destinationEnvelope) {
        if (!$assertionsDisabled && !CRSUtilities.equalsIgnoreMetadata((Object)destinationEnvelope.getCoordinateReferenceSystem(), (Object)crs)) {
            throw new AssertionError();
        }
        ParameterValueGroup param = (ParameterValueGroup)resampleParams.clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("CoordinateReferenceSystem").setValue((Object)crs);
        param.parameter("GridGeometry").setValue((Object)new GridGeometry2D(gc.getGridGeometry().getGridRange(), (Envelope)destinationEnvelope));
        param.parameter("InterpolationType").setValue((Object)interpolation);
        return (GridCoverage2D)resampleFactory.doOperation(param, this.hints);
    }

    private GridCoverage2D filteredSubsample(GridCoverage2D gc, int scaleXInt, int scaleYInt, Interpolation interpolation, BorderExtender be) {
        GridCoverage2D preScaledGridCoverage;
        if (scaleXInt == 1 && scaleYInt == 1) {
            preScaledGridCoverage = gc;
        } else {
            ParameterValueGroup param = (ParameterValueGroup)filteredSubsampleParams.clone();
            param.parameter("source").setValue((Object)gc);
            param.parameter("scaleX").setValue((Object)new Integer(scaleXInt));
            param.parameter("scaleY").setValue((Object)new Integer(scaleYInt));
            if (this.hints.get((Object)JAI.KEY_INTERPOLATION) != null && this.hints.get((Object)JAI.KEY_INTERPOLATION).equals(new InterpolationNearest())) {
                param.parameter("qsFilterArray").setValue((Object)new float[]{1.0f});
            } else {
                param.parameter("qsFilterArray").setValue((Object)new float[]{0.5f, 0.33333334f, 0.0f, -0.083333336f});
            }
            param.parameter("Interpolation").setValue((Object)interpolation);
            if (!(interpolation instanceof InterpolationNearest)) {
                param.parameter("BorderExtender").setValue((Object)be);
            }
            preScaledGridCoverage = (GridCoverage2D)filteredSubsampleFactory.doOperation(param, this.hints);
        }
        return preScaledGridCoverage;
    }

    private GridCoverage2D getCroppedCoverage(GridCoverage2D gc, GeneralEnvelope envelope, CoordinateReferenceSystem crs) {
        try {
            GeneralEnvelope oldEnvelope = (GeneralEnvelope)gc.getEnvelope();
            GeneralEnvelope intersectionEnvelope = new GeneralEnvelope((Envelope)envelope);
            intersectionEnvelope.setCoordinateReferenceSystem(crs);
            intersectionEnvelope.intersect((Envelope)oldEnvelope);
            if (intersectionEnvelope.isEmpty()) {
                return null;
            }
            ParameterValueGroup param = (ParameterValueGroup)cropParams.clone();
            param.parameter("source").setValue((Object)gc);
            param.parameter("ConserveEnvelope").setValue((Object)Boolean.TRUE);
            param.parameter("Envelope").setValue((Object)intersectionEnvelope);
            return (GridCoverage2D)coverageCropFactory.doOperation(param, this.hints);
        }
        catch (CannotCropException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    private boolean isScaleTranslate(MathTransform transform) {
        if (!(transform instanceof AffineTransform)) {
            return false;
        }
        AffineTransform at = new AffineTransform((AffineTransform)transform);
        XAffineTransform.round((AffineTransform)at, (double)1.0E-6);
        double rotation = XAffineTransform.getRotation((AffineTransform)at);
        return rotation > 0.0;
    }

    static {
        $assertionsDisabled = !GridCoverageRenderer.class.desiredAssertionStatus();
        DEBUG = Boolean.getBoolean("org.geotools.renderer.lite.gridcoverage2d.debug");
        if (DEBUG) {
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            if (!tempDir.exists() || !tempDir.canWrite()) {
                System.out.println("Unable to create debug dir, exiting application!!!");
                System.exit(1);
                debugDir = null;
            } else {
                debugDir = tempDir.getAbsolutePath();
            }
        }
        scaleFactory = new Scale();
        filteredSubsampleFactory = new FilteredSubsample();
        coverageCropFactory = new Crop();
        LOGGER = Logger.getLogger("org.geotools.rendering");
        DefaultProcessor processor = new DefaultProcessor((RenderingHints)CoverageUtilities.LENIENT_HINT);
        resampleParams = processor.getOperation("Resample").getParameters();
        scaleParams = processor.getOperation("Scale").getParameters();
        cropParams = processor.getOperation("CoverageCrop").getParameters();
        filteredSubsampleParams = processor.getOperation("FilteredSubsample").getParameters();
        resampleFactory = new Resample();
    }
}

