/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.logging.Logger;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.FilterVisitor;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.opengis.filter.expression.Literal;

public class MetaBufferEstimator
extends FilterAttributeExtractor
implements StyleVisitor {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.rendering");
    boolean estimateAccurate = true;
    int buffer = 0;

    public void reset() {
        this.estimateAccurate = true;
        this.buffer = 0;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public boolean isEstimateAccurate() {
        return this.estimateAccurate;
    }

    public void visit(Style style) {
        FeatureTypeStyle[] ftStyles = style.getFeatureTypeStyles();
        for (int i = 0; i < ftStyles.length; ++i) {
            ftStyles[i].accept((StyleVisitor)this);
        }
    }

    public void visit(Rule rule) {
        Graphic[] legendGraphics;
        Symbolizer[] symbolizers;
        Filter filter = rule.getFilter();
        if (filter != null) {
            filter.accept((FilterVisitor)this);
        }
        if ((symbolizers = rule.getSymbolizers()) != null) {
            for (int i = 0; i < symbolizers.length; ++i) {
                Symbolizer symbolizer = symbolizers[i];
                symbolizer.accept((StyleVisitor)this);
            }
        }
        if ((legendGraphics = rule.getLegendGraphic()) != null) {
            // empty if block
        }
    }

    public void visit(FeatureTypeStyle fts) {
        Rule[] rules = fts.getRules();
        for (int i = 0; i < rules.length; ++i) {
            Rule rule = rules[i];
            rule.accept((StyleVisitor)this);
        }
    }

    public void visit(Fill fill) {
    }

    public void visit(Stroke stroke) {
        try {
            if (stroke.getWidth() != null) {
                if (stroke.getWidth() instanceof Literal) {
                    Literal lw = (Literal)stroke.getWidth();
                    int iw = (int)Math.ceil(((Number)lw.getValue()).doubleValue());
                    if (iw > this.buffer) {
                        this.buffer = iw;
                    }
                } else {
                    this.estimateAccurate = false;
                }
            }
        }
        catch (ClassCastException e) {
            this.estimateAccurate = false;
            LOGGER.info("Could not parse stroke width, it's a literal but not a Number...");
        }
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        }
        if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        }
        if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        }
        if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        }
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        }
    }

    public void visit(RasterSymbolizer rs) {
        if (rs.getGeometryPropertyName() != null) {
            this.attributeNames.add(rs.getGeometryPropertyName());
        }
        if (rs.getImageOutline() != null) {
            rs.getImageOutline().accept((StyleVisitor)this);
        }
        if (rs.getOpacity() != null) {
            rs.getOpacity().accept((FilterVisitor)this);
        }
    }

    public void visit(PointSymbolizer ps) {
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept((StyleVisitor)this);
        }
    }

    public void visit(LineSymbolizer line) {
        if (line.getStroke() != null) {
            line.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        if (poly.getStroke() != null) {
            poly.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(TextSymbolizer text) {
    }

    public void visit(Graphic gr) {
        try {
            if (gr.getSize() != null) {
                if (gr.getSize() instanceof Literal) {
                    Literal lw = (Literal)gr.getSize();
                    int iw = (int)Math.ceil(((Number)lw.getValue()).doubleValue());
                    if (iw > this.buffer) {
                        this.buffer = iw;
                    }
                } else {
                    this.estimateAccurate = false;
                }
            }
        }
        catch (ClassCastException e) {
            this.estimateAccurate = false;
            LOGGER.info("Could not parse graphic size, it's a literal but not a Number...");
        }
    }

    public void visit(Mark mark) {
    }

    public void visit(ExternalGraphic exgr) {
    }

    public void visit(PointPlacement pp) {
    }

    public void visit(AnchorPoint ap) {
    }

    public void visit(Displacement dis) {
    }

    public void visit(LinePlacement lp) {
    }

    public void visit(Halo halo) {
    }

    public void visit(StyledLayerDescriptor sld) {
        StyledLayer[] layers = sld.getStyledLayers();
        if (layers == null) {
            return;
        }
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i] instanceof NamedLayer) {
                ((NamedLayer)layers[i]).accept((StyleVisitor)this);
                continue;
            }
            if (!(layers[i] instanceof UserLayer)) continue;
            ((UserLayer)layers[i]).accept((StyleVisitor)this);
        }
    }

    public void visit(NamedLayer layer) {
        Style[] styles = layer.getStyles();
        if (styles == null) {
            return;
        }
        for (int i = 0; i < styles.length; ++i) {
            styles[i].accept((StyleVisitor)this);
        }
    }

    public void visit(UserLayer layer) {
        Style[] styles = layer.getUserStyles();
        if (styles == null) {
            return;
        }
        for (int i = 0; i < styles.length; ++i) {
            styles[i].accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeConstraint ftc) {
    }

    public void visit(ColorMap map) {
    }

    public void visit(ColorMapEntry entry) {
    }
}

