/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.renderer.lite.GlyphPropertiesList;
import org.geotools.renderer.lite.GlyphRenderer;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;

public class CustomGlyphRenderer
implements GlyphRenderer {
    private GlyphPropertiesList list = new GlyphPropertiesList();
    private boolean maxFound = false;
    private int maxBarHeight = 0;

    public CustomGlyphRenderer() {
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        this.list.addProperty("radius", Expression.class, factory.createLiteralExpression(50));
        this.list.addProperty("circle color", Expression.class, factory.createLiteralExpression("#000066"));
        this.list.addProperty("bar height", Expression.class, factory.createLiteralExpression(150));
        this.list.addProperty("bar color", Expression.class, factory.createLiteralExpression("#000000"));
        this.list.addProperty("bar uncertainty", Expression.class, factory.createLiteralExpression(50));
        this.list.addProperty("bar uncertainty width", Expression.class, factory.createLiteralExpression(5));
        this.list.addProperty("bar uncertainty color", Expression.class, factory.createLiteralExpression("#999999"));
        this.list.addProperty("pointer length", Expression.class, factory.createLiteralExpression(100));
        this.list.addProperty("pointer color", Expression.class, factory.createLiteralExpression("#FF0000"));
        this.list.addProperty("pointer direction", Expression.class, factory.createLiteralExpression(21));
        this.list.addProperty("wedge width", Expression.class, factory.createLiteralExpression(25));
        this.list.addProperty("wedge color", Expression.class, factory.createLiteralExpression("#9999FF"));
    }

    public boolean canRender(String format) {
        return format.equalsIgnoreCase("image/hack");
    }

    public List getFormats() {
        Vector<String> ret = new Vector<String>();
        ret.add("image/hack");
        return ret;
    }

    public String getGlyphName() {
        return "exploded clock";
    }

    public GlyphPropertiesList getGlyphProperties() {
        return this.list;
    }

    public void setGlyphProperties(GlyphPropertiesList gpl) {
        this.list = gpl;
    }

    public BufferedImage render(Graphic graphic, ExternalGraphic eg, Feature feature, int height) {
        Map props = eg.getCustomProperties();
        Set propNames = props.keySet();
        Iterator it = propNames.iterator();
        while (it.hasNext()) {
            String nextName = (String)it.next();
            if (this.list.hasProperty(nextName)) {
                this.list.setPropertyValue(nextName, props.get(nextName));
                continue;
            }
            System.out.println("Tried to set the property " + nextName + " to a glyph that does not have this property.");
        }
        int radius = 50;
        Expression e = (Expression)this.list.getPropertyValue("radius");
        if (e != null) {
            radius = ((Number)e.getValue(feature)).intValue();
        }
        Color circleColor = Color.BLUE.darker();
        e = (Expression)this.list.getPropertyValue("circle color");
        if (e != null) {
            circleColor = Color.decode((String)e.getValue(feature));
        }
        int barHeight = 150;
        e = (Expression)this.list.getPropertyValue("bar height");
        if (e != null) {
            barHeight = ((Number)e.getValue(feature)).intValue();
        }
        Color barColor = Color.BLACK;
        e = (Expression)this.list.getPropertyValue("bar color");
        if (e != null) {
            barColor = Color.decode((String)e.getValue(feature));
        }
        int barUncertainty = 50;
        e = (Expression)this.list.getPropertyValue("bar uncertainty");
        if (e != null) {
            barUncertainty = ((Number)e.getValue(feature)).intValue();
        }
        int barUncWidth = 5;
        e = (Expression)this.list.getPropertyValue("bar uncertainty width");
        if (e != null) {
            barUncWidth = ((Number)e.getValue(feature)).intValue();
        }
        Color barUncColor = Color.GRAY;
        e = (Expression)this.list.getPropertyValue("bar uncertainty color");
        if (e != null) {
            barUncColor = Color.decode((String)e.getValue(feature));
        }
        int pointerDirection = 21;
        e = (Expression)this.list.getPropertyValue("pointer direction");
        if (e != null) {
            pointerDirection = ((Number)e.getValue(feature)).intValue();
        }
        Color pointerColor = Color.RED;
        e = (Expression)this.list.getPropertyValue("pointer color");
        if (e != null) {
            pointerColor = Color.decode((String)e.getValue(feature));
        }
        int pointerLength = 100;
        e = (Expression)this.list.getPropertyValue("pointer length");
        if (e != null) {
            pointerLength = ((Number)e.getValue(feature)).intValue();
        }
        int wedgeWidth = 25;
        e = (Expression)this.list.getPropertyValue("wedge width");
        if (e != null) {
            wedgeWidth = ((Number)e.getValue(feature)).intValue();
        }
        Color wedgeColor = Color.BLUE;
        e = (Expression)this.list.getPropertyValue("wedge color");
        if (e != null) {
            wedgeColor = Color.decode((String)e.getValue(feature));
        }
        if (!this.maxFound) {
            this.maxFound = true;
            FeatureCollection fc = feature.getParent();
            FeatureIterator features = fc.features();
            while (features.hasNext()) {
                Feature next = features.next();
                Expression tempExp = (Expression)this.list.getPropertyValue("bar height");
                int temp1 = 0;
                if (tempExp != null) {
                    temp1 = ((Number)tempExp.getValue(next)).intValue();
                }
                tempExp = (Expression)this.list.getPropertyValue("bar uncertainty");
                int temp2 = 0;
                if (tempExp != null) {
                    temp2 = ((Number)tempExp.getValue(next)).intValue();
                }
                if (temp1 + temp2 <= this.maxBarHeight) continue;
                this.maxBarHeight = temp1 + temp2;
            }
        }
        int circleCenterX = Math.max(pointerLength, radius);
        int circleCenterY = Math.max(this.maxBarHeight, Math.max(pointerLength, radius));
        int imageHeight = Math.max(radius * 2, Math.max(radius + pointerLength, Math.max(radius + this.maxBarHeight, pointerLength + this.maxBarHeight)));
        int imageWidth = Math.max(radius * 2, pointerLength * 2);
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
        pointerLength = Math.max(pointerLength, radius);
        Graphics2D imageGraphic = image.createGraphics();
        imageGraphic.setColor(circleColor);
        imageGraphic.fillOval(circleCenterX - radius, circleCenterY - radius, radius * 2, radius * 2);
        imageGraphic.setColor(wedgeColor);
        imageGraphic.fillArc(circleCenterX - radius, circleCenterY - radius, radius * 2, radius * 2, this.calculateWedgeAngle(pointerDirection, wedgeWidth), wedgeWidth * 2);
        imageGraphic.setColor(barUncColor);
        imageGraphic.fillRect(circleCenterX - barUncWidth, circleCenterY - barHeight - barUncertainty, barUncWidth * 2, barUncertainty * 2);
        int[] endPoint = this.calculateEndOfPointer(circleCenterX, circleCenterY, pointerLength, pointerDirection);
        imageGraphic.setStroke(new BasicStroke(3.0f));
        imageGraphic.setColor(pointerColor);
        imageGraphic.draw(new Line2D.Double(circleCenterX, circleCenterY, endPoint[0], endPoint[1]));
        imageGraphic.setStroke(new BasicStroke(3.0f));
        imageGraphic.setColor(barColor);
        imageGraphic.draw(new Line2D.Double(circleCenterX, circleCenterY, circleCenterX, circleCenterY - barHeight));
        imageGraphic.dispose();
        return image;
    }

    private int calculateWedgeAngle(int pointerDirection, int wedgeWidth) {
        return 450 - (pointerDirection + wedgeWidth);
    }

    private int[] calculateEndOfPointer(int circleCenterX, int circleCenterY, int pointerLength, int pointerDirection) {
        int x = circleCenterX + (int)Math.round((double)pointerLength * Math.cos(Math.toRadians(pointerDirection - 90)));
        int y = circleCenterY + (int)Math.round((double)pointerLength * Math.sin(Math.toRadians(pointerDirection - 90)));
        return new int[]{x, y};
    }
}

