/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class LRULinkedHashMap
extends LinkedHashMap {
    private static final long serialVersionUID = 2082871604196698140L;
    private static final int DEFAULT_MAXIMUM_CAPACITY = 100;
    private final int maxEntries;

    public LRULinkedHashMap() {
        this.maxEntries = 100;
    }

    public LRULinkedHashMap(int initialCapacity) {
        super(initialCapacity);
        this.maxEntries = 100;
    }

    public LRULinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.maxEntries = 100;
    }

    public LRULinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maxEntries = 100;
    }

    public LRULinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder, int maxEntries) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maxEntries = maxEntries;
    }

    private LRULinkedHashMap(Map m) {
        super(m);
        this.maxEntries = 100;
        this.removeExtraEntries();
    }

    private LRULinkedHashMap(Map m, int maxEntries) {
        super(m);
        this.maxEntries = maxEntries;
        this.removeExtraEntries();
    }

    private void removeExtraEntries() {
        if (this.size() > this.maxEntries) {
            Iterator it = this.entrySet().iterator();
            for (int c = 0; c < this.maxEntries; ++c) {
                it.next();
            }
            while (it.hasNext()) {
                it.remove();
            }
        }
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return this.size() > this.maxEntries;
    }
}

