/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NIOUtilities {
    private static boolean warned = false;

    protected NIOUtilities() {
    }

    public static boolean clean(final ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return false;
        }
        Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Boolean success;
                block2: {
                    success = Boolean.FALSE;
                    try {
                        Method getCleanerMethod = buffer.getClass().getMethod("cleaner", null);
                        getCleanerMethod.setAccessible(true);
                        Object cleaner = getCleanerMethod.invoke((Object)buffer, (Object[])null);
                        Method clean = cleaner.getClass().getMethod("clean", null);
                        clean.invoke(cleaner, (Object[])null);
                        success = Boolean.TRUE;
                    }
                    catch (Exception e) {
                        if (!NIOUtilities.isLoggable()) break block2;
                        NIOUtilities.log(e, buffer);
                    }
                }
                return success;
            }
        });
        return b;
    }

    private static synchronized boolean isLoggable() {
        try {
            return !warned && (System.getProperty("org.geotools.io.debugBuffer", "false").equalsIgnoreCase("true") || System.getProperty("os.name").indexOf("Windows") >= 0);
        }
        catch (SecurityException exception) {
            return false;
        }
    }

    private static synchronized void log(Exception e, ByteBuffer buffer) {
        warned = true;
        String message = "Error attempting to close a mapped byte buffer : " + buffer.getClass().getName() + "\n JVM : " + System.getProperty("java.version") + ' ' + System.getProperty("java.vendor");
        Logger.getLogger("org.geotools.io").log(Level.SEVERE, message, e);
    }
}

