/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.util.Date;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;

public abstract class ClassChanger {
    private static final Class[] CLASS_RANK = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
    private static ClassChanger[] list = new ClassChanger[]{new ClassChanger(Date.class, Long.class){

        protected Number convert(Comparable object) {
            return new Long(((Date)object).getTime());
        }

        protected Comparable inverseConvert(Number value) {
            return new Date(value.longValue());
        }
    }};
    private final Class source;
    private final Class target;

    protected ClassChanger(Class source, Class target) {
        this.source = source;
        this.target = target;
        if (!Comparable.class.isAssignableFrom(source)) {
            throw new IllegalArgumentException(String.valueOf(source));
        }
        if (!Number.class.isAssignableFrom(target)) {
            throw new IllegalArgumentException(String.valueOf(target));
        }
    }

    protected abstract Number convert(Comparable var1) throws ClassCastException;

    protected abstract Comparable inverseConvert(Number var1);

    public String toString() {
        return "ClassChanger[" + this.source.getName() + "\u00a0\u21e8\u00a0" + this.target.getName() + ']';
    }

    public static synchronized void register(ClassChanger converter) throws IllegalStateException {
        int i;
        for (i = 0; i < list.length; ++i) {
            if (!ClassChanger.list[i].source.isAssignableFrom(converter.source)) continue;
            for (int j = i; j < list.length; ++j) {
                if (!ClassChanger.list[j].source.equals(converter.source)) continue;
                throw new IllegalStateException(list[j].toString());
            }
            break;
        }
        list = (ClassChanger[])XArray.insert(list, i, 1);
        ClassChanger.list[i] = converter;
    }

    private static synchronized ClassChanger getClassChanger(Class source) throws ClassNotFoundException {
        for (int i = 0; i < list.length; ++i) {
            if (!ClassChanger.list[i].source.isAssignableFrom(source)) continue;
            return list[i];
        }
        throw new ClassNotFoundException(source.getName());
    }

    public static synchronized Class getTransformedClass(Class source) {
        if (source != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!ClassChanger.list[i].source.isAssignableFrom(source)) continue;
                return ClassChanger.list[i].target;
            }
        }
        return source;
    }

    public static Number toNumber(Comparable object) throws ClassNotFoundException {
        if (object != null) {
            if (object instanceof Number) {
                return (Number)((Object)object);
            }
            return ClassChanger.getClassChanger(object.getClass()).convert(object);
        }
        return null;
    }

    public static Comparable toComparable(Number value, Class classe) throws ClassNotFoundException {
        if (value != null) {
            if (Number.class.isAssignableFrom(classe)) {
                return (Comparable)((Object)value);
            }
            return ClassChanger.getClassChanger(classe).inverseConvert(value);
        }
        return null;
    }

    public static Class toPrimitive(Class c) throws IllegalArgumentException {
        if (Double.class.equals(c)) {
            return Double.TYPE;
        }
        if (Float.class.equals(c)) {
            return Float.TYPE;
        }
        if (Long.class.equals(c)) {
            return Long.TYPE;
        }
        if (Integer.class.equals(c)) {
            return Integer.TYPE;
        }
        if (Short.class.equals(c)) {
            return Short.TYPE;
        }
        if (Byte.class.equals(c)) {
            return Byte.TYPE;
        }
        if (Boolean.class.equals(c)) {
            return Boolean.TYPE;
        }
        if (Character.class.equals(c)) {
            return Character.TYPE;
        }
        throw new IllegalArgumentException(Utilities.getShortName(c));
    }

    public static Class toWrapper(Class c) throws IllegalArgumentException {
        if (Double.TYPE.equals(c)) {
            return Double.class;
        }
        if (Float.TYPE.equals(c)) {
            return Float.class;
        }
        if (Long.TYPE.equals(c)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(c)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(c)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(c)) {
            return Byte.class;
        }
        if (Boolean.TYPE.equals(c)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(c)) {
            return Character.class;
        }
        throw new IllegalArgumentException(Utilities.getShortName(c));
    }

    public static Number cast(Number n, Class c) {
        if (n != null && !n.getClass().equals(c)) {
            if (Byte.class.equals(c)) {
                return new Byte(n.byteValue());
            }
            if (Short.class.equals(c)) {
                return new Short(n.shortValue());
            }
            if (Integer.class.equals(c)) {
                return new Integer(n.intValue());
            }
            if (Long.class.equals(c)) {
                return new Long(n.longValue());
            }
            if (Float.class.equals(c)) {
                return new Float(n.floatValue());
            }
            if (Double.class.equals(c)) {
                return new Double(n.doubleValue());
            }
            throw new IllegalArgumentException(Utilities.getShortName(c));
        }
        return n;
    }

    public static Class getWidestClass(Number n1, Number n2) {
        return ClassChanger.getWidestClass(n1 != null ? n1.getClass() : null, n2 != null ? n2.getClass() : null);
    }

    public static Class getWidestClass(Class c1, Class c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return CLASS_RANK[Math.max(ClassChanger.getRank(c1), ClassChanger.getRank(c2))];
    }

    public static Class getFinestClass(Class c1, Class c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return CLASS_RANK[Math.min(ClassChanger.getRank(c1), ClassChanger.getRank(c2))];
    }

    public static Class getFinestClass(double value) {
        float fv;
        long lg = (long)value;
        if (value == (double)lg) {
            if (lg >= -128L && lg <= 127L) {
                return Byte.class;
            }
            if (lg >= -32768L && lg <= 32767L) {
                return Short.class;
            }
            if (lg >= Integer.MIN_VALUE && lg <= Integer.MAX_VALUE) {
                return Integer.class;
            }
            if (lg >= -32768L && lg <= Long.MAX_VALUE) {
                return Long.class;
            }
        }
        if (value == (double)(fv = (float)value)) {
            return Float.class;
        }
        return Double.class;
    }

    private static int getRank(Class c) {
        for (int i = 0; i < CLASS_RANK.length; ++i) {
            if (!CLASS_RANK[i].isAssignableFrom(c)) continue;
            return i;
        }
        throw new IllegalArgumentException(Utilities.getShortName(c));
    }
}

