/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform1D;
import org.geotools.referencing.operation.transform.ConcatenatedTransform2D;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect2D;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;

public class ConcatenatedTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 5772066656987558634L;
    public final MathTransform transform1;
    public final MathTransform transform2;
    private ConcatenatedTransform inverse;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ConcatenatedTransform(MathTransform transform1, MathTransform transform2) {
        this.transform1 = transform1;
        this.transform2 = transform2;
        if (!this.isValid()) {
            throw new IllegalArgumentException(Errors.format(20, ConcatenatedTransform.getName(transform1), ConcatenatedTransform.getName(transform2)));
        }
    }

    private static XMatrix getMatrix(MathTransform transform) {
        if (transform instanceof LinearTransform) {
            return ConcatenatedTransform.toXMatrix(((LinearTransform)transform).getMatrix());
        }
        if (transform instanceof AffineTransform) {
            return new GeneralMatrix((AffineTransform)((Object)transform));
        }
        return null;
    }

    private static boolean areInverse(MathTransform tr1, MathTransform tr2) {
        if (tr2 instanceof AbstractMathTransform.Inverse) {
            return tr1.equals(((AbstractMathTransform.Inverse)tr2).inverse());
        }
        return false;
    }

    public static MathTransform create(MathTransform tr1, MathTransform tr2) {
        MathTransform optimized;
        ConcatenatedTransform ctr;
        XMatrix matrix2;
        int dim2;
        int dim1 = tr1.getTargetDimensions();
        if (dim1 != (dim2 = tr2.getSourceDimensions())) {
            throw new IllegalArgumentException(Errors.format(20, ConcatenatedTransform.getName(tr1), ConcatenatedTransform.getName(tr2)) + ' ' + Errors.format(68, new Integer(dim1), new Integer(dim2)));
        }
        if (tr1.isIdentity()) {
            return tr2;
        }
        if (tr2.isIdentity()) {
            return tr1;
        }
        XMatrix matrix1 = ConcatenatedTransform.getMatrix(tr1);
        if (matrix1 != null && (matrix2 = ConcatenatedTransform.getMatrix(tr2)) != null) {
            XMatrix matrix;
            int numRow = matrix2.getNumRow();
            int numCol = matrix1.getNumCol();
            if (numCol == matrix2.getNumCol()) {
                matrix = matrix2;
                matrix2.multiply(matrix1);
            } else {
                GeneralMatrix m = new GeneralMatrix(numRow, numCol);
                m.mul(ConcatenatedTransform.toGMatrix(matrix2), ConcatenatedTransform.toGMatrix(matrix1));
                matrix = m;
            }
            return ProjectiveTransform.create(matrix);
        }
        if (ConcatenatedTransform.areInverse(tr1, tr2) || ConcatenatedTransform.areInverse(tr2, tr1)) {
            if (!$assertionsDisabled && tr1.getSourceDimensions() != tr2.getTargetDimensions()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && tr1.getTargetDimensions() != tr2.getSourceDimensions()) {
                throw new AssertionError();
            }
            return IdentityTransform.create(tr1.getSourceDimensions());
        }
        if (tr1 instanceof ConcatenatedTransform) {
            ctr = (ConcatenatedTransform)tr1;
            tr1 = ctr.transform1;
            tr2 = ConcatenatedTransform.create(ctr.transform2, tr2);
        }
        if (tr2 instanceof ConcatenatedTransform) {
            ctr = (ConcatenatedTransform)tr2;
            tr1 = ConcatenatedTransform.create(tr1, ctr.transform1);
            tr2 = ctr.transform2;
        }
        if (tr1.isIdentity()) {
            return tr2;
        }
        if (tr2.isIdentity()) {
            return tr1;
        }
        if (tr1 instanceof AbstractMathTransform && (optimized = ((AbstractMathTransform)tr1).concatenate(tr2, false)) != null) {
            return optimized;
        }
        if (tr2 instanceof AbstractMathTransform && (optimized = ((AbstractMathTransform)tr2).concatenate(tr1, true)) != null) {
            return optimized;
        }
        return ConcatenatedTransform.createConcatenatedTransform(tr1, tr2);
    }

    static ConcatenatedTransform createConcatenatedTransform(MathTransform tr1, MathTransform tr2) {
        int dimSource = tr1.getSourceDimensions();
        int dimTarget = tr2.getTargetDimensions();
        if (dimSource == 1 && dimTarget == 1) {
            if (tr1 instanceof MathTransform1D && tr2 instanceof MathTransform1D) {
                return new ConcatenatedTransformDirect1D((MathTransform1D)tr1, (MathTransform1D)tr2);
            }
            return new ConcatenatedTransform1D(tr1, tr2);
        }
        if (dimSource == 2 && dimTarget == 2) {
            if (tr1 instanceof MathTransform2D && tr2 instanceof MathTransform2D) {
                return new ConcatenatedTransformDirect2D((MathTransform2D)tr1, (MathTransform2D)tr2);
            }
            return new ConcatenatedTransform2D(tr1, tr2);
        }
        if (dimSource == tr1.getTargetDimensions() && tr2.getSourceDimensions() == dimTarget) {
            return new ConcatenatedTransformDirect(tr1, tr2);
        }
        return new ConcatenatedTransform(tr1, tr2);
    }

    private static final String getName(MathTransform transform) {
        String name;
        ParameterValueGroup params;
        if (transform instanceof AbstractMathTransform && (params = ((AbstractMathTransform)transform).getParameterValues()) != null && (name = params.getDescriptor().getName().getCode()) != null && (name = name.trim()).length() != 0) {
            return name;
        }
        return Utilities.getShortClassName(transform);
    }

    boolean isValid() {
        return this.transform1.getTargetDimensions() == this.transform2.getSourceDimensions();
    }

    public final int getSourceDimensions() {
        return this.transform1.getSourceDimensions();
    }

    public final int getTargetDimensions() {
        return this.transform2.getTargetDimensions();
    }

    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        return this.transform2.transform(this.transform1.transform(ptSrc, null), ptDst);
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        double[] tmp = new double[numPts * this.transform1.getTargetDimensions()];
        this.transform1.transform(srcPts, srcOff, tmp, 0, numPts);
        this.transform2.transform(tmp, 0, dstPts, dstOff, numPts);
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        float[] tmp = new float[numPts * this.transform1.getTargetDimensions()];
        this.transform1.transform(srcPts, srcOff, tmp, 0, numPts);
        this.transform2.transform(tmp, 0, dstPts, dstOff, numPts);
    }

    public final synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        if (this.inverse == null) {
            this.inverse = ConcatenatedTransform.createConcatenatedTransform(this.transform2.inverse(), this.transform1.inverse());
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    public Matrix derivative(Point2D point) throws TransformException {
        return this.derivative(new GeneralDirectPosition(point));
    }

    public Matrix derivative(DirectPosition point) throws TransformException {
        XMatrix matrix;
        Matrix matrix1 = this.transform1.derivative(point);
        Matrix matrix2 = this.transform2.derivative(this.transform1.transform(point, null));
        int numRow = matrix2.getNumRow();
        int numCol = matrix1.getNumCol();
        if (numCol == matrix2.getNumCol()) {
            matrix = ConcatenatedTransform.toXMatrix(matrix2);
            matrix.multiply(matrix1);
        } else {
            GeneralMatrix m = new GeneralMatrix(numRow, numCol);
            m.mul(ConcatenatedTransform.toGMatrix(matrix2), ConcatenatedTransform.toGMatrix(matrix1));
            matrix = m;
        }
        return matrix;
    }

    public final boolean isIdentity() {
        return this.transform1.isIdentity() && this.transform2.isIdentity();
    }

    public final boolean isIdentity(double tolerance) {
        boolean identity = this.transform1 instanceof AbstractMathTransform ? ((AbstractMathTransform)this.transform1).isIdentity(tolerance) : (this.transform1 instanceof AffineTransform ? XAffineTransform.isIdentity((AffineTransform)((Object)this.transform1), tolerance) : this.transform1.isIdentity());
        if (!identity) {
            return false;
        }
        identity = this.transform2 instanceof AbstractMathTransform ? ((AbstractMathTransform)this.transform2).isIdentity(tolerance) : (this.transform2 instanceof AffineTransform ? XAffineTransform.isIdentity((AffineTransform)((Object)this.transform2), tolerance) : this.transform2.isIdentity());
        return identity;
    }

    public final int hashCode() {
        return this.transform1.hashCode() + 37 * this.transform2.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ConcatenatedTransform that = (ConcatenatedTransform)object;
            return Utilities.equals(this.transform1, that.transform1) && Utilities.equals(this.transform2, that.transform2);
        }
        return false;
    }

    protected String formatWKT(Formatter formatter) {
        ConcatenatedTransform.addWKT(formatter, this.transform1);
        ConcatenatedTransform.addWKT(formatter, this.transform2);
        return "CONCAT_MT";
    }

    private static void addWKT(Formatter formatter, MathTransform transform) {
        if (transform instanceof ConcatenatedTransform) {
            ConcatenatedTransform concat = (ConcatenatedTransform)transform;
            ConcatenatedTransform.addWKT(formatter, concat.transform1);
            ConcatenatedTransform.addWKT(formatter, concat.transform2);
        } else {
            formatter.append(transform);
        }
    }

    static {
        $assertionsDisabled = !ConcatenatedTransform.class.desiredAssertionStatus();
    }
}

