/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.projection.StereographicOblique;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public class StereographicEquatorial
extends StereographicOblique {
    static final double k0 = 2.0;
    static final /* synthetic */ boolean $assertionsDisabled;

    StereographicEquatorial(ParameterValueGroup parameters, Collection expected, short stereoType) throws ParameterNotFoundException {
        super(parameters, expected, stereoType);
        this.stereoType = stereoType;
        if (!$assertionsDisabled && ((StereographicOblique)this).k0 != 2.0) {
            throw new AssertionError(((StereographicOblique)this).k0);
        }
        this.latitudeOfOrigin = 0.0;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
            throw new AssertionError();
        }
        double chi = 2.0 * Math.atan(this.ssfn(y, Math.sin(y))) - 1.5707963267948966;
        double cosChi = Math.cos(chi);
        double A = 2.0 / (1.0 + cosChi * Math.cos(x));
        x = A * cosChi * Math.sin(x);
        y = A * Math.sin(chi);
        if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6 * this.globalScale)) {
            throw new AssertionError(x);
        }
        if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6 * this.globalScale)) {
            throw new AssertionError(y);
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    static {
        $assertionsDisabled = !StereographicEquatorial.class.desiredAssertionStatus();
    }

    static final class Spherical
    extends StereographicEquatorial {
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Spherical(ParameterValueGroup parameters, Collection expected, short stereoType) throws ParameterNotFoundException {
            super(parameters, expected, stereoType);
            if (!$assertionsDisabled && !this.isSpherical) {
                throw new AssertionError();
            }
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double coslat = Math.cos(y);
            double f = 1.0 + coslat * Math.cos(x);
            if (f < 1.0E-6) {
                throw new ProjectionException(Errors.format(146));
            }
            f = 2.0 / f;
            x = f * coslat * Math.sin(x);
            y = f * Math.sin(y);
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double rho = Math.sqrt(x * x + y * y);
            if (Math.abs(rho) < 1.0E-6) {
                y = 0.0;
                x = 0.0;
            } else {
                double c = 2.0 * Math.atan(rho / 2.0);
                double cosc = Math.cos(c);
                double sinc = Math.sin(c);
                y = Math.asin(y * sinc / rho);
                double t = x * sinc;
                double ct = rho * cosc;
                double d = x = Math.abs(t) < 1.0E-6 && Math.abs(ct) < 1.0E-6 ? 0.0 : Math.atan2(t, ct);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        static {
            $assertionsDisabled = !(class$org$geotools$referencing$operation$projection$StereographicEquatorial == null ? (class$org$geotools$referencing$operation$projection$StereographicEquatorial = StereographicEquatorial.class$("org.geotools.referencing.operation.projection.StereographicEquatorial")) : class$org$geotools$referencing$operation$projection$StereographicEquatorial).desiredAssertionStatus();
        }
    }
}

