/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;

public class EquidistantCylindrical
extends MapProjection {
    private final double cosStandardParallel;
    private final double standardParallel;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$opengis$referencing$operation$CylindricalProjection;

    protected EquidistantCylindrical(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        if (expected.contains(Provider.STANDARD_PARALLEL)) {
            this.standardParallel = Math.abs(this.doubleValue(expected, Provider.STANDARD_PARALLEL, parameters));
            EquidistantCylindrical.ensureLatitudeInRange(Provider.STANDARD_PARALLEL, this.standardParallel, false);
            this.cosStandardParallel = Math.cos(this.standardParallel);
        } else {
            this.standardParallel = Double.NaN;
            this.cosStandardParallel = 1.0;
        }
        if (!$assertionsDisabled && this.latitudeOfOrigin != 0.0) {
            throw new AssertionError(this.latitudeOfOrigin);
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        if (!Double.isNaN(this.standardParallel)) {
            List expected = this.getParameterDescriptors().descriptors();
            this.set(expected, Provider.STANDARD_PARALLEL, values, this.standardParallel);
        }
        return values;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        x *= this.cosStandardParallel;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        x /= this.cosStandardParallel;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.standardParallel);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            EquidistantCylindrical that = (EquidistantCylindrical)object;
            return EquidistantCylindrical.equals(this.standardParallel, that.standardParallel);
        }
        return false;
    }

    static {
        $assertionsDisabled = !EquidistantCylindrical.class.desiredAssertionStatus();
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Equidistant_Cylindrical"), new NamedIdentifier(Citations.EPSG, "Equidistant Cylindrical"), new NamedIdentifier(Citations.ESRI, "Equidistant_Cylindrical"), new NamedIdentifier(Citations.EPSG, "9823"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(221))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, STANDARD_PARALLEL, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$CylindricalProjection == null ? (class$org$opengis$referencing$operation$CylindricalProjection = EquidistantCylindrical.class$("org.opengis.referencing.operation.CylindricalProjection")) : class$org$opengis$referencing$operation$CylindricalProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
            if (Provider.isSpherical(parameters)) {
                return new EquidistantCylindrical(parameters);
            }
            throw new FactoryException(Errors.format(32));
        }
    }
}

