/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.factory.PropertyAuthorityFactory;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;

public class FactoryUsingWKT
extends DeferredAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory {
    public static final String FILENAME = "epsg.properties";
    private final FactoryGroup factories;

    public FactoryUsingWKT() {
        this((Hints)null);
    }

    public FactoryUsingWKT(Hints hints) {
        super(hints, 21);
        this.factories = FactoryGroup.createInstance(hints);
        this.setTimeout(900000L);
    }

    public Citation getAuthority() {
        return Citations.EPSG;
    }

    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        try {
            URL url = FactoryUsingWKT.class.getResource(FILENAME);
            if (url == null) {
                throw new FileNotFoundException(FILENAME);
            }
            LOGGER.log(Logging.format(Level.CONFIG, 27, url.getPath(), "EPSG"));
            return new PropertyAuthorityFactory(this.factories, this.getAuthority(), url);
        }
        catch (IOException exception) {
            throw new FactoryException(Errors.format(163, FILENAME), exception);
        }
    }
}

