/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.imageio.spi.ServiceRegistry;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.factory.JNDI;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.epsg.Console;
import org.geotools.referencing.factory.epsg.DataSource;
import org.geotools.referencing.factory.epsg.FactoryUsingSQL;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class DefaultFactory
extends DeferredAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    public static final String DATASOURCE_NAME = "jdbc/EPSG";
    private static final boolean ALLOW_REGISTRATION = false;
    private static FactoryRegistry datasources;
    static final int PRIORITY = 90;
    private static final Hints HINTS;
    private final FactoryGroup factories;
    private DataSource datasource;
    private Thread shutdown;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultFactory() {
        this((Hints)null);
    }

    public DefaultFactory(Hints hints) {
        super(hints, 90);
        this.factories = FactoryGroup.createInstance(hints);
        this.setTimeout(1800000L);
    }

    public Citation getAuthority() {
        Citation authority = super.getAuthority();
        return authority != null ? authority : Citations.EPSG;
    }

    public final synchronized DataSource getDataSource() throws SQLException {
        if (this.datasource == null && !super.isAvailable()) {
            throw new SQLException(Errors.format(156));
        }
        return this.datasource;
    }

    public synchronized void setDataSource(DataSource datasource) throws SQLException {
        if (datasource != this.datasource) {
            try {
                this.dispose();
            }
            catch (FactoryException exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                SQLException e = new SQLException(exception.getLocalizedMessage());
                e.initCause(exception);
                throw e;
            }
            this.datasource = datasource;
        }
    }

    private static synchronized Iterator getDataSources() {
        Class category;
        Class clazz = category = DataSource.class;
        if (datasources == null) {
            datasources = new FactoryRegistry(Collections.singleton(category));
            datasources.scanForPlugins();
            datasources.setOrdering(category, new Comparator(){

                public int compare(Object f1, Object f2) {
                    return ((DataSource)f1).getPriority() - ((DataSource)f2).getPriority();
                }
            });
        }
        return datasources.getServiceProviders(category, true);
    }

    private AbstractAuthorityFactory createFactory(DataSource source) throws SQLException {
        Hints sourceHints = new Hints(this.hints);
        sourceHints.putAll((Map<?, ?>)this.factories.getImplementationHints());
        return source.createFactory(sourceHints);
    }

    private AbstractAuthorityFactory createFactory() throws FactoryException, SQLException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.datasource != null) {
            return this.createFactory(this.datasource);
        }
        InitialContext context = null;
        DataSource source = null;
        boolean register = false;
        try {
            context = JNDI.getInitialContext(HINTS);
            source = (DataSource)context.lookup(DATASOURCE_NAME);
        }
        catch (NoInitialContextException exception) {
        }
        catch (NameNotFoundException exception) {
            register = context != null;
        }
        catch (NamingException exception) {
            SQLException e = new SQLException(Errors.format(155, DATASOURCE_NAME));
            e.initCause(exception);
            throw e;
        }
        Iterator sources = null;
        AbstractAuthorityFactory factory = null;
        SQLException failure = null;
        while (true) {
            block13: {
                if (source != null) {
                    try {
                        factory = this.createFactory(source);
                        break;
                    }
                    catch (SQLException exception) {
                        if (failure != null) break block13;
                        failure = exception;
                    }
                }
            }
            if (sources == null) {
                sources = DefaultFactory.getDataSources();
            }
            if (!sources.hasNext()) {
                if (failure != null) {
                    throw failure;
                }
                throw new FactoryNotFoundException(Errors.format(156));
            }
            source = (DataSource)sources.next();
        }
        this.datasource = source;
        return factory;
    }

    private static void log(LogRecord record) {
        record.setSourceMethodName(DefaultFactory.class.getName());
        record.setSourceMethodName("createBackingStore");
        LOGGER.log(record);
    }

    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        AbstractAuthorityFactory factory;
        String product;
        String url = product = '<' + Vocabulary.format(176) + '>';
        try {
            factory = this.createFactory();
            if (factory instanceof FactoryUsingSQL) {
                DatabaseMetaData info = ((FactoryUsingSQL)factory).connection.getMetaData();
                product = info.getDatabaseProductName();
                url = info.getURL();
            }
        }
        catch (SQLException exception) {
            throw new FactoryException(Errors.format(154, "EPSG"), exception);
        }
        DefaultFactory.log(Logging.format(Level.CONFIG, 37, url, product));
        if (factory instanceof FactoryUsingSQL) {
            ((FactoryUsingSQL)factory).buffered = this;
        }
        return factory;
    }

    protected boolean canDisposeBackingStore(AbstractAuthorityFactory backingStore) {
        if (backingStore instanceof FactoryUsingSQL) {
            return ((FactoryUsingSQL)backingStore).canDispose();
        }
        return super.canDisposeBackingStore(backingStore);
    }

    public synchronized void onRegistration(ServiceRegistry registry, Class category) {
        super.onRegistration(registry, category);
        if (this.shutdown == null) {
            this.shutdown = new ShutdownHook();
            Runtime.getRuntime().addShutdownHook(this.shutdown);
        }
    }

    public synchronized void onDeregistration(ServiceRegistry registry, Class category) {
        if (this.shutdown != null && registry.getServiceProviderByClass(this.getClass()) == null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdown);
            this.shutdown = null;
        }
        super.onDeregistration(registry, category);
    }

    public static void main(String[] args) {
        Console.main(args);
    }

    static {
        $assertionsDisabled = !DefaultFactory.class.desiredAssertionStatus();
        HINTS = null;
    }

    private final class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("EPSG factory shutdown");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DefaultFactory defaultFactory = DefaultFactory.this;
            synchronized (defaultFactory) {
                try {
                    DefaultFactory.this.dispose();
                }
                catch (FactoryException factoryException) {
                    // empty catch block
                }
            }
        }
    }
}

