/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.geotools.factory.Hints;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.util.DerivedSet;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.util.InternationalString;

public class PropertyAuthorityFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory {
    private final Citation authority;
    private final Properties definitions = new Properties();
    private final Set codes = Collections.unmodifiableSet(this.definitions.keySet());
    private transient Map filteredCodes;
    private transient Parser parser;

    public PropertyAuthorityFactory(FactoryGroup factories, Citation authority, URL definitions) throws IOException {
        super(factories, 11);
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        this.authority = authority;
        InputStream in = definitions.openStream();
        this.definitions.load(in);
        in.close();
    }

    public Citation getAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAuthorityCodes(Class type) throws FactoryException {
        if (type == null || type.isAssignableFrom(IdentifiedObject.class)) {
            return this.codes;
        }
        if (this.filteredCodes == null) {
            this.filteredCodes = new HashMap();
        }
        Map map = this.filteredCodes;
        synchronized (map) {
            Set filtered = (Set)this.filteredCodes.get(type);
            if (filtered == null) {
                filtered = new Codes(this.definitions, type);
                this.filteredCodes.put(type, filtered);
            }
            return filtered;
        }
    }

    public String getWKT(String code) throws NoSuchAuthorityCodeException {
        PropertyAuthorityFactory.ensureNonNull("code", code);
        String wkt = this.definitions.getProperty(this.trimAuthority(code));
        if (wkt == null) {
            throw this.noSuchAuthorityCode(IdentifiedObject.class, code);
        }
        return wkt.trim();
    }

    public InternationalString getDescriptionText(String code) throws NoSuchAuthorityCodeException, FactoryException {
        int end;
        String wkt = this.getWKT(code);
        int start = wkt.indexOf(34);
        if (start >= 0 && (end = wkt.indexOf(34, ++start)) >= 0) {
            return new SimpleInternationalString(wkt.substring(start, end).trim());
        }
        return null;
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.parser = new Parser();
        }
        return this.parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentifiedObject createObject(String code) throws NoSuchAuthorityCodeException, FactoryException {
        String wkt = this.getWKT(code);
        Parser parser = this.getParser();
        try {
            Parser parser2 = parser;
            synchronized (parser2) {
                parser.code = code;
                return (IdentifiedObject)parser.parseObject(wkt);
            }
        }
        catch (ParseException exception) {
            throw new FactoryException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws NoSuchAuthorityCodeException, FactoryException {
        String wkt = this.getWKT(code);
        Parser parser = this.getParser();
        try {
            Parser parser2 = parser;
            synchronized (parser2) {
                parser.code = code;
                return parser.parseCoordinateReferenceSystem(wkt);
            }
        }
        catch (ParseException exception) {
            throw new FactoryException(exception);
        }
    }

    private final class Parser
    extends org.geotools.referencing.wkt.Parser {
        String code;

        public Parser() {
            super(Symbols.DEFAULT, PropertyAuthorityFactory.this.factories);
        }

        protected Map alterProperties(Map properties) {
            Object candidate = properties.get("identifiers");
            if (candidate == null && this.code != null) {
                properties = new HashMap<String, NamedIdentifier>(properties);
                properties.put("identifiers", new NamedIdentifier(PropertyAuthorityFactory.this.authority, PropertyAuthorityFactory.this.trimAuthority(this.code)));
            }
            return super.alterProperties(properties);
        }
    }

    private static final class Codes
    extends DerivedSet {
        private final Class type;
        private final Map definitions;

        public Codes(Map definitions, Class type) {
            super(definitions.keySet());
            this.definitions = definitions;
            this.type = type;
        }

        protected Object baseToDerived(Object element) {
            int i;
            String key = (String)element;
            String wkt = (String)this.definitions.get(key);
            int length = wkt.length();
            for (i = 0; i < length && Character.isJavaIdentifierPart(wkt.charAt(i)); ++i) {
            }
            Class candidate = Parser.getClassOf(wkt.substring(0, i));
            if (candidate == null) {
                candidate = class$org$opengis$referencing$IdentifiedObject == null ? (class$org$opengis$referencing$IdentifiedObject = PropertyAuthorityFactory.class$("org.opengis.referencing.IdentifiedObject")) : class$org$opengis$referencing$IdentifiedObject;
            }
            return this.type.isAssignableFrom(candidate) ? key : null;
        }

        protected Object derivedToBase(Object element) {
            return element;
        }
    }
}

