/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.units.Unit;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.AuthorityFactoryAdapter;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

public class FallbackAuthorityFactory
extends AuthorityFactoryAdapter {
    private final AbstractAuthorityFactory fallback;

    protected FallbackAuthorityFactory(AuthorityFactory main, AuthorityFactory fallback) {
        super(main);
        this.fallback = FallbackAuthorityFactory.wrap(fallback);
    }

    protected FallbackAuthorityFactory(Collection factories) throws NoSuchElementException {
        this(factories.iterator());
    }

    private FallbackAuthorityFactory(Iterator fallbacks) throws NoSuchElementException {
        this((AuthorityFactory)fallbacks.next(), fallbacks);
    }

    private FallbackAuthorityFactory(AuthorityFactory main, Iterator fallbacks) throws NoSuchElementException {
        super(main);
        AuthorityFactory next = (AuthorityFactory)fallbacks.next();
        if (fallbacks.hasNext()) {
            next = new FallbackAuthorityFactory(next, fallbacks);
        }
        this.fallback = FallbackAuthorityFactory.wrap(next);
    }

    private static AbstractAuthorityFactory wrap(AuthorityFactory fallback) {
        FallbackAuthorityFactory.ensureNonNull("fallback", fallback);
        return fallback instanceof AbstractAuthorityFactory ? (AbstractAuthorityFactory)fallback : new AuthorityFactoryAdapter(fallback);
    }

    public static AuthorityFactory create(Class type, Collection factories) throws FactoryNotFoundException, ClassCastException {
        AuthorityFactory factory;
        FallbackAuthorityFactory.ensureNonNull("type", type);
        FallbackAuthorityFactory.ensureNonNull("factories", factories);
        switch (factories.size()) {
            case 0: {
                throw new FactoryNotFoundException(Errors.format(189, Utilities.getShortName(type)));
            }
            case 1: {
                factory = (AuthorityFactory)factories.iterator().next();
                break;
            }
            default: {
                factory = CRSAuthorityFactory.class.equals(type) ? new CRS(factories) : (CSAuthorityFactory.class.equals(type) ? new CS(factories) : (DatumAuthorityFactory.class.equals(type) ? new Datum(factories) : (CoordinateOperationAuthorityFactory.class.equals(type) ? new Operation(factories) : new FallbackAuthorityFactory(factories))));
            }
        }
        return factory;
    }

    public Set getAuthorityCodes(Class type) throws FactoryException {
        LinkedHashSet codes = new LinkedHashSet(super.getAuthorityCodes(type));
        codes.addAll(this.fallback.getAuthorityCodes(type));
        return codes;
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        try {
            return super.getDescriptionText(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.getDescriptionText(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        try {
            return super.createObject(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createObject(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public org.opengis.referencing.datum.Datum createDatum(String code) throws FactoryException {
        try {
            return super.createDatum(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createDatum(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        try {
            return super.createEngineeringDatum(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createEngineeringDatum(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public ImageDatum createImageDatum(String code) throws FactoryException {
        try {
            return super.createImageDatum(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createImageDatum(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        try {
            return super.createVerticalDatum(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createVerticalDatum(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        try {
            return super.createTemporalDatum(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createTemporalDatum(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        try {
            return super.createGeodeticDatum(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createGeodeticDatum(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        try {
            return super.createEllipsoid(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createEllipsoid(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        try {
            return super.createPrimeMeridian(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createPrimeMeridian(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public Extent createExtent(String code) throws FactoryException {
        try {
            return super.createExtent(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createExtent(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        try {
            return super.createCoordinateSystem(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createCoordinateSystem(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public CartesianCS createCartesianCS(String code) throws FactoryException {
        try {
            return super.createCartesianCS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createCartesianCS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public PolarCS createPolarCS(String code) throws FactoryException {
        try {
            return super.createPolarCS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createPolarCS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        try {
            return super.createCylindricalCS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createCylindricalCS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public SphericalCS createSphericalCS(String code) throws FactoryException {
        try {
            return super.createSphericalCS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createSphericalCS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        try {
            return super.createEllipsoidalCS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createEllipsoidalCS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public VerticalCS createVerticalCS(String code) throws FactoryException {
        try {
            return super.createVerticalCS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createVerticalCS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public TimeCS createTimeCS(String code) throws FactoryException {
        try {
            return super.createTimeCS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createTimeCS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        try {
            return super.createCoordinateSystemAxis(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createCoordinateSystemAxis(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public Unit createUnit(String code) throws FactoryException {
        try {
            return super.createUnit(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createUnit(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        try {
            return super.createCoordinateReferenceSystem(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createCoordinateReferenceSystem(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        try {
            return super.createCompoundCRS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createCompoundCRS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        try {
            return super.createDerivedCRS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createDerivedCRS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        try {
            return super.createEngineeringCRS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createEngineeringCRS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        try {
            return super.createGeographicCRS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createGeographicCRS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        try {
            return super.createGeocentricCRS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createGeocentricCRS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public ImageCRS createImageCRS(String code) throws FactoryException {
        try {
            return super.createImageCRS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createImageCRS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        try {
            return super.createProjectedCRS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createProjectedCRS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        try {
            return super.createTemporalCRS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createTemporalCRS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        try {
            return super.createVerticalCRS(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createVerticalCRS(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public ParameterDescriptor createParameterDescriptor(String code) throws FactoryException {
        try {
            return super.createParameterDescriptor(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createParameterDescriptor(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public OperationMethod createOperationMethod(String code) throws FactoryException {
        try {
            return super.createOperationMethod(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createOperationMethod(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        try {
            return super.createCoordinateOperation(code);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createCoordinateOperation(code);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    public Set createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        try {
            return super.createFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
        }
        catch (FactoryException exception) {
            try {
                return this.fallback.createFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
            }
            catch (FactoryException ignore) {
                throw exception;
            }
        }
    }

    private static final class Operation
    extends FallbackAuthorityFactory
    implements CoordinateOperationAuthorityFactory {
        Operation(Collection factories) {
            super(factories);
        }
    }

    private static final class Datum
    extends FallbackAuthorityFactory
    implements DatumAuthorityFactory {
        Datum(Collection factories) {
            super(factories);
        }
    }

    private static final class CS
    extends FallbackAuthorityFactory
    implements CSAuthorityFactory {
        CS(Collection factories) {
            super(factories);
        }
    }

    private static final class CRS
    extends FallbackAuthorityFactory
    implements CRSAuthorityFactory {
        CRS(Collection factories) {
            super(factories);
        }
    }
}

