/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.units.Unit;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

public class BufferedAuthorityFactory
extends AbstractAuthorityFactory {
    static final int DEFAULT_MAX = 20;
    AbstractAuthorityFactory backingStore;
    private final LinkedHashMap pool = new LinkedHashMap(32, 0.75f, true);
    private final int maxStrongReferences;

    protected BufferedAuthorityFactory(AbstractAuthorityFactory factory) {
        this(factory, 20);
    }

    protected BufferedAuthorityFactory(AbstractAuthorityFactory factory, int maxStrongReferences) {
        super(factory.getPriority());
        while (factory instanceof BufferedAuthorityFactory) {
            factory = ((BufferedAuthorityFactory)factory).backingStore;
        }
        this.backingStore = factory;
        this.maxStrongReferences = maxStrongReferences;
        this.completeHints();
    }

    BufferedAuthorityFactory(int priority, int maxStrongReferences) {
        super(priority);
        this.maxStrongReferences = maxStrongReferences;
    }

    final void completeHints() {
        if (this.backingStore instanceof DatumAuthorityFactory) {
            this.hints.put(Hints.DATUM_AUTHORITY_FACTORY, this.backingStore);
        }
        if (this.backingStore instanceof CSAuthorityFactory) {
            this.hints.put(Hints.CS_AUTHORITY_FACTORY, this.backingStore);
        }
        if (this.backingStore instanceof CRSAuthorityFactory) {
            this.hints.put(Hints.CRS_AUTHORITY_FACTORY, this.backingStore);
        }
        if (this.backingStore instanceof CoordinateOperationAuthorityFactory) {
            this.hints.put(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, this.backingStore);
        }
    }

    AbstractAuthorityFactory getBackingStore() throws FactoryException {
        if (this.backingStore == null) {
            throw new FactoryException(Errors.format(161));
        }
        return this.backingStore;
    }

    synchronized boolean isAvailable() {
        try {
            return this.getBackingStore().isAvailable();
        }
        catch (FactoryNotFoundException exception) {
        }
        catch (FactoryException exception) {
            Citation citation = this.getAuthority();
            Collection titles = citation.getAlternateTitles();
            InternationalString title = citation.getTitle();
            if (titles != null) {
                Iterator it = titles.iterator();
                while (it.hasNext()) {
                    InternationalString candidate = (InternationalString)it.next();
                    if (candidate.length() <= title.length()) continue;
                    title = candidate;
                }
            }
            LogRecord record = Logging.format(Level.WARNING, 34, title);
            record.setSourceClassName(Utilities.getShortClassName(this));
            record.setSourceMethodName("isAvailable");
            record.setThrown(exception);
            LOGGER.log(record);
        }
        return false;
    }

    public synchronized Citation getVendor() {
        return this.backingStore != null ? this.backingStore.getVendor() : super.getVendor();
    }

    public synchronized Citation getAuthority() {
        return this.backingStore != null ? this.backingStore.getAuthority() : null;
    }

    public synchronized String getBackingStoreDescription() throws FactoryException {
        return this.getBackingStore().getBackingStoreDescription();
    }

    public synchronized Set getAuthorityCodes(Class type) throws FactoryException {
        return this.getBackingStore().getAuthorityCodes(type);
    }

    public synchronized InternationalString getDescriptionText(String code) throws FactoryException {
        return this.getBackingStore().getDescriptionText(code);
    }

    public synchronized IdentifiedObject createObject(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        IdentifiedObject object = cached instanceof IdentifiedObject ? (IdentifiedObject)cached : this.getBackingStore().createObject(code);
        this.put(key, object);
        return object;
    }

    public synchronized Datum createDatum(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        Datum datum = cached instanceof Datum ? (Datum)cached : this.getBackingStore().createDatum(code);
        this.put(key, datum);
        return datum;
    }

    public synchronized EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        EngineeringDatum datum = cached instanceof EngineeringDatum ? (EngineeringDatum)cached : this.getBackingStore().createEngineeringDatum(code);
        this.put(key, datum);
        return datum;
    }

    public synchronized ImageDatum createImageDatum(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        ImageDatum datum = cached instanceof ImageDatum ? (ImageDatum)cached : this.getBackingStore().createImageDatum(code);
        this.put(key, datum);
        return datum;
    }

    public synchronized VerticalDatum createVerticalDatum(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        VerticalDatum datum = cached instanceof VerticalDatum ? (VerticalDatum)cached : this.getBackingStore().createVerticalDatum(code);
        this.put(key, datum);
        return datum;
    }

    public synchronized TemporalDatum createTemporalDatum(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        TemporalDatum datum = cached instanceof TemporalDatum ? (TemporalDatum)cached : this.getBackingStore().createTemporalDatum(code);
        this.put(key, datum);
        return datum;
    }

    public synchronized GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        GeodeticDatum datum = cached instanceof GeodeticDatum ? (GeodeticDatum)cached : this.getBackingStore().createGeodeticDatum(code);
        this.put(key, datum);
        return datum;
    }

    public synchronized Ellipsoid createEllipsoid(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        Ellipsoid ellipsoid = cached instanceof Ellipsoid ? (Ellipsoid)cached : this.getBackingStore().createEllipsoid(code);
        this.put(key, ellipsoid);
        return ellipsoid;
    }

    public synchronized PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        PrimeMeridian meridian = cached instanceof PrimeMeridian ? (PrimeMeridian)cached : this.getBackingStore().createPrimeMeridian(code);
        this.put(key, meridian);
        return meridian;
    }

    public synchronized Extent createExtent(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        Extent extent = cached instanceof Extent ? (Extent)cached : this.getBackingStore().createExtent(code);
        this.put(key, extent);
        return extent;
    }

    public synchronized CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        CoordinateSystem cs = cached instanceof CoordinateSystem ? (CoordinateSystem)cached : this.getBackingStore().createCoordinateSystem(code);
        this.put(key, cs);
        return cs;
    }

    public synchronized CartesianCS createCartesianCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        CartesianCS cs = cached instanceof CartesianCS ? (CartesianCS)cached : this.getBackingStore().createCartesianCS(code);
        this.put(key, cs);
        return cs;
    }

    public synchronized PolarCS createPolarCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        PolarCS cs = cached instanceof PolarCS ? (PolarCS)cached : this.getBackingStore().createPolarCS(code);
        this.put(key, cs);
        return cs;
    }

    public synchronized CylindricalCS createCylindricalCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        CylindricalCS cs = cached instanceof CylindricalCS ? (CylindricalCS)cached : this.getBackingStore().createCylindricalCS(code);
        this.put(key, cs);
        return cs;
    }

    public synchronized SphericalCS createSphericalCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        SphericalCS cs = cached instanceof SphericalCS ? (SphericalCS)cached : this.getBackingStore().createSphericalCS(code);
        this.put(key, cs);
        return cs;
    }

    public synchronized EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        EllipsoidalCS cs = cached instanceof EllipsoidalCS ? (EllipsoidalCS)cached : this.getBackingStore().createEllipsoidalCS(code);
        this.put(key, cs);
        return cs;
    }

    public synchronized VerticalCS createVerticalCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        VerticalCS cs = cached instanceof VerticalCS ? (VerticalCS)cached : this.getBackingStore().createVerticalCS(code);
        this.put(key, cs);
        return cs;
    }

    public synchronized TimeCS createTimeCS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        TimeCS cs = cached instanceof TimeCS ? (TimeCS)cached : this.getBackingStore().createTimeCS(code);
        this.put(key, cs);
        return cs;
    }

    public synchronized CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        CoordinateSystemAxis axis = cached instanceof CoordinateSystemAxis ? (CoordinateSystemAxis)cached : this.getBackingStore().createCoordinateSystemAxis(code);
        this.put(key, axis);
        return axis;
    }

    public synchronized Unit createUnit(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        Unit unit = cached instanceof Unit ? (Unit)cached : this.getBackingStore().createUnit(code);
        this.put(key, unit);
        return unit;
    }

    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        CoordinateReferenceSystem crs = cached instanceof CoordinateReferenceSystem ? (CoordinateReferenceSystem)cached : this.getBackingStore().createCoordinateReferenceSystem(code);
        this.put(key, crs);
        return crs;
    }

    public synchronized CompoundCRS createCompoundCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        CompoundCRS crs = cached instanceof CompoundCRS ? (CompoundCRS)cached : this.getBackingStore().createCompoundCRS(code);
        this.put(key, crs);
        return crs;
    }

    public synchronized DerivedCRS createDerivedCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        DerivedCRS crs = cached instanceof DerivedCRS ? (DerivedCRS)cached : this.getBackingStore().createDerivedCRS(code);
        this.put(key, crs);
        return crs;
    }

    public synchronized EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        EngineeringCRS crs = cached instanceof EngineeringCRS ? (EngineeringCRS)cached : this.getBackingStore().createEngineeringCRS(code);
        this.put(key, crs);
        return crs;
    }

    public synchronized GeographicCRS createGeographicCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        GeographicCRS crs = cached instanceof GeographicCRS ? (GeographicCRS)cached : this.getBackingStore().createGeographicCRS(code);
        this.put(key, crs);
        return crs;
    }

    public synchronized GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        GeocentricCRS crs = cached instanceof GeocentricCRS ? (GeocentricCRS)cached : this.getBackingStore().createGeocentricCRS(code);
        this.put(key, crs);
        return crs;
    }

    public synchronized ImageCRS createImageCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        ImageCRS crs = cached instanceof ImageCRS ? (ImageCRS)cached : this.getBackingStore().createImageCRS(code);
        this.put(key, crs);
        return crs;
    }

    public synchronized ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        ProjectedCRS crs = cached instanceof ProjectedCRS ? (ProjectedCRS)cached : this.getBackingStore().createProjectedCRS(code);
        this.put(key, crs);
        return crs;
    }

    public synchronized TemporalCRS createTemporalCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        TemporalCRS crs = cached instanceof TemporalCRS ? (TemporalCRS)cached : this.getBackingStore().createTemporalCRS(code);
        this.put(key, crs);
        return crs;
    }

    public synchronized VerticalCRS createVerticalCRS(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        VerticalCRS crs = cached instanceof VerticalCRS ? (VerticalCRS)cached : this.getBackingStore().createVerticalCRS(code);
        this.put(key, crs);
        return crs;
    }

    public synchronized ParameterDescriptor createParameterDescriptor(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        ParameterDescriptor parameter = cached instanceof ParameterDescriptor ? (ParameterDescriptor)cached : this.getBackingStore().createParameterDescriptor(code);
        this.put(key, parameter);
        return parameter;
    }

    public synchronized OperationMethod createOperationMethod(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        OperationMethod method = cached instanceof OperationMethod ? (OperationMethod)cached : this.getBackingStore().createOperationMethod(code);
        this.put(key, method);
        return method;
    }

    public synchronized CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        String key = this.trimAuthority(code);
        Object cached = this.get(key);
        CoordinateOperation operation = cached instanceof CoordinateOperation ? (CoordinateOperation)cached : this.getBackingStore().createCoordinateOperation(code);
        this.put(key, operation);
        return operation;
    }

    public synchronized Set createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        CodePair key = new CodePair(this.trimAuthority(sourceCode), this.trimAuthority(targetCode));
        Object cached = this.get(key);
        Set operations = cached instanceof CoordinateOperation ? (Set)cached : Collections.unmodifiableSet(this.getBackingStore().createFromCoordinateReferenceSystemCodes(sourceCode, targetCode));
        this.put(key, operations);
        return operations;
    }

    public synchronized void dispose() throws FactoryException {
        if (this.backingStore != null) {
            this.backingStore.dispose();
            this.backingStore = null;
        }
        this.pool.clear();
        super.dispose();
    }

    private Object get(Object key) {
        Object object = this.pool.get(key);
        if (object instanceof Reference) {
            object = ((Reference)object).get();
        }
        return object;
    }

    private void put(Object key, Object object) {
        this.pool.put(key, object);
        int toReplace = this.pool.size() - this.maxStrongReferences;
        if (toReplace > 0) {
            Iterator it = this.pool.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object value = entry.getValue();
                if (value instanceof Reference) {
                    if (((Reference)value).get() != null) continue;
                    it.remove();
                    continue;
                }
                entry.setValue(new WeakReference(value));
                if (--toReplace != 0) continue;
                break;
            }
        }
    }

    private static final class CodePair {
        private final String source;
        private final String target;

        public CodePair(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public int hashCode() {
            int code = 0;
            if (this.source != null) {
                code = this.source.hashCode();
            }
            if (this.target != null) {
                code += this.target.hashCode() * 37;
            }
            return code;
        }

        public boolean equals(Object other) {
            if (other instanceof CodePair) {
                CodePair that = (CodePair)other;
                return Utilities.equals(this.source, that.source) && Utilities.equals(this.target, that.target);
            }
            return false;
        }

        public String toString() {
            return this.source + " \u21e8 " + this.target;
        }
    }
}

